/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.pdfviewer.action;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kinggrid.encrypt.KGBase64;
import com.kinggrid.exception.KGServerInterfaceErrorException;
import com.kinggrid.kgcore.gm.SealGM;
import com.kinggrid.kgcore.gm.SealUtil;
import com.kinggrid.pdfviewer.PdfActionInter;
import com.kinggrid.pdfviewer.PdfFileResource;
import com.kinggrid.pdfviewer.utils.ConnectSignatureQrcode;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class GetQrCodeUserInfoAction
implements PdfActionInter {
    @Override
    public void execute(HttpServletRequest request, HttpServletResponse response, String action, JSONObject params, PdfFileResource pdfFileResource) throws IOException {
        JSONObject retObj = new JSONObject();
        try {
            JSONObject qrCodeUserInfoObject = ConnectSignatureQrcode.getQrCodeUserInfo(params.getString("qrcode"));
            int code = qrCodeUserInfoObject.getIntValue("code");
            if (code != 0) {
                retObj.put("status", (Object)true);
                retObj.put("code", (Object)code);
                retObj.put("message", (Object)qrCodeUserInfoObject.getString("message"));
                response.getWriter().write(JSONObject.toJSONString((Object)retObj));
                return;
            }
            JSONObject userInfoObject = qrCodeUserInfoObject.getJSONObject("userInfo");
            String qrCodeUserUid = userInfoObject.getString("userUid");
            String qrCodeUserName = userInfoObject.getString("qrCodeUserName");
            String qrCodeUid = qrCodeUserInfoObject.getString("qrCodeUid");
            JSONArray sealDatas = qrCodeUserInfoObject.getJSONArray("sealDatas");
            KGBase64 base64 = new KGBase64();
            JSONArray sealsArray = new JSONArray();
            if (sealDatas != null) {
                for (int i = 0; i < sealDatas.size(); ++i) {
                    JSONObject jObject = sealDatas.getJSONObject(i);
                    String sealData = jObject.getString("sealData");
                    SealGM seal = SealUtil.getSealInfo((byte[])base64.decode(sealData));
                    JSONObject sealObj = new JSONObject();
                    sealObj.put("keySN", (Object)jObject.getString("keysn"));
                    sealObj.put("unitName", (Object)"");
                    sealObj.put("esid", (Object)jObject.getString("esid"));
                    sealObj.put("signName", (Object)seal.getName());
                    sealObj.put("width", (Object)Float.valueOf((float)seal.getWidth() * 2.8346457f));
                    sealObj.put("height", (Object)Float.valueOf((float)seal.getHeight() * 2.8346457f));
                    String imgType = seal.getPicType();
                    sealObj.put("imgExt", (Object)imgType);
                    sealObj.put("signSN", (Object)"");
                    String imgdata = base64.encode(seal.getPicData());
                    sealObj.put("imgdata", (Object)("data:image/" + imgType + ";base64," + imgdata));
                    sealObj.put("sealData", (Object)sealData);
                    sealObj.put("version", (Object)seal.getVersion());
                    if (jObject.getBooleanValue("isGmSeal")) {
                        sealObj.put("sealtag", (Object)"GM");
                    } else {
                        sealObj.put("sealtag", (Object)"GB");
                    }
                    sealsArray.add((Object)sealObj);
                }
            }
            retObj.put("status", (Object)true);
            retObj.put("code", (Object)code);
            retObj.put("qrCodeUserUid", (Object)qrCodeUserUid);
            retObj.put("qrCodeUserName", (Object)qrCodeUserName);
            retObj.put("qrCodeUid", (Object)qrCodeUid);
            retObj.put("seal", (Object)sealsArray);
        }
        catch (Exception e) {
            if (e instanceof KGServerInterfaceErrorException) {
                retObj.put("status", (Object)false);
                retObj.put("message", (Object)e.getMessage());
            }
            throw new RuntimeException(e.getMessage(), e);
        }
        response.getWriter().write(JSONObject.toJSONString((Object)retObj));
    }
}

