/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.pdfviewer.action;

import com.KGitextpdf.text.Rectangle;
import com.KGitextpdf.text.pdf.PRIndirectReference;
import com.KGitextpdf.text.pdf.PRStream;
import com.KGitextpdf.text.pdf.PdfArray;
import com.KGitextpdf.text.pdf.PdfDictionary;
import com.KGitextpdf.text.pdf.PdfName;
import com.KGitextpdf.text.pdf.PdfObject;
import com.KGitextpdf.text.pdf.PdfReader;
import com.KGitextpdf.text.pdf.PdfStream;
import com.KGitextpdf.text.pdf.parser.PdfImageObject;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kinggrid.commons.KGDateUtils;
import com.kinggrid.pdf.KGPdfHummer;
import com.kinggrid.pdfviewer.PdfActionInter;
import com.kinggrid.pdfviewer.PdfFileResource;
import com.kinggrid.pdfviewer.PdfFileResourceManager;
import com.kinggrid.pdfviewer.pdf.PdfUtils;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.kg.bouncycastle.util.encoders.Hex;

public class GetAnnotsListAction
implements PdfActionInter {
    @Override
    public void execute(HttpServletRequest request, HttpServletResponse response, String action, JSONObject params, PdfFileResource pdfFileResource) throws IOException {
        String documentId = params.getString("documentId");
        if (pdfFileResource == null) {
            pdfFileResource = PdfFileResourceManager.getPdfFileResource();
        }
        pdfFileResource.init(request, response, action, documentId);
        JSONArray jArray = this.getStampAnnotsList(pdfFileResource, params);
        response.getWriter().write(jArray.toJSONString());
    }

    private JSONArray getStampAnnotsList(PdfFileResource pdfFileResource, JSONObject params) {
        KGPdfHummer hummer = null;
        InputStream in = null;
        JSONArray jArray = new JSONArray();
        try {
            String pdfFile = pdfFileResource.getPdfFile();
            in = pdfFileResource.getPdfFileStream();
            hummer = PdfUtils.getPdfHummerOfRead(pdfFile, in, params.getString("pdfPwd"));
            PdfReader pdfReader = hummer.getPdfReader();
            for (int i = pdfReader.getNumberOfPages(); i > 0; --i) {
                PdfDictionary page = pdfReader.getPageN(i);
                PdfArray annots = page.getAsArray(PdfName.ANNOTS);
                if (annots == null || annots.size() == 0) continue;
                for (int j = 0; j < annots.size(); ++j) {
                    PdfDictionary annot = annots.getAsDict(j);
                    if (!PdfName.ANNOT.equals((Object)annot.getAsName(PdfName.TYPE)) || !PdfName.STAMP.equals((Object)annot.getAsName(PdfName.SUBTYPE))) continue;
                    Rectangle pageRect = pdfReader.getPageSizeWithRotation(page);
                    PdfArray rectArray = annot.getAsArray(PdfName.RECT);
                    Rectangle annotRect = new Rectangle(rectArray.getAsNumber(0).floatValue(), rectArray.getAsNumber(1).floatValue(), rectArray.getAsNumber(2).floatValue(), rectArray.getAsNumber(3).floatValue());
                    float x = annotRect.getLeft();
                    float y = pageRect.getHeight() - annotRect.getTop();
                    JSONObject jObject = new JSONObject();
                    jObject.put("authorName", (Object)annot.getAsString(PdfName.T).toUnicodeString());
                    jObject.put("styleName", (Object)"Stamp");
                    jObject.put("pageNo", (Object)i);
                    jObject.put("X", (Object)Float.valueOf(x));
                    jObject.put("Y", (Object)Float.valueOf(y));
                    jObject.put("width", (Object)Float.valueOf(annotRect.getWidth()));
                    jObject.put("height", (Object)Float.valueOf(annotRect.getHeight()));
                    jObject.put("createTime", (Object)this.parseCreationDate(annot.getAsString(PdfName.CREATIONDATE).toUnicodeString()));
                    if (annot.getAsString(PdfName.NM) != null) {
                        jObject.put("uniqueName", (Object)annot.getAsString(PdfName.NM).toString());
                    }
                    if (annot.getAsString(new PdfName("AnnotInfo")) != null) {
                        jObject.put("annotInfo", (Object)annot.getAsString(new PdfName("AnnotInfo")).toUnicodeString());
                    }
                    PdfStream n = annot.getAsDict(PdfName.AP).getAsStream(PdfName.N);
                    PdfDictionary xobject = n.getAsDict(PdfName.RESOURCES).getAsDict(PdfName.XOBJECT);
                    HashMap<PdfName, PRStream> map = new HashMap<PdfName, PRStream>();
                    this.getImageOrXfObj(map, xobject);
                    if (map.containsKey(PdfName.IMAGE)) {
                        PdfImageObject pdfImageObject = new PdfImageObject((PRStream)map.get(PdfName.IMAGE));
                        byte[] imageData = this.getImageDataFromPdfImageObject(pdfImageObject);
                        jObject.put("annotSignature", (Object)new String(Hex.encode((byte[])imageData)));
                        PdfDictionary imageDictionary = pdfImageObject.getDictionary();
                        if (imageDictionary.getAsStream(PdfName.SMASK) != null) {
                            PRStream smaskStream = (PRStream)imageDictionary.getAsStream(PdfName.SMASK);
                            PdfImageObject smaskObject = new PdfImageObject(smaskStream);
                            jObject.put("smaskData", (Object)new String(Hex.encode((byte[])smaskObject.getImageAsBytes())));
                        }
                    } else {
                        byte[] markObjectData = PdfReader.getStreamBytes((PRStream)((PRStream)map.get(PdfName.FORM)));
                        jObject.put("annotContent", (Object)new String(markObjectData));
                    }
                    jArray.add((Object)jObject);
                }
            }
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                PdfUtils.close(in);
                if (hummer != null) {
                    hummer.close();
                }
                throw throwable;
            }
        }
        PdfUtils.close(in);
        if (hummer != null) {
            hummer.close();
        }
        return jArray;
    }

    private Map<PdfName, PRStream> getImageOrXfObj(Map<PdfName, PRStream> map, PdfDictionary xobject) {
        Set entries = xobject.getKeyValSet();
        Iterator iterator = entries.iterator();
        PRStream obj = null;
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            PRIndirectReference ref = (PRIndirectReference)entry.getValue();
            PRStream pdfObject = obj = (PRStream)PdfReader.getPdfObject((PdfObject)ref);
            PdfName subType = pdfObject.getAsName(PdfName.SUBTYPE);
            PdfDictionary resource = pdfObject.getAsDict(PdfName.RESOURCES);
            if (subType != null && "/Image".equals(subType.toString())) {
                map.put(PdfName.IMAGE, obj);
                return map;
            }
            if (resource == null || resource.getAsDict(PdfName.XOBJECT) == null) {
                map.put(PdfName.FORM, obj);
                return map;
            }
            if ((map = this.getImageOrXfObj(map, pdfObject.getAsDict(PdfName.RESOURCES).getAsDict(PdfName.XOBJECT))).size() == 0) continue;
            break;
        }
        return map;
    }

    private byte[] getImageDataFromPdfImageObject(PdfImageObject pdfImageObject) throws IOException {
        PdfName filter = (PdfName)pdfImageObject.get(PdfName.FILTER);
        byte[] imageData = null;
        if (PdfName.DCTDECODE.equals((Object)filter) || PdfName.JPXDECODE.equals((Object)filter)) {
            imageData = pdfImageObject.getImageAsBytes();
        } else {
            BufferedImage bufferedImage = pdfImageObject.getBufferedImage();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bufferedImage, "png", byteArrayOutputStream);
            imageData = byteArrayOutputStream.toByteArray();
        }
        return imageData;
    }

    private String parseCreationDate(String creationDate) {
        if (creationDate.indexOf("+") != -1) {
            String dateStr = creationDate.substring(2, creationDate.indexOf("+"));
            Date date = KGDateUtils.parse2Date((String)dateStr, (String)"yyyyMMddHHmmss");
            return KGDateUtils.dateTime((Date)date);
        }
        return creationDate;
    }
}

