/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.pdfviewer.action;

import com.KGitextpdf.text.BaseColor;
import com.KGitextpdf.text.DocumentException;
import com.KGitextpdf.text.Image;
import com.KGitextpdf.text.pdf.BaseFont;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kgofd.ofd.KGOfdHummer;
import com.kgofd.ofd.executes.OfdWatermark;
import com.kgofd.ofd.utils.KGOfdUtils;
import com.kinggrid.encrypt.KGBase64;
import com.kinggrid.pdf.KGExecute;
import com.kinggrid.pdf.KGPdfHummer;
import com.kinggrid.pdf.executes.PdfWatermark;
import com.kinggrid.pdfviewer.Contants;
import com.kinggrid.pdfviewer.PdfActionInter;
import com.kinggrid.pdfviewer.PdfFileResource;
import com.kinggrid.pdfviewer.PdfFileResourceManager;
import com.kinggrid.pdfviewer.ofd.OfdUtils;
import com.kinggrid.pdfviewer.pdf.PdfUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontFormatException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;

public class AddWatermarkAction
implements PdfActionInter {
    @Override
    public void execute(HttpServletRequest request, HttpServletResponse response, String action, JSONObject params, PdfFileResource pdfFileResource) throws IOException {
        String docType = request.getParameter("docType");
        String documentId = params.getString("documentId");
        if (pdfFileResource == null) {
            pdfFileResource = PdfFileResourceManager.getPdfFileResource();
        }
        pdfFileResource.init(request, response, action, documentId, docType);
        JSONObject retObj = new JSONObject();
        if (docType.equals("0")) {
            String pdfFile = pdfFileResource.getPdfFile();
            InputStream in = pdfFileResource.getPdfFileStream();
            OutputStream out = pdfFileResource.getSavePdfFileSteam();
            KGPdfHummer hummer = null;
            try {
                hummer = PdfUtils.getPdfHummer(pdfFile, in, out, params.getString("pdfPwd"));
                ArrayList<PdfWatermark> pdfWatermarks = this.getWatermarkTask(params);
                for (PdfWatermark pdfWatermark : pdfWatermarks) {
                    hummer.addExecute((KGExecute)pdfWatermark);
                }
                hummer.doExecute();
            }
            catch (Exception e) {
                pdfFileResource.fail();
                throw new RuntimeException(e.getMessage(), e);
            }
            finally {
                PdfUtils.close(in);
                PdfUtils.close(out);
                if (hummer != null) {
                    hummer.close();
                }
            }
        }
        if (docType.equals("1")) {
            KGOfdHummer hummer = null;
            try {
                hummer = OfdUtils.getOfdHummer(pdfFileResource.getPdfFile(), params.getString("pdfPwd"));
                ZipFile zip = hummer.getZipFile();
                ArrayList<OfdWatermark> ofdWatermarks = this.getOfdWatermarkTask(params, zip);
                for (OfdWatermark ofdWatermark : ofdWatermarks) {
                    hummer.addExecute((com.kgofd.ofd.KGExecute)ofdWatermark);
                }
                hummer.doExecute();
            }
            catch (Exception e) {
                pdfFileResource.fail();
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        pdfFileResource.success();
        retObj.put("status", (Object)true);
        response.getWriter().write(retObj.toJSONString());
    }

    private ArrayList<OfdWatermark> getOfdWatermarkTask(JSONObject params, ZipFile zip) throws DocumentException, IOException, ZipException, org.dom4j.DocumentException {
        ArrayList<OfdWatermark> ofdWatermarks = new ArrayList<OfdWatermark>();
        float opa = params.getFloatValue("opacity");
        int alpha = (int)(opa * 255.0f);
        if ("text".equals(params.getString("source"))) {
            Color color = this.getColor(params.getString("color"));
            float fontsize = params.getFloatValue("fontSize") / 2.8346457f;
            String fontfilename = params.getString("fontName");
            String fontname = this.getFontName(fontfilename);
            if ("no".equals(params.getString("fullscreen"))) {
                JSONArray posArray = params.getJSONArray("leftBottomPosition");
                for (int i = 0; i < posArray.size(); ++i) {
                    JSONObject posObj = posArray.getJSONObject(i);
                    float x = posObj.getFloatValue("x");
                    float y = posObj.getFloatValue("y");
                    float[] size = KGOfdUtils.getPageSize((ZipFile)zip, (int)1);
                    x /= 2.8346457f;
                    y = size[1] - y / 2.8346457f;
                    OfdWatermark ofdWatermark = new OfdWatermark();
                    ofdWatermark.setText(params.getString("text"));
                    ofdWatermark.setFontName(fontname);
                    ofdWatermark.setFontColor(color);
                    ofdWatermark.setFontSize(fontsize);
                    ofdWatermark.setAlpha(alpha);
                    ofdWatermark.setRotation(params.getFloatValue("rotate"));
                    ofdWatermark.setPagen(i + 1);
                    ofdWatermark.setPosition(x, y);
                    ofdWatermarks.add(ofdWatermark);
                }
            } else {
                OfdWatermark ofdWatermark = new OfdWatermark();
                ofdWatermark.setText(params.getString("text"));
                ofdWatermark.setFontName(fontname);
                ofdWatermark.setFontColor(color);
                ofdWatermark.setDensity(params.getFloatValue("density"));
                ofdWatermark.setFontSize(fontsize);
                ofdWatermark.setAlpha(alpha);
                ofdWatermark.setRotation(params.getFloatValue("rotate"));
                ofdWatermarks.add(ofdWatermark);
            }
        } else {
            KGBase64 base64 = new KGBase64();
            byte[] imageBytes = base64.decode(params.getString("file"));
            if ("no".equals(params.getString("fullscreen"))) {
                JSONArray posArray = params.getJSONArray("leftBottomPosition");
                for (int i = 0; i < posArray.size(); ++i) {
                    JSONObject posObj = posArray.getJSONObject(i);
                    float x = posObj.getFloatValue("x");
                    float y = posObj.getFloatValue("y");
                    float[] size = KGOfdUtils.getPageSize((ZipFile)zip, (int)1);
                    x /= 2.8346457f;
                    y = size[1] - y / 2.8346457f;
                    OfdWatermark ofdWatermark = new OfdWatermark();
                    ofdWatermark.setImage(imageBytes);
                    ofdWatermark.setAlpha(alpha);
                    ofdWatermark.setRotation(params.getFloatValue("rotate"));
                    ofdWatermark.setPosition(x, y);
                    ofdWatermarks.add(ofdWatermark);
                }
            } else {
                OfdWatermark ofdWatermark = new OfdWatermark();
                ofdWatermark.setImage(imageBytes);
                ofdWatermark.setDensity(params.getFloatValue("density"));
                ofdWatermark.setRotation(params.getFloatValue("rotate"));
                ofdWatermark.setAlpha(alpha);
                ofdWatermarks.add(ofdWatermark);
            }
        }
        return ofdWatermarks;
    }

    private ArrayList<PdfWatermark> getWatermarkTask(JSONObject params) throws DocumentException, IOException {
        ArrayList<PdfWatermark> pdfWatermarks = new ArrayList<PdfWatermark>();
        if ("text".equals(params.getString("source"))) {
            BaseColor baseColor = this.getBaseColor(params.getString("color"));
            BaseFont baseFont = this.getBaseFont(params.getString("fontName"));
            if ("no".equals(params.getString("fullscreen"))) {
                JSONArray posArray = params.getJSONArray("leftBottomPosition");
                for (int i = 0; i < posArray.size(); ++i) {
                    JSONObject posObj = posArray.getJSONObject(i);
                    float x = posObj.getFloatValue("x");
                    float y = posObj.getFloatValue("y");
                    PdfWatermark pdfWatermark = new PdfWatermark();
                    pdfWatermark.setText(params.getString("text"));
                    pdfWatermark.setColor(baseColor);
                    pdfWatermark.setBaseFont(baseFont);
                    pdfWatermark.setFontSize(params.getFloatValue("fontSize"));
                    pdfWatermark.setFillOpacity(params.getFloatValue("opacity"));
                    pdfWatermark.setRotation(params.getFloatValue("rotate"));
                    pdfWatermark.setPagen(i + 1);
                    pdfWatermark.setPosition(x, y);
                    pdfWatermarks.add(pdfWatermark);
                }
            } else {
                PdfWatermark pdfWatermark = new PdfWatermark();
                pdfWatermark.setText(params.getString("text"));
                pdfWatermark.setColor(baseColor);
                pdfWatermark.setDensity(params.getFloatValue("density"));
                pdfWatermark.setBaseFont(baseFont);
                pdfWatermark.setFontSize(params.getFloatValue("fontSize"));
                pdfWatermark.setFillOpacity(params.getFloatValue("opacity"));
                pdfWatermark.setRotation(params.getFloatValue("rotate"));
                pdfWatermarks.add(pdfWatermark);
            }
        } else {
            KGBase64 base64 = new KGBase64();
            byte[] imageBytes = base64.decode(params.getString("file"));
            Image image = Image.getInstance((byte[])imageBytes);
            if ("no".equals(params.getString("fullscreen"))) {
                JSONArray posArray = params.getJSONArray("leftBottomPosition");
                for (int i = 0; i < posArray.size(); ++i) {
                    JSONObject posObj = posArray.getJSONObject(i);
                    float x = posObj.getFloatValue("x");
                    float y = posObj.getFloatValue("y");
                    PdfWatermark pdfWatermark = new PdfWatermark();
                    pdfWatermark.setImage(image);
                    pdfWatermark.setImageCenter(true);
                    pdfWatermark.setFillOpacity(params.getFloatValue("opacity"));
                    pdfWatermark.setRotation(params.getFloatValue("rotate"));
                    pdfWatermark.setPosition(x, y);
                    pdfWatermarks.add(pdfWatermark);
                }
            } else {
                PdfWatermark pdfWatermark = new PdfWatermark();
                pdfWatermark.setImage(image);
                pdfWatermark.setImageCenter(true);
                pdfWatermark.setDensity(params.getFloatValue("density"));
                pdfWatermark.setFillOpacity(params.getFloatValue("opacity"));
                pdfWatermark.setRotation(params.getFloatValue("rotate"));
                pdfWatermarks.add(pdfWatermark);
            }
        }
        return pdfWatermarks;
    }

    private BaseColor getBaseColor(String color) {
        String[] rgbs = color.split(",");
        int[] rgbsInt = new int[rgbs.length];
        for (int i = 0; i < rgbs.length; ++i) {
            rgbsInt[i] = Integer.parseInt(rgbs[i]);
        }
        return new BaseColor(rgbsInt[0], rgbsInt[1], rgbsInt[2]);
    }

    private BaseFont getBaseFont(String fontName) throws DocumentException, IOException {
        BaseFont baseFont = null;
        baseFont = fontName.contains("SIMSUN.TTC") ? BaseFont.createFont((String)"STSongStd-Light", (String)"UniGB-UCS2-H", (boolean)false) : BaseFont.createFont((String)(Contants.FONT_PATH + File.separator + fontName), (String)"Identity-H", (boolean)false);
        return baseFont;
    }

    private Color getColor(String color) {
        String[] rgbs = color.split(",");
        int[] rgbsInt = new int[rgbs.length];
        for (int i = 0; i < rgbs.length; ++i) {
            rgbsInt[i] = Integer.parseInt(rgbs[i]);
        }
        return new Color(rgbsInt[0], rgbsInt[1], rgbsInt[2]);
    }

    private String getFontName(String fontfilename) throws FileNotFoundException, IOException {
        String fontPath = Contants.FONT_PATH;
        if (fontPath == null || fontPath.length() <= 0) {
            throw new RuntimeException("font\u8d44\u6e90\u6587\u4ef6\u5939\u4e0d\u5b58\u5728, \u5b57\u4f53\u5217\u8868\u4e3a\u7a7a\uff01");
        }
        File file = new File(fontPath);
        File[] files = file.listFiles();
        if (files.length == 0) {
            throw new RuntimeException("\u5b57\u4f53\u5217\u8868\u4e3a\u7a7a\uff01");
        }
        String fontname = "";
        try {
            for (File fontFile : files) {
                Font font = Font.createFont(0, new FileInputStream(fontFile));
                if (!fontFile.getName().equals(fontfilename)) continue;
                fontname = font.getName();
                break;
            }
        }
        catch (FontFormatException e) {
            throw new RuntimeException("\u83b7\u53d6\u5b57\u4f53\u5217\u8868\u5931\u8d25\uff01", e);
        }
        return fontname;
    }
}

