/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.pdfviewer;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kgofd.encrypt.KGBase64;
import com.kinggrid.exception.KGServerInterfaceErrorException;
import com.kinggrid.kgcore.HttpUtil;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.kg.bouncycastle.util.encoders.Hex;

public class SignatureStampUtils {
    private String url;
    private String salt;
    private String appid;
    private String esid;
    private String orderId;
    private String title;

    public SignatureStampUtils(String url, String appid, String salt) {
        this.url = url;
        this.appid = appid;
        this.salt = salt;
    }

    public SignatureStampUtils(String url, String salt, String appid, String esid, String orderId, String title) {
        this.url = url;
        this.salt = salt;
        this.appid = appid;
        this.esid = esid;
        this.orderId = orderId;
        this.title = title;
    }

    public JSONArray getBlockChainData(JSONArray stampDataIDs) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        String getBlockChainDataUrl = this.url + "/api/getBlockChainData";
        String randomN = this.getRandomN();
        JSONObject jObject = new JSONObject();
        jObject.put("appid", (Object)this.appid);
        jObject.put("randomN", (Object)randomN);
        jObject.put("checkCode", (Object)this.getCheckCode64(randomN));
        jObject.put("stampDataIDs", (Object)stampDataIDs);
        HttpUtil httpUtil = new HttpUtil();
        String result = httpUtil.getResult(getBlockChainDataUrl, jObject);
        JSONObject retObj = JSONObject.parseObject((String)result);
        if (!"0".equals(retObj.getString("code"))) {
            throw new KGServerInterfaceErrorException("\u4ece\u7535\u5b50\u5370\u7ae0\u7cfb\u7edf\u9a8c\u8bc1\u7535\u5b50\u7b7e\u7ae0\u533a\u5757\u94fe\u6570\u636e\u5f02\u5e38, code=" + retObj.getString("code") + ", message:" + retObj.getString("message"));
        }
        return retObj.getJSONArray("blockChainDatas");
    }

    public JSONObject textDigitalSign(byte[] message) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        String textSignUrl = this.url + "/api/textDigitalSign";
        String randomN = this.getRandomN();
        KGBase64 base64 = new KGBase64();
        JSONObject jObject = new JSONObject();
        jObject.put("appid", (Object)this.appid);
        jObject.put("randomN", (Object)randomN);
        jObject.put("checkCode", (Object)this.getCheckCode64(randomN));
        jObject.put("sealCode", (Object)this.esid);
        jObject.put("orderId", (Object)this.orderId);
        jObject.put("title", (Object)this.title);
        jObject.put("base64Content", (Object)base64.encode(message));
        HttpUtil httpUtil = new HttpUtil();
        String result = httpUtil.getResult(textSignUrl, jObject);
        JSONObject retObj = JSONObject.parseObject((String)result);
        if (!"0".equals(retObj.getString("code"))) {
            throw new KGServerInterfaceErrorException("\u4ece\u7535\u5b50\u5370\u7ae0\u7cfb\u7edf\u83b7\u53d6\u7b7e\u540d\u503c\u5f02\u5e38, code=" + retObj.getString("code") + ", message:" + retObj.getString("message"));
        }
        return retObj;
    }

    public String getRandomN() {
        String randomNUrl = this.url + "/api/randomN";
        JSONObject jObject = new JSONObject();
        jObject.put("appid", (Object)this.appid);
        HttpUtil httpUtil = new HttpUtil();
        String ret = httpUtil.getResult(randomNUrl, jObject);
        JSONObject retObj = JSONObject.parseObject((String)ret);
        if (!"0".equals(retObj.getString("code"))) {
            throw new KGServerInterfaceErrorException("\u4ece\u7535\u5b50\u5370\u7ae0\u5e94\u7528\u7cfb\u7edf\u83b7\u53d6\u968f\u673a\u6570\u5f02\u5e38, code=" + retObj.getString("code") + ", message:" + retObj.getString("message"));
        }
        return retObj.getString("randomN");
    }

    public String getCheckCode64(String randomN) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        KGBase64 base64 = new KGBase64();
        return base64.encode(this.getSHA256Hex(randomN + this.salt).getBytes("UTF-8"));
    }

    public String getSHA256Hex(String inputStr) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        messageDigest.update(inputStr.getBytes("UTF-8"));
        byte[] result = messageDigest.digest();
        return new String(Hex.encode((byte[])result));
    }
}

