/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.pdfviewer;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Properties;

public class Contants {
    private static final Properties properties = new Properties();
    public static final String URL;
    public static final String APP_CODE;
    public static final String FILE_CLASSNAME;
    public static final String CROSS_DOMAIN_URLS;
    public static final String USER_TMP;
    public static final boolean SAVELOG;
    public static final boolean VERIFYPWD;
    public static final boolean SERVER_SIG_P1;
    public static final Class<?> MESSAGE_DIGEST_CLASS;
    public static final String VERIFY_DIGITAL_SIGNATURE;
    public static final String THRID_PARTY_SIG;
    public static final boolean SOFTVERIFY;
    public static final boolean CHECK_SEAL_STATS;
    public static final String STAMP_SYSTEM_URL;
    public static final String APPID;
    public static final String SALT;
    public static final boolean VERIFY_CAPTCHA;
    public static final String TSA_URL;
    public static final String TSA_USERNAME;
    public static final String TSA_PASSWORD;
    public static final boolean ENABLE_CONCURRENCY_LIMIT;
    public static final String FONT_PATH;
    public static final boolean SIG_WITH_DIFFERENT_CERT;
    public static final String CENTRALIZED_SEAL_ORIGIN;

    public static String getProperty(String key) {
        return properties.getProperty(key);
    }

    public static String getTmpDir() {
        String userTmp = Contants.getProperty("user.tmp");
        String userDir = System.getProperty("user.dir");
        if (userTmp == null || "".equals(userTmp)) {
            return userDir;
        }
        if (!new File(userTmp).exists()) {
            return userDir;
        }
        return userTmp;
    }

    public static Class<?> initClass(String className) {
        if (className == null || className.length() == 0) {
            return null;
        }
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className, true, contextClassLoader);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        return clazz;
    }

    private static String getChinese(String str) {
        String chinese = null;
        if (str != null && str.length() > 0) {
            try {
                byte[] isoBytes = str.getBytes("ISO-8859-1");
                chinese = new String(isoBytes, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return chinese;
    }

    static {
        InputStream in = null;
        try {
            String path = System.getProperty("pdfviewer.config");
            if (path == null) {
                in = Contants.class.getResourceAsStream("/pdfviewer.properties");
            } else {
                File file = new File(path);
                if (file.exists()) {
                    in = new FileInputStream(file);
                } else {
                    throw new RuntimeException("\u8bbe\u7f6e\u7684\u914d\u7f6e\u6587\u4ef6\u8def\u5f84\u4e0d\u5b58\u5728\uff1a" + path);
                }
            }
            if (in != null) {
                properties.load(in);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
        URL = Contants.getProperty("url");
        APP_CODE = Contants.getProperty("appcode");
        FILE_CLASSNAME = Contants.getProperty("fileClassName");
        CROSS_DOMAIN_URLS = Contants.getProperty("cross.domain.urls");
        USER_TMP = Contants.getTmpDir();
        SAVELOG = Boolean.valueOf(Contants.getProperty("savelog")) == null ? true : Boolean.valueOf(Contants.getProperty("savelog"));
        VERIFYPWD = Boolean.valueOf(Contants.getProperty("verifyPwd")) == null ? false : Boolean.valueOf(Contants.getProperty("verifyPwd"));
        SERVER_SIG_P1 = Boolean.valueOf(Contants.getProperty("serverSigP1")) == null ? false : Boolean.valueOf(Contants.getProperty("serverSigP1"));
        MESSAGE_DIGEST_CLASS = Contants.initClass(Contants.getProperty("messageDigest"));
        VERIFY_DIGITAL_SIGNATURE = Contants.getProperty("verifyDigitalSignature");
        THRID_PARTY_SIG = Contants.getProperty("thridPartySig");
        SOFTVERIFY = Boolean.valueOf(Contants.getProperty("softVerify")) == null ? false : Boolean.valueOf(Contants.getProperty("softVerify"));
        CHECK_SEAL_STATS = Boolean.valueOf(Contants.getProperty("checkSealStats")) == null ? false : Boolean.valueOf(Contants.getProperty("checkSealStats"));
        STAMP_SYSTEM_URL = Contants.getProperty("stampSystemUrl");
        APPID = Contants.getProperty("appid");
        SALT = Contants.getProperty("salt");
        VERIFY_CAPTCHA = Boolean.valueOf(Contants.getProperty("verifyCaptcha")) == null ? false : Boolean.valueOf(Contants.getProperty("verifyCaptcha"));
        TSA_URL = Contants.getProperty("tsaUrl");
        TSA_USERNAME = Contants.getProperty("tsaUsername");
        TSA_PASSWORD = Contants.getProperty("tsaPassword");
        ENABLE_CONCURRENCY_LIMIT = Boolean.valueOf(Contants.getProperty("enableConcurrencyLimit")) == null ? false : Boolean.valueOf(Contants.getProperty("enableConcurrencyLimit"));
        FONT_PATH = Contants.getChinese(Contants.getProperty("fontPath"));
        SIG_WITH_DIFFERENT_CERT = Contants.getProperty("sigWithDifferentCert") == null ? false : Boolean.valueOf(Contants.getProperty("sigWithDifferentCert"));
        CENTRALIZED_SEAL_ORIGIN = Contants.getProperty("centralizedSealOrigin") == null ? "0" : Contants.getProperty("centralizedSealOrigin");
    }
}

