/*
 * Decompiled with CFR 0.152.
 */
package com.kgofd.ofd.utils;

import com.kgofd.commons.KGCommonUtils;
import com.kgofd.commons.Utils;
import com.kgofd.ofd.core.BuildSealData;
import com.kgofd.ofd.core.BuildZWSealData;
import com.kgofd.ofd.seal.Seal;
import com.kgofd.ofd.seal.SealUtil;
import java.awt.Font;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.io.ZipInputStream;
import net.lingala.zip4j.model.FileHeader;
import net.lingala.zip4j.model.ZipParameters;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.kg.bouncycastle.asn1.ASN1Encodable;
import org.kg.bouncycastle.asn1.ASN1EncodableVector;
import org.kg.bouncycastle.asn1.ASN1Integer;
import org.kg.bouncycastle.asn1.ASN1Primitive;
import org.kg.bouncycastle.asn1.ASN1Sequence;
import org.kg.bouncycastle.asn1.DERSequence;

public class KGOfdUtils {
    List<Element> semanticTrees = null;

    public static void WriteFile(String resourceFile, String outPath) throws IOException {
        FileInputStream fis = new FileInputStream(resourceFile);
        KGOfdUtils.WriteFile(fis, outPath);
    }

    public static void WriteFile(InputStream is, String outPath) throws IOException {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(outPath);
            int len = 0;
            byte[] buf = new byte[4096];
            while ((len = is.read(buf)) != -1) {
                fos.write(buf, 0, len);
            }
        }
        finally {
            fos.close();
            is.close();
        }
    }

    public static byte[] getFileByte(ZipFile zipFile, String header) throws ZipException {
        FileHeader fileHeader = zipFile.getFileHeader(header);
        ZipInputStream fis = zipFile.getInputStream(fileHeader);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buff = new byte[8192];
        int len = 0;
        try {
            try {
                while ((len = fis.read(buff)) != -1) {
                    baos.write(buff, 0, len);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        catch (Throwable throwable) {
            KGOfdUtils.close(baos);
            KGOfdUtils.close(new Closeable[]{fis});
            throw throwable;
        }
        KGOfdUtils.close(baos);
        KGOfdUtils.close(new Closeable[]{fis});
        return baos.toByteArray();
    }

    public static int getTotalPage(ZipFile zipFile) throws ZipException, DocumentException {
        Document xmlDocument = KGOfdUtils.getDocument(zipFile, "Doc_0/Document.xml");
        String xpath = "/ofd:Document/ofd:Pages/ofd:Page";
        List nodes = xmlDocument.selectNodes(xpath);
        return nodes.size();
    }

    public static Document getDocument(ZipFile zipFile, String fileHeader) throws ZipException, DocumentException {
        SAXReader reader = new SAXReader();
        Document document = null;
        ZipInputStream zis = null;
        try {
            FileHeader ofdHeader = zipFile.getFileHeader(fileHeader);
            if (ofdHeader != null) {
                zis = zipFile.getInputStream(ofdHeader);
                document = reader.read((InputStream)zis);
            }
        }
        catch (Throwable throwable) {
            KGOfdUtils.close(new Closeable[]{zis});
            throw throwable;
        }
        KGOfdUtils.close(new Closeable[]{zis});
        return document;
    }

    public static void writeToZip(ZipFile zipFile, String fileName, String resourcePath) throws ZipException {
        ZipParameters parameters = new ZipParameters();
        parameters.setCompressionMethod(8);
        parameters.setCompressionLevel(5);
        parameters.setFileNameInZip(fileName);
        parameters.setSourceExternalStream(true);
        zipFile.addFile(new File(resourcePath), parameters);
    }

    public static void writeToZip(ZipFile zipFile, String fileName, byte[] data) throws ZipException {
        ByteArrayInputStream bais = null;
        try {
            bais = new ByteArrayInputStream(data);
            KGOfdUtils.writeToZip(zipFile, fileName, bais);
        }
        catch (Throwable throwable) {
            KGOfdUtils.close(bais);
            throw throwable;
        }
        KGOfdUtils.close(bais);
    }

    public static void removeFile(ZipFile zipFile, String fileName) throws ZipException {
        zipFile.removeFile(fileName);
    }

    public static void writeToZip(ZipFile zipFile, String fileName, InputStream is) throws ZipException {
        FileHeader fileHeader = zipFile.getFileHeader(fileName);
        if (fileHeader != null) {
            zipFile.removeFile(fileHeader);
        }
        ZipParameters parameters = new ZipParameters();
        parameters.setCompressionMethod(8);
        parameters.setCompressionLevel(5);
        parameters.setFileNameInZip(fileName);
        parameters.setSourceExternalStream(true);
        zipFile.addStream(is, parameters);
    }

    public static void writeToZip(ZipFile zipFile, String fileName, Document doc) throws ZipException {
        ByteArrayInputStream bais = null;
        try {
            try {
                bais = new ByteArrayInputStream(doc.asXML().getBytes("UTF-8"));
                KGOfdUtils.writeToZip(zipFile, fileName, bais);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        catch (Throwable throwable) {
            KGOfdUtils.close(bais);
            throw throwable;
        }
        KGOfdUtils.close(bais);
    }

    public static Map<Integer, Element> converPage(ZipFile zipFile) throws ZipException, DocumentException {
        Document docuemnt = KGOfdUtils.getDocument(zipFile, "Doc_0/Document.xml");
        List nodes = docuemnt.selectNodes("/ofd:Document/ofd:Pages/ofd:Page");
        HashMap<Integer, Element> map = new HashMap<Integer, Element>();
        int i = 0;
        while (i < nodes.size()) {
            Element element = (Element)nodes.get(i);
            map.put(i + 1, element);
            ++i;
        }
        return map;
    }

    public static Element getpageElement(ZipFile zipFile, int page) throws ZipException, DocumentException {
        SAXReader reader = new SAXReader();
        FileHeader header = zipFile.getFileHeader("Doc_0/Document.xml");
        ZipInputStream zis = zipFile.getInputStream(header);
        Document docuemnt = reader.read((InputStream)zis);
        List nodes = docuemnt.selectNodes("/ofd:Document/ofd:Pages/ofd:Page");
        return (Element)nodes.get(page - 1);
    }

    public static float[] getPageSize(ZipFile zipFile, int page) throws ZipException, DocumentException {
        Document xmlDocument = KGOfdUtils.getDocument(zipFile, "Doc_0/Document.xml");
        String xpage = "/ofd:Document/ofd:Pages/ofd:Page";
        List nodes = xmlDocument.selectNodes(xpage);
        Element element = (Element)nodes.get(page - 1);
        String baseLoc = element.attribute("BaseLoc").getValue();
        baseLoc = KGCommonUtils.converPath(baseLoc, "Doc_0/Document.xml");
        Document contentXml = KGOfdUtils.getDocument(zipFile, baseLoc);
        Node physicalBoxNode = contentXml.selectSingleNode("/ofd:Page/ofd:Area/ofd:PhysicalBox");
        String physicalBox = null;
        physicalBox = physicalBoxNode != null ? physicalBoxNode.getText() : xmlDocument.selectSingleNode("/ofd:Document/ofd:CommonData/ofd:PageArea/ofd:PhysicalBox").getText();
        String[] physicalBoxStr = physicalBox.split(" ");
        float[] size = new float[]{Float.parseFloat(physicalBoxStr[2]), Float.parseFloat(physicalBoxStr[3])};
        return size;
    }

    public InputStream insertXmlnsNode(ZipFile zipFile, String customTagPath) throws IOException, ZipException {
        Object fw = null;
        ByteArrayOutputStream out = null;
        ByteArrayInputStream bis = null;
        ZipInputStream in = null;
        try {
            FileHeader header = zipFile.getFileHeader(customTagPath);
            in = zipFile.getInputStream(header);
            out = new ByteArrayOutputStream();
            this.copyStram((InputStream)in, out);
            String content = new String(out.toByteArray(), "UTF-8");
            if (content.indexOf("xmlns") == -1) {
                int index = content.indexOf("?>");
                int indexs = content.indexOf("<", index);
                int indexe = content.indexOf(":", indexs);
                String typeID = content.substring(indexs + 1, indexe);
                int idx = content.indexOf("<" + typeID + ":");
                int idxend = content.indexOf(">", idx);
                String fp = String.valueOf(content.substring(idx, idxend)) + " xmlns:" + typeID + "=\"http://www.nits.org.cn/eGovDoc/2013\">";
                content = String.valueOf(content.substring(0, idx)) + fp + content.substring(idxend + 1);
            }
            bis = new ByteArrayInputStream(content.getBytes());
        }
        catch (Throwable throwable) {
            KGOfdUtils.close(fw);
            KGOfdUtils.close(out);
            KGOfdUtils.close(new Closeable[]{in});
            throw throwable;
        }
        KGOfdUtils.close(fw);
        KGOfdUtils.close(out);
        KGOfdUtils.close(new Closeable[]{in});
        return bis;
    }

    private void copyStram(InputStream in, OutputStream os) throws IOException {
        byte[] bytes = new byte[4096];
        int len = -1;
        while ((len = in.read(bytes)) != -1) {
            os.write(bytes, 0, len);
        }
    }

    public List<Element> getTreeNode(Document doc, String semanticTree) {
        this.semanticTrees = new ArrayList<Element>();
        Element root = doc.getRootElement();
        return this.getNodes(root, semanticTree);
    }

    private List<Element> getNodes(Element node, String treeName) {
        List elements = node.elements();
        for (Element e : elements) {
            if (e.getName().equals(treeName)) {
                this.semanticTrees.add(e);
                continue;
            }
            this.getNodes(e, treeName);
        }
        return this.semanticTrees;
    }

    public String getTextCode(Element textObject) {
        List textCode = textObject.elements("TextCode");
        StringBuilder sb = new StringBuilder();
        for (Element object : textCode) {
            String str = object.getTextTrim();
            sb.append(str);
        }
        return sb.toString();
    }

    public static void close(Closeable ... closeableList) {
        try {
            Closeable[] closeableArray = closeableList;
            int n = closeableList.length;
            int n2 = 0;
            while (n2 < n) {
                Closeable closeable = closeableArray[n2];
                if (closeable != null) {
                    closeable.close();
                }
                ++n2;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static byte[] getSealPicData(String text, Float sealPicWidth, Float sealPicHeight, Font textFont, String color, double angle, int nBorder, String outPath) {
        return Utils.TextToSignImg(text, sealPicWidth, sealPicHeight, textFont, color, angle, nBorder, outPath);
    }

    public static byte[] getToSignDataByBuildSealData(String sealPropertyName, byte[] sealPropertyCer, byte[] sealPicData, String sealPicType, Float sealPicWidth, Float sealPicHeight, String sealPropertyCreateDate, String sealPropertyValidStart, long sealPeriod) {
        BuildSealData sealData = new BuildSealData(sealPropertyName, sealPropertyCer, sealPicType, sealPicData, sealPicWidth, sealPicHeight, sealPropertyCreateDate, sealPropertyValidStart, sealPeriod);
        return sealData.getToSignData();
    }

    public static byte[] getToSignDataByBuildZWSealData(String sealPropertyName, byte[] sealPropertyCer, int sealType, byte[] sealPicData, String sealPicType, Float sealPicWidth, Float sealPicHeight, String sealPropertyCreateDate, String sealPropertyValidStart, long sealPeriod, String esID, String[] extnID, boolean[] critical, String[] extnValue) {
        BuildZWSealData sealData = new BuildZWSealData(sealPropertyName, sealPropertyCer, sealType, sealPicType, sealPicData, sealPicWidth, sealPicHeight, sealPropertyCreateDate, sealPropertyValidStart, sealPeriod, esID, extnID, critical, extnValue);
        return sealData.GetToSignData();
    }

    public static String getImageFromSeal(byte[] sealData) throws IOException {
        Seal seal = SealUtil.getSeal(sealData);
        return seal.getSealPicData();
    }

    public static String getImageFromSignature(byte[] signature) throws IOException {
        ASN1Sequence signatureSeq = (ASN1Sequence)ASN1Primitive.fromByteArray((byte[])signature);
        ASN1Sequence signSeq = (ASN1Sequence)signatureSeq.getObjectAt(0);
        byte[] sealData = signSeq.getObjectAt(1).toASN1Primitive().getEncoded();
        Seal seal = SealUtil.getSeal(sealData);
        return seal.getSealPicData();
    }

    public static byte[] sigData64bit2Ans1(byte[] signData) throws IOException {
        byte[] r = null;
        byte[] s = null;
        if (signData[0] < 0) {
            r = new byte[33];
            System.arraycopy(signData, 0, r, 1, 32);
        } else {
            r = new byte[32];
            System.arraycopy(signData, 0, r, 0, 32);
        }
        if (signData[32] < 0) {
            s = new byte[33];
            System.arraycopy(signData, 32, s, 1, 32);
        } else {
            s = new byte[32];
            System.arraycopy(signData, 32, s, 0, 32);
        }
        ASN1EncodableVector encodable = new ASN1EncodableVector();
        encodable.add((ASN1Encodable)new ASN1Integer(new BigInteger(r)));
        encodable.add((ASN1Encodable)new ASN1Integer(new BigInteger(s)));
        DERSequence sequence = new DERSequence(encodable);
        return sequence.getEncoded();
    }

    public static byte[] sigDataAns1To64bit(byte[] signData) throws IOException {
        int srcPos;
        int dest;
        ASN1Sequence sequense = ASN1Sequence.getInstance((Object)signData);
        ASN1Integer ans1Int0 = (ASN1Integer)sequense.getObjectAt(0);
        ASN1Integer ans1Int1 = (ASN1Integer)sequense.getObjectAt(1);
        byte[] sig1 = ans1Int0.getValue().toByteArray();
        byte[] sig2 = ans1Int1.getValue().toByteArray();
        byte[] buff = new byte[64];
        if (sig1.length < 32) {
            dest = 32 - sig1.length;
            System.arraycopy(sig1, 0, buff, dest, sig1.length);
        } else {
            srcPos = sig1.length == 32 ? 0 : sig1.length - 32;
            System.arraycopy(sig1, srcPos, buff, 0, 32);
        }
        if (sig2.length < 32) {
            dest = 32 - sig2.length;
            System.arraycopy(sig2, 0, buff, dest, sig2.length);
        } else {
            srcPos = sig2.length == 32 ? 0 : sig2.length - 32;
            System.arraycopy(sig2, srcPos, buff, 32, 32);
        }
        return buff;
    }
}

