/*
 * Decompiled with CFR 0.152.
 */
package com.kgofd.ofd.utils;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public class IMsgServer2006 {
    private String TableBase64 = "=ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
    private byte[] FStream;
    private byte[] FMsgFile;
    private String FMsgText = "";
    protected String FError = "";
    private String FVersion = "DBSTEP V3.0";
    private int FFileSize = 0;
    private String charSet = "GBK";
    private boolean ok = false;

    public boolean isOk() {
        return this.ok;
    }

    protected void setOk(boolean ok) {
        this.ok = ok;
    }

    public void setTableBase64(String tableBase64) {
        this.TableBase64 = tableBase64;
    }

    protected String FormatHead(String vString) {
        if (vString.length() > 16) {
            return vString.substring(0, 16);
        }
        int i = vString.length() + 1;
        while (i < 17) {
            vString = vString.concat(" ");
            ++i;
        }
        return vString;
    }

    private boolean MsgToStream() {
        int HeadSize = 64;
        int BodySize = 0;
        int ErrorSize = 0;
        int FileSize = 0;
        int Position2 = 0;
        try {
            Position2 = 0;
            BodySize = this.FMsgText.getBytes().length;
            ErrorSize = this.FError.getBytes(this.charSet).length;
            FileSize = this.FFileSize;
            ByteArrayOutputStream mBuffer = new ByteArrayOutputStream(HeadSize + BodySize + ErrorSize + FileSize);
            String HeadString = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.FormatHead(this.FVersion)))).append(this.FormatHead(String.valueOf(BodySize))).append(this.FormatHead(String.valueOf(ErrorSize))).append(this.FormatHead(String.valueOf(FileSize)))));
            mBuffer.write(HeadString.getBytes(), Position2, HeadSize);
            Position2 += HeadSize;
            if (BodySize > 0) {
                mBuffer.write(this.FMsgText.getBytes());
            }
            Position2 += BodySize;
            if (ErrorSize > 0) {
                mBuffer.write(this.FError.getBytes(this.charSet));
            }
            Position2 += ErrorSize;
            if (FileSize > 0) {
                mBuffer.write(this.FMsgFile);
            }
            Position2 += FileSize;
            mBuffer.close();
            this.FStream = mBuffer.toByteArray();
            return true;
        }
        catch (IOException e) {
            this.FError = String.valueOf(String.valueOf(this.FError)) + String.valueOf(e.toString());
            return false;
        }
    }

    public byte[] MsgVariant() {
        this.MsgToStream();
        return this.FStream;
    }

    private boolean StreamToMsg() {
        int HeadSize = 64;
        int BodySize = 0;
        int ErrorSize = 0;
        int FileSize = 0;
        int Position2 = 0;
        try {
            Position2 = 0;
            String HeadString = new String(this.FStream, Position2, HeadSize);
            this.FVersion = HeadString.substring(0, 15);
            this.setCharSet(this.FVersion);
            BodySize = Integer.parseInt(HeadString.substring(16, 31).trim());
            ErrorSize = Integer.parseInt(HeadString.substring(32, 47).trim());
            this.FFileSize = FileSize = Integer.parseInt(HeadString.substring(48, 63).trim());
            Position2 += HeadSize;
            if (BodySize > 0) {
                this.FMsgText = new String(this.FStream, Position2, BodySize, this.charSet);
            }
            Position2 += BodySize;
            if (ErrorSize > 0) {
                this.FError = new String(this.FStream, Position2, ErrorSize, this.charSet);
            }
            Position2 += ErrorSize;
            this.FMsgFile = new byte[FileSize];
            if (FileSize > 0) {
                int i = 0;
                while (i < FileSize) {
                    this.FMsgFile[i] = this.FStream[i + Position2];
                    ++i;
                }
            }
            return true;
        }
        catch (Exception e) {
            this.FError = String.valueOf(String.valueOf(this.FError)) + String.valueOf(e.toString());
            return false;
        }
    }

    public void MsgVariant(byte[] mStream) {
        this.FStream = mStream;
        if (this.FError == "") {
            this.StreamToMsg();
        }
    }

    public boolean SavePackage(String FileName) {
        try {
            FileOutputStream mFile = new FileOutputStream(FileName);
            mFile.write(this.FStream);
            mFile.close();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean MsgFileSave(String FileName) {
        try {
            FileOutputStream mFile = new FileOutputStream(FileName);
            mFile.write(this.FMsgFile);
            mFile.close();
            return true;
        }
        catch (Exception e) {
            this.FError = String.valueOf(String.valueOf(this.FError)) + String.valueOf(e.toString());
            return false;
        }
    }

    public boolean MsgFileLoad(String FileName) {
        try {
            File mFile = new File(FileName);
            int mSize = (int)mFile.length();
            int mRead = 0;
            this.FMsgFile = new byte[mSize];
            FileInputStream mStream = new FileInputStream(mFile);
            while (mRead < mSize) {
                mRead += mStream.read(this.FMsgFile, mRead, mSize - mRead);
            }
            mStream.close();
            this.FFileSize = mSize;
            return true;
        }
        catch (Exception e) {
            this.FError = String.valueOf(String.valueOf(this.FError)) + String.valueOf(e.toString());
            return false;
        }
    }

    public String MsgTextBody() {
        return this.FMsgText;
    }

    public byte[] MsgFileBody() {
        return this.FMsgFile;
    }

    public String MsgError() {
        return this.FError;
    }

    public String MsgVersion() {
        return this.FVersion;
    }

    public void MsgTextBody(String Value) {
        this.FMsgText = Value;
    }

    public void MsgFileBody(byte[] Value) {
        this.FMsgFile = Value;
        this.FFileSize = this.FMsgFile.length;
    }

    public void MsgError(String Value) {
        this.FError = Value;
    }

    public int MsgFileSize() {
        return this.FFileSize;
    }

    public void MsgFileSize(int value) {
        this.FFileSize = value;
    }

    public void MsgFileClear() {
        this.FFileSize = 0;
        this.FMsgFile = null;
    }

    public void MsgTextClear() {
        this.FMsgText = "";
        this.ok = false;
    }

    public void MsgErrorClear() {
        this.FError = "";
    }

    public String DecodeBase64(String Value) {
        ByteArrayOutputStream o = new ByteArrayOutputStream();
        byte[] d = new byte[4];
        try {
            int count = 0;
            byte[] x = Value.getBytes();
            while (count < x.length) {
                int n = 0;
                while (n <= 3) {
                    if (count >= x.length) {
                        d[n] = 64;
                    } else {
                        int y = this.TableBase64.indexOf(x[count]);
                        if (y < 0) {
                            y = 65;
                        }
                        d[n] = (byte)y;
                    }
                    ++count;
                    ++n;
                }
                o.write((byte)(((d[0] & 0x3F) << 2) + ((d[1] & 0x30) >> 4)));
                if (d[2] == 64) continue;
                o.write((byte)(((d[1] & 0xF) << 4) + ((d[2] & 0x3C) >> 2)));
                if (d[3] == 64) continue;
                o.write((byte)(((d[2] & 3) << 6) + (d[3] & 0x3F)));
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            this.FError = String.valueOf(String.valueOf(this.FError)) + String.valueOf(e.toString());
        }
        String ret = "";
        try {
            ret = new String(o.toByteArray(), this.charSet);
        }
        catch (UnsupportedEncodingException e) {
            this.FError = String.valueOf(String.valueOf(this.FError)) + String.valueOf(e.toString());
        }
        return ret;
    }

    public String EncodeBase64(String Value) {
        ByteArrayOutputStream o = new ByteArrayOutputStream();
        byte[] d = new byte[4];
        try {
            int count = 0;
            byte[] x = Value.getBytes(this.charSet);
            while (count < x.length) {
                byte c = x[count];
                d[0] = (byte)((c & 0xFC) >> 2);
                d[1] = (byte)((c & 3) << 4);
                if (++count < x.length) {
                    c = x[count];
                    d[1] = (byte)(d[1] + (byte)((c & 0xF0) >> 4));
                    d[2] = (byte)((c & 0xF) << 2);
                    if (++count < x.length) {
                        c = x[count];
                        ++count;
                        d[2] = (byte)(d[2] + ((c & 0xC0) >> 6));
                        d[3] = (byte)(c & 0x3F);
                    } else {
                        d[3] = 64;
                    }
                } else {
                    d[2] = 64;
                    d[3] = 64;
                }
                int n = 0;
                while (n <= 3) {
                    o.write(this.TableBase64.charAt(d[n]));
                    ++n;
                }
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            this.FError = String.valueOf(String.valueOf(this.FError)) + String.valueOf(e.toString());
        }
        catch (UnsupportedEncodingException e) {
            this.FError = String.valueOf(String.valueOf(this.FError)) + String.valueOf(e.toString());
        }
        return o.toString();
    }

    public int GetFieldCount() {
        int i = 0;
        int j = 0;
        i = this.FMsgText.indexOf("\r\n", i + 1);
        while (i != -1) {
            ++j;
            i = this.FMsgText.indexOf("\r\n", i + 1);
        }
        return j;
    }

    public String GetFieldName(int Index) {
        int i = 0;
        int j = 0;
        int k = 0;
        int n = 0;
        String mFieldString = "";
        String mFieldName = "";
        String mReturn = "";
        while (i != -1 && j < Index) {
            if ((i = this.FMsgText.indexOf("\r\n", i + 1)) == -1) continue;
            ++j;
        }
        k = this.FMsgText.indexOf("\r\n", i + 1);
        if (i != -1 && k != -1 && (n = (mFieldString = i == 0 ? this.FMsgText.substring(i, k) : this.FMsgText.substring(i + 2, k)).indexOf("=", 0)) != -1) {
            mReturn = mFieldName = mFieldString.substring(0, n);
        }
        return mReturn;
    }

    public String GetFieldValue(int Index) {
        int i = 0;
        int j = 0;
        int k = 0;
        int n = 0;
        String mFieldString = "";
        String mFieldValue = "";
        String mReturn = "";
        while (i != -1 && j < Index) {
            if ((i = this.FMsgText.indexOf("\r\n", i + 1)) == -1) continue;
            ++j;
        }
        k = this.FMsgText.indexOf("\r\n", i + 1);
        if (i != -1 && k != -1 && (n = (mFieldString = i == 0 ? this.FMsgText.substring(i, k) : this.FMsgText.substring(i + 2, k)).indexOf("=", 0)) != -1) {
            mFieldValue = mFieldString.substring(n + 1, mFieldString.length());
            mReturn = this.DecodeBase64(mFieldValue);
        }
        return mReturn;
    }

    public String GetFieldText() {
        return this.FMsgText.toString();
    }

    public void setFieldText(String fiedText) {
        this.FMsgText = fiedText;
    }

    public String GetMsgByName(String FieldName) {
        int i = 0;
        int j = 0;
        String mReturn = "";
        String mFieldName = FieldName.trim().concat("=");
        i = this.FMsgText.indexOf(mFieldName);
        if (i != -1) {
            j = this.FMsgText.indexOf("\r\n", i + 1);
            i += mFieldName.length();
            if (j != -1) {
                String mFieldValue = this.FMsgText.substring(i, j);
                mReturn = this.DecodeBase64(mFieldValue);
                return mReturn;
            }
            return mReturn;
        }
        return mReturn;
    }

    public void SetMsgByName(String FieldName, String FieldValue) {
        String mFieldText = "";
        String mFieldHead = "";
        String mFieldNill = "";
        int i = 0;
        int j = 0;
        boolean f = false;
        String mFieldName = FieldName.trim().concat("=");
        String mFieldValue = this.EncodeBase64(FieldValue == null ? "" : FieldValue);
        mFieldText = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(mFieldName))).append(mFieldValue).append("\r\n")));
        i = this.FMsgText.indexOf(mFieldName);
        if (i != -1 && (j = this.FMsgText.indexOf("\r\n", i + 1)) != -1) {
            mFieldHead = this.FMsgText.substring(0, i);
            mFieldNill = this.FMsgText.substring(j + 2);
            f = true;
        }
        this.FMsgText = f ? new StringBuffer(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(mFieldHead))).append(mFieldText).append(mFieldNill)))).toString() : this.FMsgText.concat(mFieldText);
    }

    public boolean MakeDirectory(String FilePath) {
        File mFile = new File(FilePath);
        mFile.mkdirs();
        return mFile.isDirectory();
    }

    protected void setCharSet(String version) {
        if (version.trim().endsWith("-1")) {
            this.charSet = "UTF-8";
        }
    }

    public String getCharSet() {
        return this.charSet;
    }
}

