/*
 * Decompiled with CFR 0.152.
 */
package com.kgofd.ofd.signinter;

import com.kgofd.encrypt.SM2;
import com.kgofd.ofd.core.CertUtil;
import com.kgofd.ofd.enmu.KGHashType;
import com.kgofd.ofd.executes.OfdElectronicSeal4KG;
import com.kgofd.ofd.signinter.SignatureInterByServer;
import java.io.IOException;
import org.kg.bouncycastle.asn1.ASN1Sequence;
import org.kg.bouncycastle.asn1.x509.X509CertificateStructure;
import org.kg.bouncycastle.crypto.AsymmetricCipherKeyPair;

public class SignatureInterNoCert
extends SignatureInterByServer {
    private KGHashType hashType = KGHashType.HASH_TYPE_SM3;
    private AsymmetricCipherKeyPair keyPair;

    public SignatureInterNoCert(OfdElectronicSeal4KG ofdElectronicSeal4KG) {
        this.ofdElectronicSeal4KG = ofdElectronicSeal4KG;
    }

    public SignatureInterNoCert() {
    }

    @Override
    public void setHashType(KGHashType hashType) {
        this.hashType = hashType;
    }

    @Override
    public KGHashType getHashType() {
        return this.hashType;
    }

    @Override
    public X509CertificateStructure getCer() throws IOException {
        X509CertificateStructure cert = null;
        try {
            SM2 sm2 = SM2.getInstance();
            this.keyPair = sm2.ecc_key_pair_generator.generateKeyPair();
            this.cer = CertUtil.buildCert(this.keyPair);
            cert = new X509CertificateStructure(ASN1Sequence.getInstance((Object)this.cer));
        }
        catch (Exception e) {
            throw new RuntimeException();
        }
        return cert;
    }

    @Override
    public byte[] getSignData(byte[] toSignData) throws IOException {
        SM2 sm2 = SM2.getInstance();
        return sm2.sign(this.keyPair, toSignData);
    }
}

