/*
 * Decompiled with CFR 0.152.
 */
package com.kgofd.ofd.signinter;

import com.kgofd.encrypt.KGBase64;
import com.kgofd.encrypt.KGSM3Digest;
import com.kgofd.ofd.core.GMSesSignature;
import com.kgofd.ofd.core.SesSignature;
import com.kgofd.ofd.core.ZWSesSignature;
import com.kgofd.ofd.enmu.KGHashType;
import com.kgofd.ofd.executes.OfdElectronicSeal4KG;
import com.kgofd.ofd.signinter.SignatureInter;
import com.kgofd.ofd.signinter.SignatureInterBase;
import java.io.IOException;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.io.ZipInputStream;
import org.kg.bouncycastle.asn1.ASN1Primitive;
import org.kg.bouncycastle.asn1.ASN1Sequence;
import org.kg.bouncycastle.asn1.DERInteger;
import org.kg.bouncycastle.asn1.DERSequence;
import org.kg.bouncycastle.asn1.DLSequence;
import org.kg.bouncycastle.asn1.x509.X509CertificateStructure;

public class SignatureInterByKey
extends SignatureInterBase
implements SignatureInter {
    private String cer;
    private KGHashType hashType = KGHashType.HASH_TYPE_SM3;
    private String sealType = "GM";

    public SignatureInterByKey(String cer, OfdElectronicSeal4KG ofdElectronicSeal4KG) {
        this.cer = cer;
        this.ofdElectronicSeal4KG = ofdElectronicSeal4KG;
    }

    public SignatureInterByKey() {
    }

    @Override
    public X509CertificateStructure getCer() throws IOException {
        KGBase64 base64 = new KGBase64();
        byte[] c = base64.decode(this.cer);
        ASN1Sequence cerSequence = (ASN1Sequence)ASN1Primitive.fromByteArray((byte[])c);
        X509CertificateStructure cert = new X509CertificateStructure(cerSequence);
        return cert;
    }

    @Override
    public String getSignMethod() {
        String signMethod = null;
        if (this.hashType == KGHashType.HASH_TYPE_SM3) {
            signMethod = "1.2.156.10197.1.501";
        } else if (this.hashType == KGHashType.HASH_TYPE_SHA1) {
            signMethod = "SHA1WithRSA";
        }
        return signMethod;
    }

    @Override
    public String getDigestMethod() {
        String digestMethod = null;
        if (this.hashType == KGHashType.HASH_TYPE_SM3) {
            digestMethod = "1.2.156.10197.1.401";
        } else if (this.hashType == KGHashType.HASH_TYPE_SHA1) {
            digestMethod = "SHA1";
        }
        return digestMethod;
    }

    @Override
    public byte[] getDigestData(ZipInputStream zis) throws IOException {
        byte[] digestData = null;
        if (this.hashType == KGHashType.HASH_TYPE_SM3) {
            digestData = KGSM3Digest.getSm3Digest(zis);
        } else if (this.hashType == KGHashType.HASH_TYPE_SHA1) {
            digestData = this.getSHA1HashData(zis);
        }
        return digestData;
    }

    @Override
    public byte[] getToSignData(String signDirPath, ZipFile zipFile, String timeInfo) throws IOException, ZipException {
        ZipInputStream signatureXmlInStream = zipFile.getInputStream(zipFile.getFileHeader(String.valueOf(signDirPath) + "/Signature.xml"));
        byte[] dataHah = null;
        if (this.hashType == KGHashType.HASH_TYPE_SM3) {
            dataHah = KGSM3Digest.getSm3Digest(signatureXmlInStream);
        } else if (this.hashType == KGHashType.HASH_TYPE_SHA1) {
            dataHah = this.getSHA1HashData(signatureXmlInStream);
        }
        byte[] toSignData = null;
        String propertyPath = "/" + signDirPath + "/Signature.xml";
        if ("GM".equals(this.sealType)) {
            DERSequence derSequence = null;
            if (((String)localversion.get()).equals("4")) {
                derSequence = SesSignature.getToSignData((byte[])local.get(), timeInfo, dataHah, propertyPath);
            } else {
                KGBase64 base64 = new KGBase64();
                derSequence = GMSesSignature.getGMToSignData((byte[])local.get(), timeInfo.substring(2), dataHah, propertyPath, base64.decode(this.cer), this.hashType);
            }
            toSignData = derSequence.getEncoded();
        } else if ("GB".equals(this.sealType)) {
            DERSequence derSequence = ZWSesSignature.getZWToSignData((byte[])local.get(), timeInfo, dataHah, propertyPath);
            toSignData = derSequence.getEncoded();
        } else {
            throw new RuntimeException("\u4e0d\u652f\u6301\u8be5\u79cd\u5370\u7ae0\u7c7b\u578b:" + this.sealType);
        }
        return toSignData;
    }

    @Override
    public byte[] getSignData(byte[] toSignData) {
        return toSignData;
    }

    @Override
    public byte[] createDatFile(byte[] toSignData, byte[] signData, String signDirPath) throws IOException {
        byte[] datFileData = null;
        if ("GM".equals(this.sealType)) {
            DLSequence dlSequence = (DLSequence)ASN1Primitive.fromByteArray((byte[])toSignData);
            DERSequence sequence = null;
            KGBase64 base64 = new KGBase64();
            String ver = ((DERInteger)dlSequence.getObjectAt(0)).toString();
            if (ver.equals("4")) {
                byte[] timestamp = null;
                if (this.timeStampInter != null) {
                    timestamp = this.timeStampInter.getTimeStamp(signData);
                }
                sequence = SesSignature.getSesSignature(dlSequence, base64.decode(this.cer), signData, timestamp);
            } else {
                sequence = GMSesSignature.getGMSesSignature(dlSequence, signData);
            }
            datFileData = sequence.getEncoded();
        } else if ("GB".equals(this.sealType)) {
            DLSequence dlSequence = (DLSequence)ASN1Primitive.fromByteArray((byte[])toSignData);
            KGBase64 base64 = new KGBase64();
            DERSequence sesSignature = ZWSesSignature.getZWSesSignature(dlSequence, base64.decode(this.cer), signData);
            datFileData = sesSignature.getEncoded();
        }
        return datFileData;
    }

    public void setHashType(KGHashType hashType) {
        this.hashType = hashType;
    }

    public KGHashType getHashType() {
        return this.hashType;
    }

    public void setCer(String cer) {
        this.cer = cer;
    }

    public void setSealType(String sealType) {
        this.sealType = sealType;
    }

    public String getSealType() {
        return this.sealType;
    }
}

