/*
 * Decompiled with CFR 0.152.
 */
package com.kgofd.ofd.signinter;

import com.kgofd.kgcore.SealInformation;
import com.kgofd.ofd.core.Jna;
import com.kgofd.ofd.signinter.SignatureInter;
import com.kgofd.ofd.signinter.SignatureInterBase;
import java.io.Closeable;
import java.io.IOException;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.io.ZipInputStream;
import org.kg.bouncycastle.asn1.x509.X509CertificateStructure;

public class SignatureInterByJna
extends SignatureInterBase
implements SignatureInter {
    private Jna jna = new Jna();
    private String sealId = "1";
    private byte[] digestData;
    private String signatureMethod;
    private String digestMethod;
    private String pinCode;
    private String time;

    public SignatureInterByJna(String sealId, String pinCode) {
        this.sealId = sealId;
        this.pinCode = pinCode;
    }

    public SignatureInterByJna() {
    }

    @Override
    public SealInformation getSeal() {
        byte[] seal = this.jna.getSeal(this.sealId);
        SealInformation sealInformation = new SealInformation();
        sealInformation.setImgValue(seal);
        return sealInformation;
    }

    @Override
    public X509CertificateStructure getCer() throws IOException {
        return null;
    }

    @Override
    public String getSignMethod() {
        this.signatureMethod = this.jna.getSignMethod();
        return this.signatureMethod;
    }

    @Override
    public String getDigestMethod() {
        this.digestMethod = this.jna.getDigestMethod();
        return this.digestMethod;
    }

    @Override
    public byte[] getDigestData(ZipInputStream zis) throws IOException {
        try {
            byte[] b = new byte[zis.available()];
            zis.read(b);
            this.digestData = this.jna.digest(b, this.digestMethod);
        }
        catch (Throwable throwable) {
            this.close(new Closeable[]{zis});
            throw throwable;
        }
        this.close(new Closeable[]{zis});
        return this.digestData;
    }

    @Override
    public byte[] getToSignData(String signDirPath, ZipFile zipFile, String time) {
        this.time = time;
        return null;
    }

    @Override
    public byte[] getSignData(byte[] toSignData) {
        return null;
    }

    @Override
    public byte[] createDatFile(byte[] toSignData, byte[] signData, String signDirPath) throws IOException {
        byte[] SignedValue = this.jna.sign(this.sealId, String.valueOf(signDirPath) + "/Signature.xml", this.digestData, this.signatureMethod, this.time);
        return SignedValue;
    }

    public boolean verifyPin() {
        boolean flag = this.jna.verifyPin(this.pinCode);
        return flag;
    }
}

