/*
 * Decompiled with CFR 0.152.
 */
package com.kgofd.ofd.signinter;

import com.kgofd.ofd.signinter.SignatureInter;
import com.kgofd.ofd.signinter.SignatureInterBase;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.Map;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.io.ZipInputStream;
import net.lingala.zip4j.model.FileHeader;
import org.kg.bouncycastle.asn1.x509.X509CertificateStructure;

public abstract class SignatureInterByGB
extends SignatureInterBase
implements SignatureInter {
    @Override
    public X509CertificateStructure getCer() throws IOException {
        return null;
    }

    @Override
    public String getSignMethod() {
        return "1.2.156.10197.1.501";
    }

    @Override
    public String getDigestMethod() {
        return "1.2.156.10197.1.401";
    }

    @Override
    public byte[] getDigestData(ZipInputStream zis) throws IOException {
        MessageDigest messageDigest;
        try {
            try {
                messageDigest = MessageDigest.getInstance("SM3", "KGBC");
                int len = -1;
                byte[] buff = new byte[4096];
                while ((len = zis.read(buff)) != -1) {
                    messageDigest.update(buff, 0, len);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            if (zis != null) {
                zis.close();
            }
        }
        return messageDigest.digest();
    }

    @Override
    public byte[] getToSignData(String signDirPath, ZipFile zipFile, String time) throws IOException, ZipException {
        FileHeader header = zipFile.getFileHeader(String.valueOf(signDirPath) + "/Signature.xml");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("xmlPath", "/" + signDirPath + "/Signature.xml");
        map.put("time", time);
        ZipInputStream zis = zipFile.getInputStream(header);
        try {
            byte[] signdata;
            MessageDigest messageDigest;
            try {
                messageDigest = MessageDigest.getInstance("SM3", "KGBC");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            int len = -1;
            byte[] buff = new byte[4096];
            while ((len = zis.read(buff)) != -1) {
                messageDigest.update(buff, 0, len);
            }
            byte[] hash = messageDigest.digest();
            byte[] byArray = signdata = this.sign(hash, map);
            return byArray;
        }
        finally {
            if (zis != null) {
                zis.close();
            }
        }
    }

    @Override
    public byte[] getSignData(byte[] toSignData) throws IOException {
        throw new RuntimeException("SignatureInterByGB -> getSignData \u672a\u5b9e\u73b0");
    }

    @Override
    public byte[] createDatFile(byte[] toSignData, byte[] signData, String signDirPath) throws IOException {
        throw new RuntimeException("SignatureInterByGB -> createDatFile \u672a\u5b9e\u73b0");
    }

    public abstract byte[] sign(byte[] var1, Map<String, Object> var2);
}

