/*
 * Decompiled with CFR 0.152.
 */
package com.kgofd.ofd.signinter;

import com.kgofd.encrypt.KGDefaultMessageDigest;
import com.kgofd.kgcore.SealInformation;
import com.kgofd.ofd.executes.OfdElectronicSeal4KG;
import com.kgofd.ofd.signinter.SignatureInter;
import com.kgofd.ofd.signinter.tsa.TimeStampInter;
import com.kgofd.ofd.utils.KGOfdUtils;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import net.lingala.zip4j.io.ZipInputStream;

public abstract class SignatureInterBase
implements SignatureInter {
    protected OfdElectronicSeal4KG ofdElectronicSeal4KG;
    protected KGOfdUtils ofdUtils = new KGOfdUtils();
    protected TimeStampInter timeStampInter;

    public TimeStampInter getTimeStampInter() {
        return this.timeStampInter;
    }

    public void setTimeStampInter(TimeStampInter timeStampInter) {
        this.timeStampInter = timeStampInter;
    }

    @Override
    public SealInformation getSeal() throws IOException {
        return this.ofdElectronicSeal4KG.kgElectronicSeal.getSeal();
    }

    @Override
    public String getProviderName() {
        return "KingGrid";
    }

    @Override
    public String getCompany() {
        return "KingGrid";
    }

    @Override
    public String getVersion() {
        return "4.0";
    }

    protected void close(Closeable ... closeableList) {
        try {
            Closeable[] closeableArray = closeableList;
            int n = closeableList.length;
            int n2 = 0;
            while (n2 < n) {
                Closeable closeable = closeableArray[n2];
                if (closeable != null) {
                    closeable.close();
                }
                ++n2;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected byte[] getSHA1HashData(ZipInputStream zis) throws IOException {
        KGDefaultMessageDigest messageDigest = new KGDefaultMessageDigest();
        ByteArrayOutputStream baos = null;
        byte[] digestData = null;
        try {
            byte[] b = new byte[8192];
            int len = 0;
            baos = new ByteArrayOutputStream();
            while ((len = zis.read(b)) != -1) {
                baos.write(b, 0, len);
            }
            messageDigest.update(baos.toByteArray());
            digestData = messageDigest.digest();
        }
        catch (Throwable throwable) {
            this.close(baos);
            this.close(new Closeable[]{zis});
            throw throwable;
        }
        this.close(baos);
        this.close(new Closeable[]{zis});
        return digestData;
    }
}

