/*
 * Decompiled with CFR 0.152.
 */
package com.kgofd.ofd.seal;

import com.kgofd.commons.KGDateUtils;
import com.kgofd.encrypt.KGBase64;
import com.kgofd.ofd.seal.Seal;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.kg.bouncycastle.asn1.ASN1InputStream;
import org.kg.bouncycastle.asn1.ASN1Sequence;
import org.kg.bouncycastle.asn1.ASN1UTCTime;
import org.kg.bouncycastle.asn1.DERGeneralizedTime;
import org.kg.bouncycastle.asn1.DERIA5String;
import org.kg.bouncycastle.asn1.DERInteger;
import org.kg.bouncycastle.asn1.DEROctetString;
import org.kg.bouncycastle.asn1.DERUTF8String;
import org.kg.bouncycastle.asn1.DLSequence;

public class SealUtil {
    public static Seal getSeal(byte[] bytes) throws IOException {
        ASN1InputStream asn1InputStream = new ASN1InputStream(bytes);
        try {
            ASN1Sequence sequence = (ASN1Sequence)asn1InputStream.readObject();
            asn1InputStream.close();
            ASN1Sequence signInfo = (ASN1Sequence)sequence.getObjectAt(0);
            String esID = signInfo.getObjectAt(1).toString();
            DLSequence signHeader = (DLSequence)signInfo.getObjectAt(0);
            DERInteger signType = (DERInteger)signHeader.getObjectAt(1);
            DLSequence propertyInfo = (DLSequence)signInfo.getObjectAt(2);
            DERUTF8String sealName = (DERUTF8String)propertyInfo.getObjectAt(1);
            DLSequence picInfo = (DLSequence)signInfo.getObjectAt(3);
            DERIA5String sealPicType = (DERIA5String)picInfo.getObjectAt(0);
            DEROctetString sealPicData = (DEROctetString)picInfo.getObjectAt(1);
            DERInteger sealPicWidth = (DERInteger)picInfo.getObjectAt(2);
            DERInteger sealPicHeight = (DERInteger)picInfo.getObjectAt(3);
            Seal seal = new Seal();
            KGBase64 base64 = new KGBase64();
            if ("4".equals(signType.toString())) {
                DLSequence certList = (DLSequence)propertyInfo.getObjectAt(3);
                DEROctetString cert = (DEROctetString)certList.getObjectAt(0);
                String str = base64.encode(cert.getOctets());
                String createDate = ((DERGeneralizedTime)propertyInfo.getObjectAt(4)).getTimeString().substring(0, 14);
                String validStart = ((DERGeneralizedTime)propertyInfo.getObjectAt(5)).getTimeString().substring(0, 14);
                String validEnd = ((DERGeneralizedTime)propertyInfo.getObjectAt(6)).getTimeString().substring(0, 14);
                DEROctetString signCertInfo = (DEROctetString)sequence.getObjectAt(1);
                seal.setCreateDate(SealUtil.convertDate(createDate));
                seal.setValidStart(SealUtil.convertDate(validStart));
                seal.setValidEnd(SealUtil.convertDate(validEnd));
                seal.setProductCertData(base64.encode(signCertInfo.getOctets()));
                seal.setSignatureCertData(str);
                if (esID.length() == 14) {
                    seal.setSealType("GB");
                } else {
                    seal.setSealType("GMV4");
                }
            } else {
                Date date = null;
                try {
                    date = ((ASN1UTCTime)propertyInfo.getObjectAt(3)).getAdjustedDate();
                    String createDate = KGDateUtils.dateTime(date);
                    seal.setCreateDate(SealUtil.convertDate(createDate));
                    date = ((ASN1UTCTime)propertyInfo.getObjectAt(4)).getAdjustedDate();
                    String validStart = KGDateUtils.dateTime(date);
                    seal.setValidStart(SealUtil.convertDate(validStart));
                    date = ((ASN1UTCTime)propertyInfo.getObjectAt(5)).getAdjustedDate();
                    String validEnd = KGDateUtils.dateTime(date);
                    seal.setValidEnd(SealUtil.convertDate(validEnd));
                }
                catch (ParseException e) {
                    throw new RuntimeException(e);
                }
                seal.setSealType("GM");
            }
            seal.setEsid(esID);
            seal.setSealName(sealName.toString());
            seal.setWidth(Integer.parseInt(sealPicWidth.toString()));
            seal.setHeight(Integer.parseInt(sealPicHeight.toString()));
            seal.setSealPicData(base64.encode(sealPicData.getOctets()));
            seal.setSealPicType(sealPicType.getString());
            seal.setHeaderVer(signType.toString());
            Seal seal2 = seal;
            return seal2;
        }
        finally {
            if (asn1InputStream != null) {
                asn1InputStream.close();
            }
        }
    }

    private static String convertDate(String dateTime) {
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss");
            Date date = formatter.parse(dateTime);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return simpleDateFormat.format(date);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }
}

