/*
 * Decompiled with CFR 0.152.
 */
package com.kgofd.ofd.img.seal;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;

public class CircleSignCreator {
    private String text = null;
    private Font textFont = new Font("\u5b8b\u4f53", 1, 50);
    private String centerImage = "\u2605";
    private String attachOne = null;
    private String attachTwo = null;
    private String attachThree;
    private double stretchX = 0.6;
    private double stretchY = 1.0;
    private String businessLicenseNo;
    private Font businessLicenseNoFont = new Font("\u9ed1\u4f53", 600, 10);
    private double businessLicAngle = 80.0;
    private int blnOffsetOfCircleBorder = 12;
    private int imageSideLength = 400;
    private int imagePadding = 0;
    private int circleBorder = 4;
    private int circlePadding = 5;
    private Color color = Color.red;
    private double scale = 1.0;
    private Font centerImageFont = new Font("\u5b8b\u4f53", 1, 100);
    private double textAngle = 240.0;
    private Font attachOneFont = new Font("\u5b8b\u4f53", 1, 20);
    private Font attachTwoFont = new Font("\u5b8b\u4f53", 1, 20);
    private Font attachThreeFont = new Font("\u5b8b\u4f53", 1, 30);
    private int centerImagePaddingBottom = 10;
    private int attachPaddingBottom = 10;
    private BufferedImage bufferedImage = null;
    private Graphics2D g2 = null;
    private float xCoordinate = 0.0f;
    private float yCoordinate = 0.0f;
    int descent = 0;
    int fontPadding = 0;

    public void init() {
        if (this.textFont.getSize() < 26) {
            this.textFont = new Font(this.textFont.getFamily(), this.textFont.getStyle(), 26);
        }
        this.bufferedImage = new BufferedImage(this.imageSideLength, this.imageSideLength, 1);
        this.g2 = (Graphics2D)this.bufferedImage.getGraphics();
        this.g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.g2.setColor(Color.white);
        this.g2.fillRect(0, 0, this.imageSideLength, this.imageSideLength);
        this.g2.setColor(this.color);
        this.g2.setStroke(new BasicStroke(this.circleBorder));
        int x = 0;
        x = this.circleBorder % 2 == 0 ? this.circleBorder / 2 + this.imagePadding : this.circleBorder / 2 + 1 + this.imagePadding;
        int w = this.imageSideLength - (this.circleBorder + 1) - 2 * this.imagePadding;
        Ellipse2D.Double circle = new Ellipse2D.Double(x, x, w, w);
        this.g2.draw(circle);
    }

    public BufferedImage create() throws IOException {
        this.init();
        FontRenderContext context = null;
        Font font = null;
        FontMetrics fontMetrics = null;
        if (this.text != null && !"".equals(this.text)) {
            char[] charArray = this.text.toCharArray();
            int ilength = charArray.length;
            font = this.textFont;
            context = this.g2.getFontRenderContext();
            Rectangle2D bounds = font.getStringBounds(this.text, context);
            this.g2.setFont(this.textFont);
            double charWidth = bounds.getWidth() / (double)ilength * this.stretchX;
            double charHeight = -bounds.getY() * this.stretchY;
            int first = 0;
            int second = 0;
            boolean odd = false;
            if (ilength % 2 == 1) {
                first = (ilength - 1) / 2;
                odd = true;
            } else {
                first = ilength / 2 - 1;
                second = ilength / 2;
                odd = false;
            }
            double textInCircleRadius = (double)this.getTextExCircleRadius() - charHeight;
            double x0 = this.getCenterX();
            double y0 = (double)(this.circlePadding + this.circleBorder) + charHeight;
            double baseAngle = this.textAngle / 180.0 * Math.PI / (double)(ilength - 1);
            if (odd) {
                float y;
                float x;
                double ay;
                double ax;
                double aa;
                AffineTransform transform = AffineTransform.getScaleInstance(this.stretchX, this.stretchY);
                this.g2.setFont(this.textFont.deriveFont(transform));
                this.g2.drawString(String.valueOf(charArray[first]), (float)(x0 - charWidth / 2.0), (float)y0);
                int i = first + 1;
                while (i < ilength) {
                    aa = (double)(i - first) * baseAngle;
                    ax = (double)(this.imageSideLength / 2) + textInCircleRadius * Math.sin(aa);
                    ay = (double)(this.imageSideLength / 2) - textInCircleRadius * Math.cos(aa);
                    x = (float)(ax - charWidth * Math.cos(aa) / 2.0);
                    y = (float)(ay - charWidth * Math.sin(aa) / 2.0);
                    this.drawCharAndRotate(this.g2, charArray[i], aa, x, y, font);
                    ++i;
                }
                i = first - 1;
                while (i > -1) {
                    aa = (double)(first - i) * baseAngle;
                    ax = (double)(this.imageSideLength / 2) - textInCircleRadius * Math.sin(aa);
                    ay = (double)(this.imageSideLength / 2) - textInCircleRadius * Math.cos(aa);
                    x = (float)(ax - charWidth * Math.cos(aa) / 2.0);
                    y = (float)(ay + charWidth * Math.sin(aa) / 2.0);
                    this.drawCharAndRotate(this.g2, charArray[i], -aa, x, y, font);
                    --i;
                }
            } else {
                float y;
                float x;
                double ay;
                double ax;
                double aa = 0.0;
                int i = second;
                while (i < ilength) {
                    aa = i == second ? baseAngle / 2.0 : (aa += baseAngle);
                    ax = (double)(this.imageSideLength / 2) + textInCircleRadius * Math.sin(aa);
                    ay = (double)(this.imageSideLength / 2) - textInCircleRadius * Math.cos(aa);
                    x = (float)(ax - charWidth * Math.cos(aa) / 2.0);
                    y = (float)(ay - charWidth * Math.sin(aa) / 2.0);
                    this.drawCharAndRotate(this.g2, charArray[i], aa, x, y, font);
                    ++i;
                }
                aa = 0.0;
                i = first;
                while (i > -1) {
                    aa = i == first ? baseAngle / 2.0 : (aa += baseAngle);
                    ax = (double)(this.imageSideLength / 2) - textInCircleRadius * Math.sin(aa);
                    ay = (double)(this.imageSideLength / 2) - textInCircleRadius * Math.cos(aa);
                    x = (float)(ax - charWidth * Math.cos(aa) / 2.0);
                    y = (float)(ay + charWidth * Math.sin(aa) / 2.0);
                    this.drawCharAndRotate(this.g2, charArray[i], -aa, x, y, font);
                    --i;
                }
            }
        }
        this.drawBusinessLicenseNo();
        font = this.centerImageFont;
        this.g2.setFont(font);
        fontMetrics = this.g2.getFontMetrics();
        int stringWidth = fontMetrics.stringWidth(this.centerImage);
        int ascent = fontMetrics.getAscent();
        int leading = fontMetrics.getLeading();
        this.descent = fontMetrics.getDescent() + this.centerImagePaddingBottom;
        this.xCoordinate = this.getCenterX() - stringWidth / 2;
        this.yCoordinate = this.getCenterY() + ascent / 2 - leading;
        this.g2.drawString(this.centerImage, this.xCoordinate, this.yCoordinate);
        if (this.attachOne != null && !"".equals(this.attachOne)) {
            this.drawAttchText(this.g2, this.attachOne, this.attachOneFont, this.fontPadding);
        }
        if (this.attachTwo != null && !"".equals(this.attachTwo)) {
            this.drawAttchText(this.g2, this.attachTwo, this.attachTwoFont, 0);
        }
        if (this.attachThree != null && !"".equals(this.attachThree)) {
            this.drawAttchText(this.g2, this.attachThree, this.attachThreeFont, 0);
        }
        this.g2.dispose();
        if (this.scale == 1.0) {
            return this.bufferedImage;
        }
        Double newImageWidht = (double)this.imageSideLength * this.scale;
        Double newImageHeight = (double)this.imageSideLength * this.scale;
        Image image = this.bufferedImage.getScaledInstance(newImageWidht.intValue(), newImageHeight.intValue(), 4);
        BufferedImage bufImg = new BufferedImage(image.getWidth(null), image.getHeight(null), 1);
        Graphics2D g = bufImg.createGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return bufImg;
    }

    private void drawBusinessLicenseNo() {
        block6: {
            FontMetrics fontMetrics = null;
            if (this.businessLicenseNo == null || this.businessLicenseNo.trim().length() == 0) break block6;
            String bizzLicNo = this.businessLicenseNo.trim();
            int length = bizzLicNo.length();
            double apartAngle = this.businessLicAngle / 180.0 * Math.PI / (double)(length - 1);
            this.g2.setFont(this.businessLicenseNoFont);
            fontMetrics = this.g2.getFontMetrics();
            double charWidth = 0.0;
            double disx = this.imageSideLength / 2;
            double disy = this.imageSideLength - (this.circleBorder + this.blnOffsetOfCircleBorder);
            int index = length / 2;
            String c = null;
            double xscale = 1.5;
            double yscale = 2.0;
            if (length % 2 == 0) {
                double y;
                double x;
                AffineTransform rotateTransform;
                double offsetAngle = 0.0;
                int i = 1;
                while (i <= length / 2) {
                    c = bizzLicNo.substring(index - i, index - i + 1);
                    offsetAngle = i == 1 ? apartAngle / 2.0 : (offsetAngle += apartAngle);
                    rotateTransform = AffineTransform.getRotateInstance(offsetAngle);
                    rotateTransform.scale(xscale, yscale);
                    this.g2.setFont(this.businessLicenseNoFont.deriveFont(rotateTransform));
                    fontMetrics = this.g2.getFontMetrics();
                    charWidth = fontMetrics.stringWidth(c);
                    x = disx - Math.sin(offsetAngle) * (disy / 2.0) - charWidth / 2.0 * Math.cos(offsetAngle);
                    y = disy / 2.0 + Math.cos(offsetAngle) * (disy / 2.0) - charWidth / 2.0 * Math.sin(offsetAngle);
                    this.g2.drawString(c, (float)x, (float)y);
                    ++i;
                }
                i = 0;
                while (i < length / 2) {
                    c = bizzLicNo.substring(index + i, index + i + 1);
                    offsetAngle = i == 0 ? apartAngle / 2.0 : (offsetAngle += apartAngle);
                    rotateTransform = AffineTransform.getRotateInstance(-offsetAngle);
                    rotateTransform.scale(xscale, yscale);
                    this.g2.setFont(this.businessLicenseNoFont.deriveFont(rotateTransform));
                    fontMetrics = this.g2.getFontMetrics();
                    charWidth = fontMetrics.stringWidth(c);
                    x = disx + Math.sin(offsetAngle) * (disy / 2.0) - charWidth / 2.0 * Math.cos(offsetAngle);
                    y = disy / 2.0 + Math.cos(offsetAngle) * (disy / 2.0) + charWidth * Math.sin(offsetAngle) / 2.0;
                    this.g2.drawString(c, (float)x, (float)y);
                    ++i;
                }
            } else {
                double y;
                double x;
                AffineTransform rotateTransform;
                double offsetAngle = 0.0;
                AffineTransform scale = AffineTransform.getScaleInstance(xscale, yscale);
                this.g2.setFont(this.businessLicenseNoFont.deriveFont(scale));
                c = bizzLicNo.substring(index, index + 1);
                fontMetrics = this.g2.getFontMetrics();
                charWidth = fontMetrics.stringWidth(c);
                this.g2.drawString(c, (float)(disx - charWidth / 2.0), (float)disy);
                int i = 1;
                while (i <= length / 2) {
                    c = bizzLicNo.substring(index - i, index - i + 1);
                    rotateTransform = AffineTransform.getRotateInstance(offsetAngle += apartAngle);
                    rotateTransform.scale(xscale, yscale);
                    this.g2.setFont(this.businessLicenseNoFont.deriveFont(rotateTransform));
                    fontMetrics = this.g2.getFontMetrics();
                    charWidth = fontMetrics.stringWidth(c);
                    x = disx - Math.sin(offsetAngle) * (disy / 2.0) - charWidth * Math.cos(offsetAngle) / 2.0;
                    y = disy / 2.0 + Math.cos(offsetAngle) * (disy / 2.0) - charWidth * Math.sin(offsetAngle) / 2.0;
                    this.g2.drawString(c, (float)x, (float)y);
                    ++i;
                }
                offsetAngle = 0.0;
                i = 1;
                while (i <= length / 2) {
                    c = bizzLicNo.substring(index + i, index + i + 1);
                    rotateTransform = AffineTransform.getRotateInstance(-(offsetAngle += apartAngle));
                    rotateTransform.scale(xscale, yscale);
                    this.g2.setFont(this.businessLicenseNoFont.deriveFont(rotateTransform));
                    fontMetrics = this.g2.getFontMetrics();
                    charWidth = fontMetrics.stringWidth(c);
                    x = disx + Math.sin(offsetAngle) * (disy / 2.0) - charWidth * Math.cos(offsetAngle) / 2.0;
                    y = disy / 2.0 + Math.cos(offsetAngle) * (disy / 2.0) + charWidth * Math.sin(offsetAngle) / 2.0;
                    this.g2.drawString(c, (float)x, (float)y);
                    ++i;
                }
            }
        }
    }

    private void drawAttchText(Graphics2D g2, String attachText, Font font, int fontPadding) {
        int len = attachText.length();
        AffineTransform transform = AffineTransform.getScaleInstance(this.stretchX, this.stretchY);
        Font f2 = font.deriveFont(transform);
        g2.setFont(f2);
        FontMetrics fontMetrics = g2.getFontMetrics();
        int attachTextWidth = fontMetrics.stringWidth(attachText);
        float charWidth = attachTextWidth / len;
        int ascent = fontMetrics.getAscent();
        float startX = (float)this.getCenterX() - (float)(attachTextWidth + len * fontPadding) / 2.0f;
        this.yCoordinate = this.yCoordinate + (float)this.descent + (float)ascent;
        int i = 0;
        while (i < len) {
            this.xCoordinate = charWidth * (float)i + (float)fontPadding * ((float)i + 0.5f) + startX;
            g2.drawString(String.valueOf(attachText.charAt(i)), this.xCoordinate, this.yCoordinate);
            ++i;
        }
        this.descent = fontMetrics.getDescent() + this.attachPaddingBottom;
    }

    private void drawCharAndRotate(Graphics2D g, char c, double anage, float x, float y, Font font) {
        AffineTransform transform = AffineTransform.getRotateInstance(anage);
        transform.scale(this.stretchX, this.stretchY);
        Font f2 = font.deriveFont(transform);
        g.setFont(f2);
        g.drawString(String.valueOf(c), x, y);
    }

    private int getCenterX() {
        return this.imageSideLength / 2;
    }

    private int getCenterY() {
        return this.imageSideLength / 2;
    }

    private int getTextExCircleRadius() {
        return this.imageSideLength / 2 - this.circlePadding - this.circleBorder;
    }

    public int getImageSideLength() {
        return this.imageSideLength;
    }

    public void setImageSideLength(int imageHeight) {
        this.imageSideLength = imageHeight;
    }

    public int getImagePadding() {
        return this.imagePadding;
    }

    public void setImagePadding(int imagePadding) {
        this.imagePadding = imagePadding;
    }

    public float getCircleBorder() {
        return this.circleBorder;
    }

    public void setCircleBorder(int circleBorder) {
        this.circleBorder = circleBorder;
    }

    public int getCirclePadding() {
        return this.circlePadding;
    }

    public void setCirclePadding(int circlePadding) {
        this.circlePadding = circlePadding;
    }

    public double getTextAngle() {
        return this.textAngle;
    }

    public void setTextAngle(double textAngle) {
        this.textAngle = textAngle;
    }

    public int getAttachPaddingBottom() {
        return this.attachPaddingBottom;
    }

    public void setAttachPaddingBottom(int attachPaddingBottom) {
        this.attachPaddingBottom = attachPaddingBottom;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setText(String text, Font font) {
        this.text = text;
        this.textFont = font;
    }

    public String getCenterImage() {
        return this.centerImage;
    }

    public void setCenterImage(String centerImage) {
        this.centerImage = centerImage;
    }

    public void setCenterImage(String centerImage, Font font) {
        this.centerImage = centerImage;
        this.centerImageFont = font;
    }

    public int getCenterImagePaddingBottom() {
        return this.centerImagePaddingBottom;
    }

    public void setCenterImagePaddingBottom(int centerImagePaddingBottom) {
        this.centerImagePaddingBottom = centerImagePaddingBottom;
    }

    public String getAttachOne() {
        return this.attachOne;
    }

    public void setAttachOne(String attachOne) {
        this.attachOne = attachOne;
    }

    public void setAttachOne(String attachOne, Font font) {
        this.attachOne = attachOne;
        this.attachOneFont = font;
    }

    public String getAttachTwo() {
        return this.attachTwo;
    }

    public void setAttachTwo(String attachTwo) {
        this.attachTwo = attachTwo;
    }

    public void setAttachTwo(String attachTwo, Font font) {
        this.attachTwo = attachTwo;
        this.attachTwoFont = font;
    }

    public String getAttachThree() {
        return this.attachThree;
    }

    public void setAttachThree(String attachThree) {
        this.attachThree = attachThree;
    }

    public void setAttachThree(String attachThree, Font font) {
        this.attachThree = attachThree;
        this.attachThreeFont = font;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double scale) {
        this.scale = scale;
    }

    public int getFontPadding() {
        return this.fontPadding;
    }

    public void setFontPadding(int fontPadding) {
        this.fontPadding = fontPadding;
    }

    public double getStretchX() {
        return this.stretchX;
    }

    public void setStretchX(double stretchX) {
        this.stretchX = stretchX;
    }

    public double getStretchY() {
        return this.stretchY;
    }

    public void setStretchY(double stretchY) {
        this.stretchY = stretchY;
    }

    public String getBusinessLicenseNo() {
        return this.businessLicenseNo;
    }

    public void setBusinessLicenseNo(String businessLicenseNo) {
        this.businessLicenseNo = businessLicenseNo;
    }

    public Font getBusinessLicenseNoFont() {
        return this.businessLicenseNoFont;
    }

    public void setBusinessLicenseNoFont(Font businessLicenseNoFont) {
        this.businessLicenseNoFont = businessLicenseNoFont;
    }

    public double getBusinessLicAngle() {
        return this.businessLicAngle;
    }

    public void setBusinessLicAngle(double businessLicAngle) {
        this.businessLicAngle = businessLicAngle;
    }

    public int getBlnOffsetOfCircleBorder() {
        return this.blnOffsetOfCircleBorder;
    }

    public void setBlnOffsetOfCircleBorder(int blnOffsetOfCircleBorder) {
        this.blnOffsetOfCircleBorder = blnOffsetOfCircleBorder;
    }
}

