/*
 * Decompiled with CFR 0.152.
 */
package com.kgofd.ofd.executes.entity;

import com.kgofd.commons.KGCommonUtils;
import com.kgofd.commons.KGDateUtils;
import com.kgofd.encrypt.KGBase64;
import com.kgofd.encrypt.KGSM3Digest;
import com.kgofd.encrypt.SM2;
import com.kgofd.exception.KGVerifyException;
import com.kgofd.ofd.core.VerifyBeforeSign;
import com.kgofd.ofd.executes.OfdSignDetails;
import com.kgofd.ofd.executes.entity.SealInfo;
import com.kgofd.ofd.signinter.tsa.TimeStampValidInter;
import com.kgofd.ofd.utils.KGOfdUtils;
import java.io.IOException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.io.ZipInputStream;
import net.lingala.zip4j.model.FileHeader;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.kg.bouncycastle.asn1.DEROctetString;
import org.kg.bouncycastle.asn1.DLSequence;
import org.kg.bouncycastle.asn1.x509.X509CertificateStructure;

public class SignInfo {
    private SealInfo sealInfo;
    private X509CertificateStructure certificateStructure;
    private TimeStampValidInter timeStampValidInter;
    private String failReason = "";

    public TimeStampValidInter getTimeStampValidInter() {
        return this.timeStampValidInter;
    }

    public void setTimeStampValidInter(TimeStampValidInter timeStampValidInter) {
        this.timeStampValidInter = timeStampValidInter;
    }

    public SignInfo(SealInfo sealInfo, X509CertificateStructure certificateStructure) {
        this.sealInfo = sealInfo;
        this.certificateStructure = certificateStructure;
    }

    public SealInfo getSealInfo() {
        return this.sealInfo;
    }

    public X509CertificateStructure getCertificateStructure() {
        return this.certificateStructure;
    }

    public String getFailReason() {
        return this.failReason;
    }

    public boolean verifySign(OfdSignDetails signDetails) throws DocumentException, IOException, ZipException {
        boolean validity = true;
        try {
            VerifyBeforeSign verifyBeforeSign = new VerifyBeforeSign(null);
            verifyBeforeSign.verifySeal(this.sealInfo.getEseal());
            byte[] toSignData = this.sealInfo.getToSignData();
            byte[] signData = this.sealInfo.getSignData();
            if (signData.length != 64) {
                signData = KGOfdUtils.sigDataAns1To64bit(signData);
            }
            byte[] byPuk = this.certificateStructure.getSubjectPublicKeyInfo().getPublicKeyData().getBytes();
            byte[] pk = new byte[64];
            System.arraycopy(byPuk, 1, pk, 0, 64);
            SM2 sm2 = new SM2(true);
            if (!sm2.Verify(toSignData, signData, pk)) {
                validity = false;
                throw new KGVerifyException("\u9a8c\u8bc1\u7535\u5b50\u7b7e\u7ae0\u5931\u8d25\uff1a\u7535\u5b50\u7b7e\u7ae0\u7b7e\u540d\u503c\u9a8c\u8bc1\u5931\u8d25\uff01");
            }
            if (!this.cerValid()) {
                validity = false;
                throw new KGVerifyException("\u9a8c\u8bc1\u7535\u5b50\u7b7e\u7ae0\u5931\u8d25\uff1a\u7b7e\u7ae0\u4eba\u6570\u5b57\u8bc1\u4e66\u6709\u6548\u671f\u9a8c\u8bc1\u5931\u8d25\uff01");
            }
            if (!this.signdateValid(this.sealInfo.getSignDate())) {
                validity = false;
                throw new KGVerifyException("\u9a8c\u8bc1\u7535\u5b50\u7b7e\u7ae0\u5931\u8d25\uff1a\u9a8c\u8bc1\u7b7e\u7ae0\u7684\u65f6\u95f4\u6709\u6548\u6027\u5931\u8d25\uff0c\u7b7e\u7ae0\u65f6\u95f4\u4e0d\u5728\u7b7e\u7ae0\u4eba\u8bc1\u4e66\u6709\u6548\u671f\u8303\u56f4\u5185\uff01");
            }
            if (this.timeStampValidInter != null) {
                byte[] hash = this.sealInfo.getSignData();
                byte[] tsaData = this.sealInfo.getTimeData();
                String signdate = this.sealInfo.getSignDate();
                String timestamp = this.sealInfo.getTimeStamp();
                if (!this.timeStampValidInter.valid(tsaData, hash) || !this.validsigndate(timestamp, signdate)) {
                    validity = false;
                    throw new KGVerifyException("\u9a8c\u8bc1\u7535\u5b50\u7b7e\u7ae0\u5931\u8d25, \u65f6\u95f4\u6233\u9a8c\u8bc1\u5931\u8d25\uff01");
                }
            }
            ZipFile zipFile = signDetails.getZipFile();
            Document signatureDocument = KGOfdUtils.getDocument(zipFile, String.valueOf(this.sealInfo.getSignPath()) + "/Signature.xml");
            String signaturePath = zipFile.getFileHeader(String.valueOf(this.sealInfo.getSignPath()) + "/Signature.xml").getFileName();
            Element referencesEle = (Element)signatureDocument.selectSingleNode("/ofd:Signature/ofd:SignedInfo/ofd:References");
            String checkMethod = referencesEle.attributeValue("CheckMethod");
            List referenceNodes = signatureDocument.selectNodes("/ofd:Signature/ofd:SignedInfo/ofd:References/ofd:Reference");
            FileHeader fileHeader = null;
            ZipInputStream zis = null;
            int j = 0;
            while (j < referenceNodes.size()) {
                String checkValue;
                Element referenceEle = (Element)referenceNodes.get(j);
                String fileRef = referenceEle.attributeValue("FileRef");
                if (!fileRef.equals("OFD.xml")) {
                    fileRef = KGCommonUtils.converPath(fileRef, signaturePath);
                }
                if (!checkMethod.equals("1.2.156.10197.1.401") && !checkMethod.equals("SM3")) {
                    throw new RuntimeException(String.valueOf(signaturePath) + "\u4e2d\u7684" + "CheckMethod" + "\u4e0d\u652f\u6301\u8be5\u79cd\u7b97\u6cd5\u7c7b\u578b\uff1a" + checkMethod);
                }
                KGBase64 base64 = new KGBase64();
                fileHeader = zipFile.getFileHeader(fileRef);
                zis = zipFile.getInputStream(fileHeader);
                byte[] digestData = KGSM3Digest.getSm3Digest(zis);
                String code = base64.encode(digestData);
                if (!code.equals(checkValue = referenceEle.element("CheckValue").getTextTrim())) {
                    validity = false;
                    throw new KGVerifyException("\u9a8c\u8bc1\u7535\u5b50\u7b7e\u7ae0\u5931\u8d25, \u6587\u6863\u5185\u5bb9\u88ab\u7be1\u6539\uff01");
                }
                ++j;
            }
        }
        catch (KGVerifyException e) {
            validity = false;
            this.failReason = e.getMessage();
        }
        return validity;
    }

    private boolean signdateValid(String signdate) {
        boolean ret = false;
        Date startDate = this.certificateStructure.getStartDate().getDate();
        Date endDate = this.certificateStructure.getEndDate().getDate();
        Date date = KGDateUtils.parse2Date(signdate, "yyyy-MM-dd HH:mm:ss");
        if (startDate.before(date) && endDate.after(date)) {
            ret = true;
        }
        return ret;
    }

    public boolean cerValid() {
        boolean ret = false;
        Date startDate = this.certificateStructure.getStartDate().getDate();
        Date endDate = this.certificateStructure.getEndDate().getDate();
        Calendar calendar = Calendar.getInstance();
        Date nowDate = calendar.getTime();
        if (startDate.before(nowDate) && endDate.after(nowDate)) {
            ret = true;
        }
        return ret;
    }

    public boolean validsigndate(String time, String signdate) {
        String esid = this.sealInfo.getEsid();
        int num = esid.length();
        String signtime = signdate.substring(0, 14);
        String timestamp = time.substring(0, 14);
        if (num == 14) {
            signtime = KGDateUtils.getDate(signdate.substring(0, 14));
            signtime = KGDateUtils.dealHour(signtime, "sub", 8);
            signtime = KGDateUtils.toTimeStamp(signtime);
        }
        Long newtimestamp = Long.parseLong(timestamp);
        Long newsigntime = Long.parseLong(signtime);
        return newsigntime <= newtimestamp;
    }

    public boolean certMatchValid() {
        String certtype = this.sealInfo.getCerttype();
        byte[] cert = this.sealInfo.getCert();
        DLSequence sequence = this.sealInfo.getCertList();
        int num = sequence.size();
        boolean flag = false;
        if (certtype.equals("1")) {
            byte[] cert_list = null;
            int i = 0;
            while (i < num) {
                cert_list = ((DEROctetString)sequence.getObjectAt(i)).getOctets();
                flag = Arrays.equals(cert, cert_list);
                if (flag) break;
                ++i;
            }
        }
        return flag;
    }
}

