/*
 * Decompiled with CFR 0.152.
 */
package com.kgofd.ofd.executes;

import com.kgofd.commons.KGCommonUtils;
import com.kgofd.commons.KGDateUtils;
import com.kgofd.ofd.KGExecute;
import com.kgofd.ofd.utils.DocumentUtil;
import com.kgofd.ofd.utils.KGOfdUtils;
import com.sun.imageio.plugins.bmp.BMPImageReader;
import com.sun.imageio.plugins.gif.GIFImageReader;
import com.sun.imageio.plugins.jpeg.JPEGImageReader;
import com.sun.imageio.plugins.png.PNGImageReader;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.MemoryCacheImageInputStream;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;

public class OfdWatermark
extends KGExecute {
    private String text = "\u6c5f\u897f\u91d1\u683c\u79d1\u6280\u80a1\u4efd\u6709\u9650\u516c\u53f8";
    private String fontName = "\u5b8b\u4f53";
    private float fontSize = 25.0f;
    private Color fontColor = Color.GRAY;
    private int alpha = 127;
    private String creator = "KINGGRID";
    private float rotation = 45.0f;
    private float x;
    private float y;
    private boolean byDensity = false;
    private float density = 0.5f;
    private static final float DEFAULT_DENSITY = 0.5f;
    private float xDistance;
    private float yDistance;
    private boolean crossPage = false;
    private boolean startPage = true;
    private byte[] image;
    private int type;
    private int maxID;
    private String fontID;
    private String imgID;
    private Float skewingX;
    private Float skewingY;

    private double absSin(double radian) {
        return Math.abs(Math.sin(radian));
    }

    private double absCos(double radian) {
        return Math.abs(Math.cos(radian));
    }

    private float getCharWidth(float fontSize, char c) {
        if (KGCommonUtils.isChinese(c)) {
            return fontSize;
        }
        return fontSize / 2.0f;
    }

    public void setText(String text) {
        this.type = 1;
        this.text = text;
    }

    public void setPosition(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public void setFontName(String fontName) {
        this.fontName = fontName;
    }

    public void setFontSize(float fontSize) {
        this.fontSize = fontSize;
    }

    public void setFontColor(Color fontColor) {
        this.fontColor = fontColor;
    }

    public void setAlpha(int alpha) {
        this.alpha = alpha;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public void setRotation(float rotation) {
        this.rotation = rotation;
    }

    public void setDensity(float density) {
        this.byDensity = true;
        this.density = density;
    }

    public boolean isCrossPage() {
        return this.crossPage;
    }

    public void setCrossPage(boolean crossPage) {
        this.crossPage = crossPage;
    }

    public byte[] getImage() {
        return this.image;
    }

    public void setImage(byte[] image) {
        this.type = 2;
        this.image = image;
    }

    @Override
    protected void execute(int[] pagens, ZipFile zipFile) throws DocumentException, IOException, ZipException {
        Document documentXmlDocument = this.getDocuemntXml(zipFile);
        Element maxUnitIDElement = (Element)documentXmlDocument.selectSingleNode("/ofd:Document/ofd:CommonData/ofd:MaxUnitID");
        this.maxID = Integer.parseInt(maxUnitIDElement.getText());
        Document publicResDocument = this.addPublicRes(zipFile, documentXmlDocument);
        Document annotationsDocument = this.getAnnotationsXmlDocument(zipFile, documentXmlDocument);
        if (this.type == 2) {
            String format = this.getImageType(this.image);
            String img = "image_" + this.maxID + "." + format;
            KGOfdUtils.writeToZip(zipFile, "Doc_0/Res/" + img, this.image);
            Document documentRes = this.getDocumentResDocument(zipFile, documentXmlDocument, format, img);
            KGOfdUtils.writeToZip(zipFile, "Doc_0/DocumentRes.xml", documentRes);
        }
        this.addAnnot(zipFile, annotationsDocument);
        maxUnitIDElement.setText("" + this.maxID);
        KGOfdUtils.writeToZip(zipFile, "Doc_0/Annotations.xml", annotationsDocument);
        KGOfdUtils.writeToZip(zipFile, "Doc_0/Document.xml", documentXmlDocument);
        KGOfdUtils.writeToZip(zipFile, "Doc_0/PublicRes.xml", publicResDocument);
    }

    private void addAnnot(ZipFile zipFile, Document annotationsDocument) throws ZipException, DocumentException {
        Map<Integer, Element> pageMap = KGOfdUtils.converPage(zipFile);
        int i = 0;
        while (i < this.pagens.length) {
            Element pageElement = pageMap.get(this.pagens[i]);
            String baseLoc = pageElement.attributeValue("BaseLoc");
            baseLoc = KGCommonUtils.converPath(baseLoc, "Doc_0/Document.xml");
            String pageID = pageElement.attributeValue("ID");
            String annotationXmlPath = this.getAnnotationXmlPath(annotationsDocument, pageID);
            Document annotationDocument = null;
            if (annotationXmlPath == null) {
                Element annotationsElement = annotationsDocument.getRootElement();
                Element annotsPageElement = annotationsElement.addElement("ofd:Page");
                annotsPageElement.addAttribute("PageID", pageID);
                Element fileLocElement = annotsPageElement.addElement("ofd:FileLoc");
                annotationXmlPath = String.valueOf(baseLoc.substring(0, baseLoc.lastIndexOf("/") + 1)) + "Annotation.xml";
                fileLocElement.addText("/" + annotationXmlPath);
                annotationDocument = DocumentUtil.createDocument("ofd:PageAnnot");
            } else {
                annotationDocument = KGOfdUtils.getDocument(zipFile, annotationXmlPath);
            }
            Element pageAnnotElement = annotationDocument.getRootElement();
            if (this.type == 1) {
                if (this.byDensity) {
                    this.addMoreAnnot(pageAnnotElement, zipFile, baseLoc);
                } else {
                    float x = 0.0f;
                    float y = 0.0f;
                    this.addSingleAnnot(pageAnnotElement, zipFile, baseLoc, x, y, "");
                }
            } else if (this.type == 2) {
                if (this.byDensity) {
                    this.addMoreAnnot(pageAnnotElement, zipFile, baseLoc);
                } else {
                    float x = 0.0f;
                    float y = 0.0f;
                    this.addSingleImageAnnot(pageAnnotElement, zipFile, baseLoc, x, y);
                }
            }
            KGOfdUtils.writeToZip(zipFile, annotationXmlPath, annotationDocument);
            ++i;
        }
    }

    private Map<Character, List<Float>> getXYCoordinateList(float startX, float startY, float xDistance, float yDistance, float pageWidth, float pageHeight) {
        HashMap<Character, List<Float>> xYCoordinateMap = new HashMap<Character, List<Float>>();
        ArrayList<Float> xList = new ArrayList<Float>();
        ArrayList<Float> yList = new ArrayList<Float>();
        float leftXCoordinate = startX;
        float rightXCoordinate = startX;
        if (!this.crossPage || this.startPage) {
            while (!((leftXCoordinate -= xDistance) < 0.0f)) {
                xList.add(Float.valueOf(leftXCoordinate));
            }
            xList.add(Float.valueOf(startX));
            while (!((rightXCoordinate += xDistance) > pageWidth)) {
                xList.add(Float.valueOf(rightXCoordinate));
            }
        }
        float upYCoordinate = startY;
        float bottomYCoordinate = startY;
        while (!((upYCoordinate += yDistance) > pageHeight)) {
            yList.add(Float.valueOf(upYCoordinate));
        }
        yList.add(Float.valueOf(startY));
        while (!((bottomYCoordinate -= yDistance) < 0.0f)) {
            yList.add(Float.valueOf(bottomYCoordinate));
        }
        xYCoordinateMap.put(Character.valueOf('x'), xList);
        xYCoordinateMap.put(Character.valueOf('y'), yList);
        return xYCoordinateMap;
    }

    private void addMoreAnnot(Element pageAnnotElement, ZipFile zipFile, String baseLoc) throws ZipException, DocumentException {
        String physicalBox = this.getPhysicalBox(zipFile, baseLoc);
        String[] box = physicalBox.split(" ");
        float pageWidth = Float.parseFloat(box[2]);
        float pageHeight = Float.parseFloat(box[3]);
        float[] length = null;
        if (this.type == 2) {
            float[] imginfo = this.getImgInfo();
            length = this.getAppearanceWidthAndHeightLength(imginfo[0], imginfo[1]);
        } else if (this.type == 1) {
            float wmWidth = this.calcmoreWmWidth();
            length = this.getAppearanceWidthAndHeightLength(wmWidth, this.fontSize);
        }
        double minXDistance = (double)length[0];
        double minYDistance = length[1];
        if (this.density <= 0.0f || this.density > 1.0f) {
            this.density = 0.5f;
        }
        this.xDistance = (float)(minXDistance / (double)this.density);
        this.yDistance = (float)(minYDistance / (double)this.density);
        this.yDistance = this.xDistance > this.yDistance ? this.xDistance : this.yDistance;
        this.xDistance = this.yDistance;
        float startX = pageWidth / 2.0f;
        float startY = pageHeight / 2.0f;
        Map<Character, List<Float>> xYCoordinateMap = this.getXYCoordinateList(startX, startY, this.xDistance, this.xDistance, pageWidth, pageHeight);
        List<Float> xList = xYCoordinateMap.get(Character.valueOf('x'));
        List<Float> yList = xYCoordinateMap.get(Character.valueOf('y'));
        int i = 0;
        while (i < xList.size()) {
            if (xList.get(i).floatValue() == startX) {
                Collections.swap(xList, i, 0);
            }
            ++i;
        }
        i = 0;
        while (i < yList.size()) {
            if (yList.get(i).floatValue() == startY) {
                Collections.swap(yList, i, 0);
            }
            ++i;
        }
        for (float x : xList) {
            for (float y : yList) {
                if (this.type == 1) {
                    this.addSingleAnnot(pageAnnotElement, zipFile, baseLoc, x, y, "more");
                    continue;
                }
                if (this.type != 2) continue;
                float x1 = (float)((double)x - minXDistance / 2.0);
                float y1 = (float)((double)y - minYDistance / 2.0);
                this.addSingleImageAnnot(pageAnnotElement, zipFile, baseLoc, x1, y1);
            }
        }
    }

    private void addSingleAnnot(Element pageAnnotElement, ZipFile zipFile, String baseLoc, float X, float Y, String flag) throws ZipException, DocumentException {
        Element annotElement = pageAnnotElement.addElement("ofd:Annot");
        annotElement.addAttribute("ID", "" + this.maxID++).addAttribute("Type", "Watermark").addAttribute("Subtype", "FreeText").addAttribute("Creator", this.creator).addAttribute("LastModDate", KGDateUtils.dateTime(new Date()));
        Element appearanceElement = annotElement.addElement("ofd:Appearance");
        float wmWidth = this.calcWmWidth();
        float[] length = this.getAppearanceWidthAndHeightLength(wmWidth, this.fontSize);
        String physicalBox = this.getPhysicalBox(zipFile, baseLoc);
        float[] boundarys = this.getAppearanceBoundary(length[0], length[1], physicalBox);
        String data = "";
        if (flag.equals("more")) {
            X -= length[0] / 2.0f;
            Y -= length[1] / 2.0f;
        }
        float[] xypoints = new float[]{X, Y, boundarys[2], boundarys[3]};
        data = this.byDensity ? KGCommonUtils.array2String(xypoints) : KGCommonUtils.array2String(boundarys);
        appearanceElement.addAttribute("Boundary", data);
        Element textObject = appearanceElement.addElement("ofd:TextObject");
        textObject.addAttribute("ID", "" + this.maxID++).addAttribute("Boundary", "0 0 " + length[0] + " " + length[1]).addAttribute("Font", this.fontID).addAttribute("Size", "" + this.fontSize).addAttribute("CTM", this.getCTM(wmWidth, boundarys[0], boundarys[1]));
        Element fillColorElement = textObject.addElement("ofd:FillColor");
        fillColorElement.addAttribute("Value", String.valueOf(this.fontColor.getRed()) + " " + this.fontColor.getGreen() + " " + this.fontColor.getBlue()).addAttribute("Alpha", "" + this.alpha);
        Element textCodeElement = textObject.addElement("ofd:TextCode");
        float[] deltaX = new float[this.text.length()];
        int j = 0;
        while (j < this.text.length()) {
            deltaX[j] = this.getCharWidth(this.fontSize, this.text.charAt(j));
            ++j;
        }
        textCodeElement.addAttribute("X", "0").addAttribute("Y", "" + (float)((double)this.fontSize * 0.8333333333333334)).addAttribute("DeltaX", KGCommonUtils.array2String(deltaX));
        textCodeElement.addText(this.text);
    }

    private void addSingleImageAnnot(Element pageAnnotElement, ZipFile zipFile, String baseLoc, float X, float Y) throws ZipException, DocumentException {
        Element annotElement = pageAnnotElement.addElement("ofd:Annot");
        annotElement.addAttribute("ID", "" + this.maxID++).addAttribute("Type", "Watermark").addAttribute("Subtype", "FreeText").addAttribute("Creator", this.creator).addAttribute("LastModDate", KGDateUtils.dateTime(new Date()));
        Element appearanceElement = annotElement.addElement("ofd:Appearance");
        float[] imginfo = this.getImgInfo();
        float[] length = this.getAppearanceWidthAndHeightLength(imginfo[0], imginfo[1]);
        String physicalBox = this.getPhysicalBox(zipFile, baseLoc);
        float[] boundarys = this.getAppearanceBoundary(length[0], length[1], physicalBox);
        String data = "";
        float[] xypoints = new float[]{X, Y, boundarys[2], boundarys[3]};
        data = this.byDensity ? KGCommonUtils.array2String(xypoints) : KGCommonUtils.array2String(boundarys);
        appearanceElement.addAttribute("Boundary", data);
        Element imageObject = appearanceElement.addElement("ofd:ImageObject");
        imageObject.addAttribute("ID", "" + this.maxID++).addAttribute("Boundary", "0 0 " + length[0] + " " + length[1]).addAttribute("Alpha", "" + this.alpha).addAttribute("ResourceID", this.imgID).addAttribute("CTM", this.getImgCTM(imginfo[0], imginfo[1], boundarys[0], boundarys[1]));
    }

    private String getAnnotationXmlPath(Document annotationsDocument, String pageID) {
        List annotsPageList = annotationsDocument.selectNodes("/ofd:Annotations/ofd:Page");
        if (annotsPageList != null) {
            for (Element annotsPageElement : annotsPageList) {
                String annotsPageID = annotsPageElement.attributeValue("PageID");
                if (!pageID.equals(annotsPageID)) continue;
                String annotationXmlPath = annotsPageElement.selectSingleNode("ofd:FileLoc").getText();
                annotationXmlPath = KGCommonUtils.converPath(annotationXmlPath, "Doc_0/Annotations.xml");
                return annotationXmlPath;
            }
        }
        return null;
    }

    private String getCTM(float width, float lux, float luy) {
        double inRadians_180;
        float rota = Math.abs(360.0f - this.rotation) % 360.0f;
        double radians = Math.toRadians(rota);
        float[] ctm = new float[6];
        if (rota == 0.0f) {
            ctm[0] = 1.0f;
            ctm[1] = 0.0f;
            ctm[2] = 0.0f;
            ctm[3] = 1.0f;
        } else if (rota == 90.0f) {
            ctm[0] = 0.0f;
            ctm[1] = 1.0f;
            ctm[2] = -1.0f;
            ctm[3] = 0.0f;
        } else if (rota == 180.0f) {
            ctm[0] = -1.0f;
            ctm[1] = 0.0f;
            ctm[2] = 0.0f;
            ctm[3] = -1.0f;
        } else if (rota == 270.0f) {
            ctm[0] = 0.0f;
            ctm[1] = -1.0f;
            ctm[2] = 1.0f;
            ctm[3] = 0.0f;
        } else {
            ctm[0] = (float)Math.cos(radians);
            ctm[1] = (float)Math.sin(radians);
            ctm[2] = (float)Math.sin(radians) * -1.0f;
            ctm[3] = (float)Math.cos(radians);
        }
        float textDiagonal = (float)Math.sqrt(Math.pow(width, 2.0) + Math.pow(this.fontSize, 2.0));
        float diagonalRadians = (float)Math.atan(this.fontSize / width);
        float halfDiagonal = textDiagonal / 2.0f;
        double rotateCenterWidth = 0.0;
        double rotateCenterHeight = 0.0;
        if (0.0f <= rota && rota <= 90.0f) {
            rotateCenterWidth = (double)halfDiagonal * Math.cos((double)diagonalRadians + radians);
            rotateCenterHeight = (double)halfDiagonal * Math.sin((double)diagonalRadians + radians);
        } else if (90.0f < rota && rota <= 180.0f) {
            inRadians_180 = Math.toRadians(180.0);
            rotateCenterWidth = (double)halfDiagonal * Math.cos(inRadians_180 - radians - (double)diagonalRadians) * -1.0;
            rotateCenterHeight = (double)halfDiagonal * Math.sin(inRadians_180 - radians - (double)diagonalRadians);
        } else if (180.0f < rota && rota <= 270.0f) {
            inRadians_180 = Math.toRadians(180.0);
            rotateCenterWidth = (double)halfDiagonal * Math.cos(radians - inRadians_180 + (double)diagonalRadians) * -1.0;
            rotateCenterHeight = (double)halfDiagonal * Math.sin(radians - inRadians_180 + (double)diagonalRadians) * -1.0;
        } else if (270.0f < rota && rota <= 360.0f) {
            double inRadians_360 = Math.toRadians(360.0);
            rotateCenterWidth = (double)halfDiagonal * Math.cos(inRadians_360 - radians - (double)diagonalRadians);
            rotateCenterHeight = (double)halfDiagonal * Math.sin(inRadians_360 - radians - (double)diagonalRadians) * -1.0;
        }
        float centerPointX = (float)((double)lux + rotateCenterWidth);
        float centerPointY = (float)((double)luy + rotateCenterHeight);
        if (this.skewingX == null) {
            this.skewingX = Float.valueOf(this.x - centerPointX);
        }
        if (this.skewingY == null) {
            this.skewingY = Float.valueOf(this.y - centerPointY);
        }
        ctm[4] = this.skewingX.floatValue();
        ctm[5] = this.skewingY.floatValue();
        return KGCommonUtils.array2String(ctm);
    }

    private String getImgCTM(float width, float height, float lux, float luy) {
        double inRadians_180;
        float rota = Math.abs(360.0f - this.rotation) % 360.0f;
        double radians = Math.toRadians(rota);
        float[] ctm1 = new float[6];
        float[] ctm2 = new float[6];
        float[] ctm = new float[6];
        ctm1[0] = width;
        ctm1[1] = 0.0f;
        ctm1[2] = 0.0f;
        ctm1[3] = height;
        ctm1[4] = 0.0f;
        ctm1[5] = 0.0f;
        if (rota == 0.0f) {
            ctm2[0] = 1.0f;
            ctm2[1] = 0.0f;
            ctm2[2] = 0.0f;
            ctm2[3] = 1.0f;
        } else if (rota == 90.0f) {
            ctm2[0] = 0.0f;
            ctm2[1] = 1.0f;
            ctm2[2] = -1.0f;
            ctm2[3] = 0.0f;
        } else if (rota == 180.0f) {
            ctm2[0] = -1.0f;
            ctm2[1] = 0.0f;
            ctm2[2] = 0.0f;
            ctm2[3] = -1.0f;
        } else if (rota == 270.0f) {
            ctm2[0] = 0.0f;
            ctm2[1] = -1.0f;
            ctm2[2] = 1.0f;
            ctm2[3] = 0.0f;
        } else {
            ctm2[0] = (float)Math.cos(radians);
            ctm2[1] = (float)Math.sin(radians);
            ctm2[2] = (float)Math.sin(radians) * -1.0f;
            ctm2[3] = (float)Math.cos(radians);
        }
        float textDiagonal = (float)Math.sqrt(Math.pow(width, 2.0) + Math.pow(height, 2.0));
        float diagonalRadians = (float)Math.atan(height / width);
        float halfDiagonal = textDiagonal / 2.0f;
        double rotateCenterWidth = 0.0;
        double rotateCenterHeight = 0.0;
        if (0.0f <= rota && rota <= 90.0f) {
            rotateCenterWidth = (double)halfDiagonal * Math.cos((double)diagonalRadians + radians);
            rotateCenterHeight = (double)halfDiagonal * Math.sin((double)diagonalRadians + radians);
        } else if (90.0f < rota && rota <= 180.0f) {
            inRadians_180 = Math.toRadians(180.0);
            rotateCenterWidth = (double)halfDiagonal * Math.cos(inRadians_180 - radians - (double)diagonalRadians) * -1.0;
            rotateCenterHeight = (double)halfDiagonal * Math.sin(inRadians_180 - radians - (double)diagonalRadians);
        } else if (180.0f < rota && rota <= 270.0f) {
            inRadians_180 = Math.toRadians(180.0);
            rotateCenterWidth = (double)halfDiagonal * Math.cos(radians - inRadians_180 + (double)diagonalRadians) * -1.0;
            rotateCenterHeight = (double)halfDiagonal * Math.sin(radians - inRadians_180 + (double)diagonalRadians) * -1.0;
        } else if (270.0f < rota && rota <= 360.0f) {
            double inRadians_360 = Math.toRadians(360.0);
            rotateCenterWidth = (double)halfDiagonal * Math.cos(inRadians_360 - radians - (double)diagonalRadians);
            rotateCenterHeight = (double)halfDiagonal * Math.sin(inRadians_360 - radians - (double)diagonalRadians) * -1.0;
        }
        float centerPointX = (float)((double)lux + rotateCenterWidth);
        float centerPointY = (float)((double)luy + rotateCenterHeight);
        float skewingX = this.x - centerPointX;
        float skewingY = this.y - centerPointY;
        ctm2[4] = skewingX;
        ctm2[5] = skewingY;
        ctm[0] = ctm1[0] * ctm2[0] + ctm1[1] * ctm2[2];
        ctm[1] = ctm1[0] * ctm2[1] + ctm1[1] * ctm2[3];
        ctm[2] = ctm1[2] * ctm2[0] + ctm1[3] * ctm2[2];
        ctm[3] = ctm1[2] * ctm2[1] + ctm1[3] * ctm2[3];
        ctm[4] = ctm1[4] * ctm2[0] + ctm1[5] * ctm2[2] + ctm2[4];
        ctm[5] = ctm1[4] * ctm2[1] + ctm1[5] * ctm2[3] + ctm2[5];
        return KGCommonUtils.array2String(ctm);
    }

    private float calcmoreWmWidth() {
        float width = 0.0f;
        width = (float)this.text.length() * this.fontSize;
        return width;
    }

    private float calcWmWidth() {
        float width = 0.0f;
        int i = 0;
        while (i < this.text.length()) {
            width += this.getCharWidth(this.fontSize, this.text.charAt(i));
            ++i;
        }
        return width;
    }

    private float[] getAppearanceWidthAndHeightLength(float width, float height) {
        float[] appearanceWidthAndHeightLength = new float[2];
        float quadrant = Math.abs(360.0f - this.rotation) % 360.0f;
        if (quadrant == 0.0f || quadrant == 180.0f) {
            appearanceWidthAndHeightLength[0] = width;
            appearanceWidthAndHeightLength[1] = height;
            return appearanceWidthAndHeightLength;
        }
        if (quadrant == 90.0f || quadrant == 270.0f) {
            appearanceWidthAndHeightLength[0] = height;
            appearanceWidthAndHeightLength[1] = width;
            return appearanceWidthAndHeightLength;
        }
        double radians = Math.toRadians(quadrant);
        double textDiagonal = Math.sqrt(Math.pow(width, 2.0) + Math.pow(height, 2.0));
        double diagonalRadians = Math.atan(height / width);
        double appearanceWidth = (double)width * this.absCos(radians) + (double)height * this.absCos(Math.toRadians(90.0f - quadrant));
        double appearanceHeight = 0.0;
        if (0.0f < quadrant && quadrant < 90.0f) {
            appearanceHeight = textDiagonal * this.absSin(radians + diagonalRadians);
        } else if (90.0f < quadrant && quadrant < 180.0f) {
            double inRadians_180 = Math.toRadians(180.0);
            appearanceHeight = textDiagonal * this.absSin(inRadians_180 - radians + diagonalRadians);
        } else if (180.0f < quadrant && quadrant < 270.0f) {
            double inRadians_180 = Math.toRadians(180.0);
            appearanceHeight = textDiagonal * this.absSin(radians - inRadians_180 + diagonalRadians);
        } else if (270.0f < quadrant && quadrant < 360.0f) {
            double inRadians_360 = Math.toRadians(360.0);
            appearanceHeight = textDiagonal * this.absSin(inRadians_360 - radians + diagonalRadians);
        }
        appearanceWidthAndHeightLength[0] = (float)appearanceWidth;
        appearanceWidthAndHeightLength[1] = (float)appearanceHeight;
        return appearanceWidthAndHeightLength;
    }

    private float[] getAppearanceBoundary(float wmWidth, float wmHeight, String physicalBox) {
        String[] box = physicalBox.split(" ");
        float lux = 0.0f;
        float luy = 0.0f;
        if (this.x != 0.0f && this.y != 0.0f) {
            lux = this.x - wmWidth / 2.0f;
            luy = this.y - wmHeight / 2.0f;
        } else {
            float pageWidth = Float.parseFloat(box[2]);
            float pageHeight = Float.parseFloat(box[3]);
            this.x = pageWidth / 2.0f;
            this.y = pageHeight / 2.0f;
            lux = this.x - wmWidth / 2.0f;
            luy = this.y - wmHeight / 2.0f;
        }
        return new float[]{lux, luy, wmWidth, wmHeight};
    }

    private String getPhysicalBox(ZipFile zipFile, String pageBaseLoc) throws ZipException, DocumentException {
        String physicalBox = null;
        Document contentXml = KGOfdUtils.getDocument(zipFile, pageBaseLoc);
        Node areaNode = contentXml.selectSingleNode("/ofd:Page/ofd:Area");
        if (areaNode != null) {
            physicalBox = areaNode.selectSingleNode("ofd:PhysicalBox").getText();
        } else {
            Document documentXml = this.getDocuemntXml(zipFile);
            physicalBox = this.getCommonDataPhysicalBox(documentXml);
        }
        return physicalBox;
    }

    private Document addPublicRes(ZipFile zipFile, Document documentXmlDocument) throws ZipException, DocumentException {
        Node publicResNode = documentXmlDocument.selectSingleNode("/ofd:Document/ofd:CommonData/ofd:PublicRes");
        Element fontElement = null;
        Document publicResDocument = null;
        if (publicResNode == null) {
            Element commonDataElement = (Element)documentXmlDocument.selectSingleNode("/ofd:Document/ofd:CommonData");
            Element publicRes = commonDataElement.addElement("ofd:PublicRes");
            publicRes.addText("PublicRes.xml");
            publicResDocument = DocumentUtil.createDocument("ofd:Res");
            Element resElement = publicResDocument.getRootElement();
            resElement.addAttribute("BaseLoc", "Res");
            Element fontsElement = resElement.addElement("ofd:Fonts");
            fontElement = fontsElement.addElement("ofd:Font");
        } else {
            String publicResLoc = publicResNode.getText();
            publicResDocument = KGOfdUtils.getDocument(zipFile, publicResLoc = KGCommonUtils.converPath(publicResLoc, "Doc_0/Document.xml"));
            Element resElement = publicResDocument.getRootElement();
            Element fontsElement = (Element)resElement.selectSingleNode("ofd:Fonts");
            if (fontsElement == null) {
                fontsElement = resElement.addElement("ofd:Fonts");
                fontElement = fontsElement.addElement("ofd:Font");
            } else {
                Map<String, String> fontMap = DocumentUtil.getFontMap((Node)fontsElement);
                Set<Map.Entry<String, String>> entries = fontMap.entrySet();
                for (Map.Entry<String, String> entry : entries) {
                    if (!this.fontName.equals(entry.getValue())) continue;
                    this.fontID = entry.getKey();
                    break;
                }
                if (this.fontID == null) {
                    fontElement = fontsElement.addElement("ofd:Font");
                }
            }
        }
        if (fontElement != null) {
            this.fontID = "" + this.maxID++;
            fontElement.addAttribute("ID", this.fontID);
            fontElement.addAttribute("FontName", this.fontName);
        }
        return publicResDocument;
    }

    private Document getAnnotationsXmlDocument(ZipFile zipFile, Document documentXmlDocument) throws ZipException, DocumentException {
        Document annotationsDocument = null;
        Node annotationsNode = documentXmlDocument.selectSingleNode("/ofd:Document/ofd:Annotations");
        if (annotationsNode == null) {
            Element documentNode = documentXmlDocument.getRootElement();
            Element annotationsElement = documentNode.addElement("ofd:Annotations");
            annotationsElement.addText("Annotations.xml");
            annotationsDocument = DocumentUtil.createDocument("ofd:Annotations");
        } else {
            String annotationsLoc = annotationsNode.getText();
            annotationsLoc = KGCommonUtils.converPath(annotationsLoc, "Doc_0/Document.xml");
            annotationsDocument = KGOfdUtils.getDocument(zipFile, annotationsLoc);
        }
        return annotationsDocument;
    }

    private Document getDocumentResDocument(ZipFile zipFile, Document documentXmlDocument, String format, String img) throws ZipException, DocumentException {
        Node documentResNode = documentXmlDocument.selectSingleNode("/ofd:Document/ofd:CommonData/ofd:DocumentRes");
        Document documentResXml = null;
        if (documentResNode == null) {
            Element documentNode = documentXmlDocument.getRootElement();
            Element commonDataElem = documentNode.element("CommonData");
            Element documentResElement = commonDataElem.addElement("ofd:DocumentRes");
            documentResElement.addText("DocumentRes.xml");
            documentResXml = this.getDocumentResXmlDocument();
            this.setDocumentResXmlDocument(documentResXml, format, img);
        } else {
            documentResXml = KGOfdUtils.getDocument(zipFile, "Doc_0/DocumentRes.xml");
            this.setDocumentResXmlDocument(documentResXml, format, img);
        }
        return documentResXml;
    }

    private void setDocumentResXmlDocument(Document document, String format, String img) throws DocumentException {
        format = format.toUpperCase();
        this.imgID = "" + this.maxID++;
        Element root = document.getRootElement();
        Element multiMedias = root.element("MultiMedias");
        Element MultiMedia = multiMedias.addElement("ofd:MultiMedia");
        MultiMedia.addAttribute("ID", this.imgID);
        MultiMedia.addAttribute("Type", "Image");
        MultiMedia.addAttribute("Format", format);
        Element MediaFile = MultiMedia.addElement("ofd:MediaFile");
        MediaFile.addText(img);
    }

    private Document getDocumentResXmlDocument() throws DocumentException {
        Document documentResXml = null;
        documentResXml = DocumentUtil.createDocument("ofd:Res");
        Element root = documentResXml.getRootElement();
        root.addAttribute("BaseLoc", "Res");
        Element MultiMedias = root.addElement("ofd:MultiMedias");
        return documentResXml;
    }

    private String getCommonDataPhysicalBox(Document documentXml) {
        return documentXml.selectSingleNode("/ofd:Document/ofd:CommonData/ofd:PageArea/ofd:PhysicalBox").getText();
    }

    private Document getDocuemntXml(ZipFile zipFile) throws ZipException, DocumentException {
        return KGOfdUtils.getDocument(zipFile, "Doc_0/Document.xml");
    }

    private float pxtomm(float px) {
        float mm = px / 2.8346457f;
        return mm;
    }

    private float[] getImgInfo() {
        float width = 0.0f;
        float height = 0.0f;
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(this.image);
            BufferedImage buf = ImageIO.read(in);
            width = buf.getWidth();
            height = buf.getHeight();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        width = this.pxtomm(width);
        height = this.pxtomm(height);
        float[] info = new float[]{width, height};
        return info;
    }

    private String getImageType(byte[] bs) throws IOException {
        String type = "";
        ByteArrayInputStream bais = null;
        MemoryCacheImageInputStream mcis = null;
        try {
            bais = new ByteArrayInputStream(bs);
            mcis = new MemoryCacheImageInputStream(bais);
            Iterator<ImageReader> itr = ImageIO.getImageReaders(mcis);
            while (itr.hasNext()) {
                ImageReader reader = itr.next();
                if (reader instanceof GIFImageReader) {
                    type = "gif";
                    continue;
                }
                if (reader instanceof JPEGImageReader) {
                    type = "jpg";
                    continue;
                }
                if (reader instanceof PNGImageReader) {
                    type = "png";
                    continue;
                }
                if (!(reader instanceof BMPImageReader)) continue;
                type = "bmp";
            }
        }
        finally {
            if (bais != null) {
                try {
                    bais.close();
                }
                catch (IOException iOException) {}
            }
            if (mcis != null) {
                try {
                    mcis.close();
                }
                catch (IOException iOException) {}
            }
        }
        return type;
    }
}

