/*
 * Decompiled with CFR 0.152.
 */
package com.kgofd.ofd.executes;

import com.kgofd.commons.KGCommonUtils;
import com.kgofd.commons.KGDateUtils;
import com.kgofd.ofd.KGExecute;
import com.kgofd.ofd.executes.entity.SealInfo;
import com.kgofd.ofd.executes.entity.SignInfo;
import com.kgofd.ofd.utils.KGOfdUtils;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.model.FileHeader;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.kg.bouncycastle.asn1.ASN1GeneralizedTime;
import org.kg.bouncycastle.asn1.ASN1InputStream;
import org.kg.bouncycastle.asn1.ASN1Integer;
import org.kg.bouncycastle.asn1.ASN1OctetString;
import org.kg.bouncycastle.asn1.ASN1Sequence;
import org.kg.bouncycastle.asn1.ASN1String;
import org.kg.bouncycastle.asn1.ASN1TaggedObject;
import org.kg.bouncycastle.asn1.ASN1UTCTime;
import org.kg.bouncycastle.asn1.DERBitString;
import org.kg.bouncycastle.asn1.DERIA5String;
import org.kg.bouncycastle.asn1.DERInteger;
import org.kg.bouncycastle.asn1.DEROctetString;
import org.kg.bouncycastle.asn1.DERTaggedObject;
import org.kg.bouncycastle.asn1.DLSequence;
import org.kg.bouncycastle.asn1.x509.TBSCertificateStructure;
import org.kg.bouncycastle.asn1.x509.X509CertificateStructure;

public class OfdSignDetails
extends KGExecute {
    private List<SignInfo> signInfos = new ArrayList<SignInfo>();
    private ZipFile zipFile;

    @Override
    protected void execute(int[] pagens, ZipFile zipFile) throws DocumentException, ZipException, IOException {
        this.zipFile = zipFile;
        Document ofdDocument = KGOfdUtils.getDocument(zipFile, "OFD.xml");
        Element signaturesElement = (Element)ofdDocument.selectSingleNode("/ofd:OFD/ofd:DocBody/ofd:Signatures");
        if (signaturesElement == null) {
            throw new RuntimeException("\u8be5\u6587\u6863\u4e2d\u6ca1\u6709\u7b7e\u7ae0");
        }
        String signaturesPath = signaturesElement.getTextTrim();
        signaturesPath = KGCommonUtils.converPath(signaturesPath, "");
        Document signaturesDoc = KGOfdUtils.getDocument(zipFile, signaturesPath);
        List signatureEles = signaturesDoc.selectNodes("/ofd:Signatures/ofd:Signature");
        int i = 0;
        while (i < signatureEles.size()) {
            Element signatureElement = (Element)signatureEles.get(i);
            if (signatureElement.attributeValue("Type") == null || !"Sign".equals(signatureElement.attributeValue("Type"))) {
                int num;
                Object date;
                String signaturePath = signatureElement.attributeValue("BaseLoc");
                signaturePath = KGCommonUtils.converPath(signaturePath, signaturesPath);
                String signPath = signaturePath.substring(0, signaturePath.lastIndexOf("/"));
                SealInfo sealInfo = new SealInfo();
                sealInfo.setIndex(i + 1);
                sealInfo.setSignPath(signPath);
                Document signatureDocument = KGOfdUtils.getDocument(zipFile, signaturePath);
                Element signatureMethodEle = (Element)signatureDocument.selectSingleNode("/ofd:Signature/ofd:SignedInfo/ofd:SignatureMethod");
                String signatureMethod = signatureMethodEle.getTextTrim();
                sealInfo.setSignType(signatureMethod);
                Element references = (Element)signatureDocument.selectSingleNode("/ofd:Signature/ofd:SignedInfo/ofd:References");
                String hashType = references.attributeValue("CheckMethod");
                sealInfo.setHashType(hashType);
                List stampAnnots = signatureDocument.selectNodes("/ofd:Signature/ofd:SignedInfo/ofd:StampAnnot");
                int[] pages = new int[stampAnnots.size()];
                int j = 0;
                while (j < stampAnnots.size()) {
                    Element stampAnnot = (Element)stampAnnots.get(j);
                    String pageRef = stampAnnot.attribute("PageRef").getStringValue();
                    Map<Integer, Element> map = KGOfdUtils.converPage(zipFile);
                    int k = 0;
                    while (k < map.size()) {
                        Element element = map.get(k + 1);
                        if (pageRef.equals(element.attribute("ID").getStringValue())) {
                            pages[j] = k + 1;
                            break;
                        }
                        ++k;
                    }
                    ++j;
                }
                sealInfo.setPagen(pages);
                Element boundary = (Element)signatureDocument.selectNodes("/ofd:Signature/ofd:SignedInfo/ofd:StampAnnot").get(0);
                String[] boun = boundary.attributeValue("Boundary").split(" ");
                sealInfo.setLlx(Float.parseFloat(boun[0]));
                sealInfo.setLly(Float.parseFloat(boun[1]));
                sealInfo.setUrx(Float.parseFloat(boun[0]) + Float.parseFloat(boun[2]));
                sealInfo.setUry(Float.parseFloat(boun[1]) + Float.parseFloat(boun[3]));
                String signedValuePath = signatureDocument.selectSingleNode("/ofd:Signature/ofd:SignedValue").getText();
                signedValuePath = KGCommonUtils.converPath(signedValuePath, signaturePath);
                ASN1Sequence sequence = null;
                ASN1InputStream asn1In = null;
                try {
                    FileHeader fileHeader = zipFile.getFileHeader(signedValuePath);
                    asn1In = new ASN1InputStream((InputStream)zipFile.getInputStream(fileHeader));
                    sequence = (ASN1Sequence)asn1In.readObject();
                }
                finally {
                    if (asn1In != null) {
                        asn1In.close();
                    }
                }
                ASN1Sequence toSign = (ASN1Sequence)sequence.getObjectAt(0);
                ASN1Sequence eseal = (ASN1Sequence)toSign.getObjectAt(1);
                sealInfo.setEseal(eseal.getEncoded());
                ASN1Sequence esealInfo = (ASN1Sequence)eseal.getObjectAt(0);
                ASN1Sequence header = (ASN1Sequence)esealInfo.getObjectAt(0);
                DERIA5String esidstring = (DERIA5String)esealInfo.getObjectAt(1);
                String esid = esidstring.getString();
                sealInfo.setEsid(esid);
                DERInteger signType = (DERInteger)header.getObjectAt(1);
                String ver = signType.toString();
                sealInfo.setVersion(ver);
                String sealID = ((ASN1String)header.getObjectAt(0)).getString();
                sealInfo.setSealID(sealID);
                String sealVid = ((ASN1String)header.getObjectAt(2)).getString();
                sealInfo.setSealVid(sealVid);
                ASN1Sequence property = (ASN1Sequence)esealInfo.getObjectAt(2);
                BigInteger type = ((ASN1Integer)property.getObjectAt(0)).getValue();
                sealInfo.setType(type);
                String sealName = ((ASN1String)property.getObjectAt(1)).getString();
                sealInfo.setSealName(sealName);
                if (ver.equals("4")) {
                    try {
                        date = ((ASN1GeneralizedTime)property.getObjectAt(4)).getDate();
                        sealInfo.setCreateDate(KGDateUtils.dateTime((Date)date));
                        date = ((ASN1GeneralizedTime)property.getObjectAt(5)).getDate();
                        sealInfo.setValidStart(KGDateUtils.dateTime((Date)date));
                        date = ((ASN1GeneralizedTime)property.getObjectAt(6)).getDate();
                        sealInfo.setValidEnd(KGDateUtils.dateTime((Date)date));
                    }
                    catch (ParseException e) {
                        throw new RuntimeException(e);
                    }
                    String certtype = ((DERInteger)property.getObjectAt(2)).toString();
                    sealInfo.setCerttype(certtype);
                    DLSequence certseq = (DLSequence)property.getObjectAt(3);
                    sealInfo.setCertList(certseq);
                } else {
                    date = ((ASN1UTCTime)property.getObjectAt(3)).getTime();
                    sealInfo.setCreateDate(KGDateUtils.formatUTCTime((String)date));
                    date = ((ASN1UTCTime)property.getObjectAt(4)).getTime();
                    sealInfo.setValidStart(KGDateUtils.formatUTCTime((String)date));
                    date = ((ASN1UTCTime)property.getObjectAt(5)).getTime();
                    sealInfo.setValidEnd(KGDateUtils.formatUTCTime((String)date));
                }
                sealInfo.setToSignData(((ASN1Sequence)sequence.getObjectAt(0)).getEncoded());
                byte[] signData = null;
                String signDate = "";
                byte[] certData = null;
                if (ver.equals("4")) {
                    signData = ((DERBitString)sequence.getObjectAt(3)).getBytes();
                    Date date2 = null;
                    try {
                        date2 = ((ASN1GeneralizedTime)toSign.getObjectAt(2)).getDate();
                    }
                    catch (ParseException e) {
                        throw new RuntimeException(e);
                    }
                    signDate = KGDateUtils.dateTime(date2);
                    certData = ((DEROctetString)sequence.getObjectAt(1)).getOctets();
                } else {
                    signData = ((DERBitString)sequence.getObjectAt(1)).getBytes();
                    String signString = new String(((DERBitString)toSign.getObjectAt(2)).getBytes());
                    Date date3 = null;
                    date3 = signString.length() == 15 ? KGDateUtils.parseUTC2Date(signString, "yyyyMMddHHmmss") : KGDateUtils.parseUTC2Date(signString, "yyMMddHHmmss");
                    signDate = KGDateUtils.dateTime(date3);
                    certData = ((DEROctetString)toSign.getObjectAt(5)).getOctets();
                }
                sealInfo.setSignData(signData);
                sealInfo.setSignDate(signDate);
                sealInfo.setCert(certData);
                byte[] hash = ((DERBitString)toSign.getObjectAt(3)).getBytes();
                sealInfo.setHash(hash);
                if (ver.equals("4") && (num = sequence.size()) == 5) {
                    DERBitString timeData = null;
                    timeData = (DERBitString)sequence.getObjectAt(4);
                    sealInfo.setTimeStamp(this.getTimeStamp(sequence));
                    if (timeData != null) {
                        sealInfo.setTimeData(timeData.getBytes());
                    }
                }
                X509CertificateStructure certificateStructure = X509CertificateStructure.getInstance((Object)ASN1Sequence.getInstance((Object)certData));
                TBSCertificateStructure tbsCertificateStructure = certificateStructure.getTBSCertificate();
                String userName = tbsCertificateStructure.getIssuer().toString();
                userName = userName.substring(userName.indexOf("=") + 1, userName.indexOf(","));
                sealInfo.setUserName(userName);
                SignInfo signInfo = new SignInfo(sealInfo, certificateStructure);
                this.signInfos.add(signInfo);
            }
            ++i;
        }
    }

    public String getTimeStamp(ASN1Sequence sequence) {
        DERBitString timeseq = (DERBitString)sequence.getObjectAt(4);
        byte[] data = timeseq.getBytes();
        ASN1Sequence sequencetime = null;
        ASN1InputStream asn1In = null;
        DERTaggedObject taggedObject = null;
        String timestamp = "";
        try {
            asn1In = new ASN1InputStream(data);
            sequencetime = (ASN1Sequence)asn1In.readObject();
            sequencetime = (ASN1Sequence)sequencetime.getObjectAt(1);
            taggedObject = (DERTaggedObject)sequencetime.getObjectAt(1);
            sequencetime = ASN1Sequence.getInstance((ASN1TaggedObject)taggedObject, (boolean)false);
            sequencetime = (ASN1Sequence)sequencetime.getObjectAt(0);
            sequencetime = (ASN1Sequence)sequencetime.getObjectAt(2);
            taggedObject = (DERTaggedObject)sequencetime.getObjectAt(1);
            ASN1OctetString oct = ASN1OctetString.getInstance((ASN1TaggedObject)taggedObject, (boolean)false);
            data = oct.getOctets();
            asn1In = new ASN1InputStream(data);
            sequencetime = (ASN1Sequence)asn1In.readObject();
            ASN1GeneralizedTime time = (ASN1GeneralizedTime)sequencetime.getObjectAt(4);
            timestamp = time.getTimeString();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return timestamp;
    }

    public ZipFile getZipFile() {
        return this.zipFile;
    }

    public List<SignInfo> getSignInfos() {
        return this.signInfos;
    }
}

