/*
 * Decompiled with CFR 0.152.
 */
package com.kgofd.ofd.executes;

import com.kgofd.ofd.utils.FileUtil;
import com.sun.imageio.plugins.bmp.BMPImageReader;
import com.sun.imageio.plugins.gif.GIFImageReader;
import com.sun.imageio.plugins.jpeg.JPEGImageReader;
import com.sun.imageio.plugins.png.PNGImageReader;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.FileImageOutputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.model.ZipParameters;
import org.apache.sanselan.ImageInfo;
import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.Sanselan;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class OfdImageToOfd {
    private List<String> imageurl;
    private List<byte[]> imagebyte;
    private List<Integer> dpilist;
    private String url;
    private String filename;
    private int maxID = 1;

    public List<byte[]> getImagebyte() {
        return this.imagebyte;
    }

    public void setImagebyte(List<byte[]> imagebyte) {
        this.imagebyte = imagebyte;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public List<String> getImageurl() {
        return this.imageurl;
    }

    public void setImageurl(List<String> imageurl) {
        this.imageurl = imageurl;
    }

    public List<Integer> getDpilist() {
        return this.dpilist;
    }

    public void setDpilist(List<Integer> dpilist) {
        this.dpilist = dpilist;
    }

    public void createOfd() throws IOException, ZipException, ImageReadException {
        if (this.getImageurl().size() == 0) {
            throw new RuntimeException();
        }
        this.createStructure();
        this.getOfdFile();
        FileUtil.deleteFolder(String.valueOf(this.getUrl()) + "/" + this.getFilename());
    }

    private void createStructure() throws IOException, ImageReadException {
        File file = new File(String.valueOf(this.getUrl()) + "/" + this.getFilename() + "/Doc_0/Res");
        file.mkdirs();
        this.createOfdxml();
        this.loadimage();
        int i = 0;
        while (i < this.imagebyte.size()) {
            byte[] image = this.imagebyte.get(i);
            String format = this.getImageType(image);
            String img = "image_" + i + "." + format;
            this.byte2image(image, String.valueOf(this.getUrl()) + "/" + this.getFilename() + "/Doc_0/Res/" + img);
            file = new File(String.valueOf(this.getUrl()) + "/" + this.getFilename() + "/Doc_0/Pages/Page_" + i);
            file.mkdirs();
            ++i;
        }
        this.createDoucumentResxml();
        this.createContentxml();
        this.createDoucument();
    }

    private void loadimage() throws IOException, ImageReadException {
        ByteArrayOutputStream outStream = null;
        ArrayList<byte[]> list = new ArrayList<byte[]>();
        ArrayList<Integer> listdpi = new ArrayList<Integer>();
        int i = 0;
        while (i < this.imageurl.size()) {
            int dpi;
            String format = this.imageurl.get(i).substring(this.imageurl.get(i).length() - 3, this.imageurl.get(i).length());
            BufferedImage image = ImageIO.read(new File(this.imageurl.get(i)));
            outStream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)image, format, outStream);
            byte[] bs = outStream.toByteArray();
            list.add(bs);
            File picture = new File(this.imageurl.get(i));
            ImageInfo imageInfo = Sanselan.getImageInfo((File)picture);
            int n = dpi = imageInfo.getPhysicalHeightDpi() == -1 ? 96 : imageInfo.getPhysicalHeightDpi();
            if (format.equals("bmp")) {
                dpi = 96;
            }
            listdpi.add(dpi);
            ++i;
        }
        outStream.close();
        this.setImagebyte(list);
        this.setDpilist(listdpi);
    }

    private void createDoucument() {
        try {
            File file = new File(String.valueOf(this.getUrl()) + "/" + this.getFilename() + "/Doc_0/Document.xml");
            Document doc = DocumentHelper.createDocument();
            Element root = doc.addElement("ofd:Document");
            root.addNamespace("ofd", "http://www.ofdspec.org");
            Element pages = root.addElement("ofd:Pages");
            int i = 0;
            while (i < this.imagebyte.size()) {
                pages.addElement("ofd:Page").addAttribute("ID", String.valueOf(this.maxID)).addAttribute("BaseLoc", "Pages/Page_" + i + "/Content.xml");
                ++this.maxID;
                ++i;
            }
            Element commonData = root.addElement("ofd:CommonData");
            commonData.addElement("ofd:DocumentRes").addText("DocumentRes.xml");
            commonData.addElement("ofd:MaxUnitID").addText(String.valueOf(this.maxID));
            Element pageArea = commonData.addElement("ofd:PageArea");
            pageArea.addElement("ofd:PhysicalBox").addText("0 0 210 297");
            OutputFormat format = new OutputFormat();
            format.setIndentSize(2);
            format.setNewlines(true);
            format.setTrimText(true);
            format.setPadText(true);
            format.setNewLineAfterDeclaration(true);
            FileOutputStream outputStream = new FileOutputStream(file);
            XMLWriter writer = new XMLWriter((OutputStream)outputStream, format);
            writer.write(doc);
            outputStream.flush();
            outputStream.close();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void createContentxml() {
        List<File> list = FileUtil.getFileSort(String.valueOf(this.getUrl()) + "/" + this.getFilename() + "/Doc_0/Res");
        int i = 0;
        while (i < list.size()) {
            try {
                File filedoc = new File(String.valueOf(this.getUrl()) + "/" + this.getFilename() + "/Doc_0/Pages/Page_" + i + "/Content.xml");
                File picture = new File(String.valueOf(this.getUrl()) + "/" + this.getFilename() + "/Doc_0/Res/" + list.get(i).getName());
                int dpi = this.dpilist.get(i);
                int width = 0;
                int height = 0;
                if (list.get(i).getName().indexOf(".bmp") > 0) {
                    BufferedImage image = ImageIO.read(picture);
                    width = (int)((double)((float)image.getWidth() / (float)dpi) * 25.4);
                    height = (int)((double)((float)image.getHeight() / (float)dpi) * 25.4);
                } else {
                    ImageInfo imageInfo = Sanselan.getImageInfo((File)picture);
                    width = (int)((double)((float)imageInfo.getWidth() / (float)dpi) * 25.4);
                    height = (int)((double)((float)imageInfo.getHeight() / (float)dpi) * 25.4);
                }
                String text = "0 0 " + width + " " + height;
                Document doc = DocumentHelper.createDocument();
                Element root = doc.addElement("ofd:Page");
                root.addNamespace("ofd", "http://www.ofdspec.org");
                Element area = root.addElement("ofd:Area");
                area.addElement("ofd:ApplicationBox").addText(text);
                area.addElement("ofd:ContentBox").addText(text);
                area.addElement("ofd:BleedBox").addText(text);
                area.addElement("ofd:PhysicalBox").addText(text);
                Element content = root.addElement("ofd:Content");
                Element layer = content.addElement("ofd:Layer").addAttribute("ID", String.valueOf(this.maxID)).addAttribute("Type", "Body");
                ++this.maxID;
                layer.addElement("ofd:ImageObject").addAttribute("ID", String.valueOf(this.maxID)).addAttribute("CTM", String.valueOf(width) + " 0 0 " + height + " 0 0").addAttribute("Boundary", text).addAttribute("ResourceID", String.valueOf(i + 1));
                ++this.maxID;
                OutputFormat format = new OutputFormat();
                format.setIndentSize(2);
                format.setNewlines(true);
                format.setTrimText(true);
                format.setPadText(true);
                format.setNewLineAfterDeclaration(true);
                FileOutputStream outputStream = new FileOutputStream(filedoc);
                XMLWriter writer = new XMLWriter((OutputStream)outputStream, format);
                writer.write(doc);
                outputStream.flush();
                outputStream.close();
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (ImageReadException e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    private void createDoucumentResxml() {
        try {
            File file = new File(String.valueOf(this.getUrl()) + "/" + this.getFilename() + "/Doc_0/DocumentRes.xml");
            Document doc = DocumentHelper.createDocument();
            Element root = doc.addElement("ofd:Res");
            root.addNamespace("ofd", "http://www.ofdspec.org");
            root.addAttribute("BaseLoc", "Res");
            Element MultiMedias = root.addElement("ofd:MultiMedias");
            List<File> list = FileUtil.getFileSort(String.valueOf(this.getUrl()) + "/" + this.getFilename() + "/Doc_0/Res");
            int i = 0;
            while (i < list.size()) {
                String format = list.get(i).getName().substring(list.get(i).getName().indexOf(".") + 1, list.get(i).getName().length());
                Element MultiMedia = MultiMedias.addElement("ofd:MultiMedia").addAttribute("ID", String.valueOf(this.maxID)).addAttribute("Type", "Image").addAttribute("Format", format.toUpperCase());
                MultiMedia.addElement("ofd:MediaFile").addText(list.get(i).getName());
                ++this.maxID;
                ++i;
            }
            OutputFormat format = new OutputFormat();
            format.setIndentSize(2);
            format.setNewlines(true);
            format.setTrimText(true);
            format.setPadText(true);
            format.setNewLineAfterDeclaration(true);
            FileOutputStream outputStream = new FileOutputStream(file);
            XMLWriter writer = new XMLWriter((OutputStream)outputStream, format);
            writer.write(doc);
            outputStream.flush();
            outputStream.close();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void createOfdxml() {
        try {
            File file = new File(String.valueOf(this.getUrl()) + "/" + this.getFilename() + "/OFD.xml");
            Document doc = DocumentHelper.createDocument();
            Element root = doc.addElement("ofd:OFD");
            root.addNamespace("ofd", "http://www.ofdspec.org");
            root.addAttribute("Version", "1.0");
            root.addAttribute("DocType", "OFD");
            Element docBody = root.addElement("ofd:DocBody");
            Element docInfo = docBody.addElement("ofd:DocInfo");
            docInfo.addElement("ofd:Creator").addText("Kinggrid");
            docInfo.addElement("ofd:DocID").addText(UUID.randomUUID().toString().replace("-", ""));
            docBody.addElement("ofd:DocRoot").addText("Doc_0/Document.xml");
            OutputFormat format = new OutputFormat();
            format.setIndentSize(2);
            format.setNewlines(true);
            format.setTrimText(true);
            format.setPadText(true);
            format.setNewLineAfterDeclaration(true);
            FileOutputStream outputStream = new FileOutputStream(file);
            XMLWriter writer = new XMLWriter((OutputStream)outputStream, format);
            writer.write(doc);
            outputStream.flush();
            outputStream.close();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void getOfdFile() throws ZipException {
        File[] list;
        ZipFile zipFile = new ZipFile(String.valueOf(this.getUrl()) + "/" + this.getFilename() + ".ofd");
        ZipParameters parameters = new ZipParameters();
        parameters.setCompressionMethod(8);
        parameters.setCompressionLevel(5);
        File currentFile = new File(String.valueOf(this.getUrl()) + "/" + this.getFilename());
        File[] fileArray = list = currentFile.listFiles();
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.isDirectory()) {
                zipFile.addFolder(f.getPath(), parameters);
            } else {
                zipFile.addFile(f, parameters);
            }
            ++n2;
        }
    }

    private String getImageType(byte[] bs) throws IOException {
        String type = "";
        ByteArrayInputStream bais = null;
        MemoryCacheImageInputStream mcis = null;
        try {
            bais = new ByteArrayInputStream(bs);
            mcis = new MemoryCacheImageInputStream(bais);
            Iterator<ImageReader> itr = ImageIO.getImageReaders(mcis);
            while (itr.hasNext()) {
                ImageReader reader = itr.next();
                if (reader instanceof GIFImageReader) {
                    type = "gif";
                    continue;
                }
                if (reader instanceof JPEGImageReader) {
                    type = "jpg";
                    continue;
                }
                if (reader instanceof PNGImageReader) {
                    type = "png";
                    continue;
                }
                if (!(reader instanceof BMPImageReader)) continue;
                type = "bmp";
            }
        }
        finally {
            if (bais != null) {
                try {
                    bais.close();
                }
                catch (IOException iOException) {}
            }
            if (mcis != null) {
                try {
                    mcis.close();
                }
                catch (IOException iOException) {}
            }
        }
        return type;
    }

    public void byte2image(byte[] data, String path) {
        if (data.length < 3 || path.equals("")) {
            return;
        }
        try {
            FileImageOutputStream imageOutput = new FileImageOutputStream(new File(path));
            imageOutput.write(data, 0, data.length);
            imageOutput.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

