/*
 * Decompiled with CFR 0.152.
 */
package com.kgofd.ofd.executes;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kgofd.commons.KGCommonUtils;
import com.kgofd.encrypt.KGBase64;
import com.kgofd.ofd.KGExecute;
import com.kgofd.ofd.utils.KGOfdUtils;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.util.List;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.io.ZipInputStream;
import net.lingala.zip4j.model.FileHeader;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.kg.bouncycastle.asn1.ASN1InputStream;

public class OfdGBSignDetails
extends KGExecute {
    private JSONArray signInfos = new JSONArray();

    @Override
    protected void execute(int[] pagens, ZipFile zipFile) throws DocumentException, IOException, ZipException {
        KGBase64 base64 = new KGBase64();
        Document ofdDocument = KGOfdUtils.getDocument(zipFile, "OFD.xml");
        Element signaturesEle = (Element)ofdDocument.selectSingleNode("/ofd:OFD/ofd:DocBody/ofd:Signatures");
        if (signaturesEle == null) {
            throw new RuntimeException("\u8be5\u6587\u6863\u4e2d\u6ca1\u6709\u7b7e\u7ae0");
        }
        String signaturesPath = signaturesEle.getTextTrim();
        if (!signaturesPath.startsWith("/") && !signaturesPath.startsWith("Doc_0")) {
            signaturesPath = "Doc_0/" + signaturesPath;
        } else if (signaturesPath.startsWith("/")) {
            signaturesPath = signaturesPath.substring(1, signaturesPath.length());
        }
        Document signaturesDoc = KGOfdUtils.getDocument(zipFile, signaturesPath);
        List signatureEles = signaturesDoc.selectNodes("/ofd:Signatures/ofd:Signature");
        int i = 0;
        while (i < signatureEles.size()) {
            MessageDigest messageDigest;
            JSONObject object = new JSONObject();
            Element ele = (Element)signatureEles.get(i);
            String signaturePath = ele.attribute("BaseLoc").getValue();
            signaturePath = KGCommonUtils.converPath(signaturePath, signaturesPath);
            String signPath = signaturePath.substring(0, signaturePath.lastIndexOf("/"));
            FileHeader fileHeader = null;
            ASN1InputStream datAis = null;
            try {
                fileHeader = zipFile.getFileHeader(String.valueOf(signPath) + "/SignedValue.dat");
                datAis = new ASN1InputStream((InputStream)zipFile.getInputStream(fileHeader));
                object.put("datData", (Object)base64.encode(datAis.readObject().getEncoded()));
            }
            finally {
                if (datAis != null) {
                    datAis.close();
                }
            }
            FileHeader header = zipFile.getFileHeader(String.valueOf(signPath) + "/Signature.xml");
            ZipInputStream zis = zipFile.getInputStream(header);
            try {
                try {
                    messageDigest = MessageDigest.getInstance("SM3", "KGBC");
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                int len = -1;
                byte[] buff = new byte[4096];
                while ((len = zis.read(buff)) != -1) {
                    messageDigest.update(buff, 0, len);
                }
                byte[] hash = messageDigest.digest();
                object.put("xmlHash", (Object)base64.encode(hash));
            }
            finally {
                if (zis != null) {
                    zis.close();
                }
            }
            Document signatureDocument = KGOfdUtils.getDocument(zipFile, String.valueOf(signPath) + "/Signature.xml");
            String path = zipFile.getFileHeader(String.valueOf(signPath) + "/Signature.xml").getFileName();
            List referenceNodes = signatureDocument.selectNodes("/ofd:Signature/ofd:SignedInfo/ofd:References/ofd:Reference");
            boolean res = true;
            int j = 0;
            while (j < referenceNodes.size()) {
                Element referenceEle = (Element)referenceNodes.get(j);
                String fileRef = referenceEle.attributeValue("FileRef");
                fileRef = KGCommonUtils.converPath(fileRef, path);
                fileHeader = zipFile.getFileHeader(fileRef);
                zis = zipFile.getInputStream(fileHeader);
                String code = null;
                try {
                    try {
                        messageDigest = MessageDigest.getInstance("SM3", "KGBC");
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    int len = -1;
                    byte[] buff = new byte[4096];
                    while ((len = zis.read(buff)) != -1) {
                        messageDigest.update(buff, 0, len);
                    }
                    byte[] hash = messageDigest.digest();
                    code = base64.encode(hash);
                }
                finally {
                    if (zis != null) {
                        zis.close();
                    }
                }
                String checkValue = referenceEle.element("CheckValue").getTextTrim();
                if (!code.equals(checkValue)) {
                    res = false;
                    break;
                }
                ++j;
            }
            object.put("result", (Object)res);
            this.signInfos.add((Object)object);
            ++i;
        }
    }

    public JSONArray getSignInfos() {
        return this.signInfos;
    }
}

