/*
 * Decompiled with CFR 0.152.
 */
package com.kgofd.ofd.executes;

import com.kgofd.encrypt.KGBase64;
import com.kgofd.ofd.core.BuildSealData;
import com.kgofd.ofd.enmu.KGHashType;
import com.kgofd.ofd.executes.OfdElectronicSeal;
import com.kgofd.ofd.signinter.SignatureInterByServer;
import com.kgofd.ofd.utils.ServerSignUtil;
import java.io.IOException;
import java.util.Date;
import org.kg.bouncycastle.asn1.DERUTCTime;

public class OfdElectronicSeal4Image
extends OfdElectronicSeal {
    private byte[] imgData;
    private String imgType;
    private float width;
    private float height;
    private String url;
    private String keySN;
    private String signName = "\u81ea\u751f\u6210\u5370\u7ae0";
    private long sealPeriod = 5L;

    public OfdElectronicSeal4Image(byte[] imgData, String imgType, float width, float height) {
        this.imgData = imgData;
        this.imgType = imgType;
        this.width = width;
        this.height = height;
    }

    public void setSealPeriod(long sealPeriod) {
        this.sealPeriod = sealPeriod;
    }

    public void setSignName(String signName) {
        this.signName = signName;
    }

    public void setISignatureInfo(String url, String keySN) {
        this.url = url;
        this.keySN = keySN;
    }

    @Override
    protected void before() throws IOException {
        String currentTime = new DERUTCTime(new Date()).toString();
        byte[] cert = null;
        if (this.keySN != null && !"".equals(this.keySN)) {
            String certBase64 = ServerSignUtil.getCertFromISignatureServer(this.url, this.keySN);
            KGBase64 base64 = new KGBase64();
            cert = base64.decode(certBase64);
        }
        BuildSealData buildSealData = new BuildSealData(this.signName, cert, this.imgType, this.imgData, Float.valueOf(this.width), Float.valueOf(this.height), currentTime, currentTime, this.sealPeriod);
        byte[] toSignData = buildSealData.getToSignData();
        byte[] signValue = buildSealData.getSignData(toSignData, this.url, null, this.keySN, KGHashType.HASH_TYPE_SM3);
        byte[] sealData = buildSealData.getSealData(toSignData, signValue);
        this.setSealMsg(sealData);
        this.setSealSize(this.width, this.height);
        if (cert == null) {
            this.getInter().getCer();
        } else if (this.getInter() instanceof SignatureInterByServer) {
            ((SignatureInterByServer)this.getInter()).setCer(cert);
        }
    }
}

