/*
 * Decompiled with CFR 0.152.
 */
package com.kgofd.ofd.executes;

import com.alibaba.fastjson.JSONObject;
import com.kgofd.encrypt.KGBase64;
import com.kgofd.ofd.core.VerifyBeforeSign;
import com.kgofd.ofd.executes.OfdElectronicSeal;
import com.kgofd.ofd.utils.ConnectStampSystemUtil;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import org.kg.bouncycastle.asn1.ASN1InputStream;
import org.kg.bouncycastle.asn1.ASN1Integer;
import org.kg.bouncycastle.asn1.ASN1Sequence;

public class OfdElectronicSeal4GB
extends OfdElectronicSeal {
    private String url;
    private String salt;
    private String appid;
    private String esid;

    public OfdElectronicSeal4GB(String url, String salt, String appid, String esid) {
        this.url = url;
        this.salt = salt;
        this.appid = appid;
        this.esid = esid;
    }

    @Override
    public void before() throws IOException {
        JSONObject retObj = null;
        try {
            ConnectStampSystemUtil cUtil = new ConnectStampSystemUtil(this.url, this.salt, this.appid, this.esid);
            retObj = cUtil.getSealByEsid();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        KGBase64 base64 = new KGBase64();
        byte[] sealData = base64.decode(retObj.getString("sealData"));
        this.setSealMsg(sealData);
        VerifyBeforeSign verifyBeforeSign = new VerifyBeforeSign(this.getInter());
        verifyBeforeSign.verifyCert();
        if (this.verifySeal) {
            verifyBeforeSign.verifySeal(this.getSealMsg());
        }
        ASN1InputStream asn1InputStream = new ASN1InputStream(this.getSealMsg());
        ASN1Sequence sequence = (ASN1Sequence)asn1InputStream.readObject();
        ASN1Sequence seq_0 = (ASN1Sequence)sequence.getObjectAt(0);
        ASN1Sequence seq_1 = (ASN1Sequence)seq_0.getObjectAt(3);
        float width = ((ASN1Integer)seq_1.getObjectAt(2)).getValue().floatValue();
        float height = ((ASN1Integer)seq_1.getObjectAt(3)).getValue().floatValue();
        asn1InputStream.close();
        this.setSealSize(width, height);
    }
}

