/*
 * Decompiled with CFR 0.152.
 */
package com.kgofd.ofd.core;

import com.kgofd.commons.KGDateUtils;
import com.kgofd.encrypt.SM2;
import com.kgofd.exception.KGVerifyException;
import com.kgofd.ofd.signinter.SignatureInter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.kg.bouncycastle.asn1.ASN1Encodable;
import org.kg.bouncycastle.asn1.ASN1EncodableVector;
import org.kg.bouncycastle.asn1.ASN1GeneralizedTime;
import org.kg.bouncycastle.asn1.ASN1InputStream;
import org.kg.bouncycastle.asn1.ASN1Integer;
import org.kg.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.kg.bouncycastle.asn1.ASN1Sequence;
import org.kg.bouncycastle.asn1.ASN1UTCTime;
import org.kg.bouncycastle.asn1.DERBitString;
import org.kg.bouncycastle.asn1.DEROctetString;
import org.kg.bouncycastle.asn1.DERSequence;
import org.kg.bouncycastle.asn1.x509.X509CertificateStructure;
import org.kg.bouncycastle.jce.provider.BouncyCastleProvider;

public class VerifyBeforeSign {
    private SignatureInter inter;
    private boolean Sm2 = true;
    private int version;

    public VerifyBeforeSign(SignatureInter inter) {
        this.inter = inter;
    }

    public void verifyCert() throws IOException {
        X509CertificateStructure certificateStructure = this.inter.getCer();
        if (certificateStructure != null) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyMMddHHmmss");
            long date = Long.parseLong(sdf.format(new Date()));
            long startDate = Long.parseLong(certificateStructure.getStartDate().getTime().substring(2, 14));
            long endDate = Long.parseLong(certificateStructure.getEndDate().getTime().substring(2, 14));
            if (startDate > date || endDate < date) {
                throw new RuntimeException("\u9a8c\u8bc1\u7b7e\u7ae0\u4eba\u8bc1\u4e66\u6709\u6548\u671f\u5931\u8d25\uff01");
            }
        }
    }

    public void verifySeal(byte[] sealData) throws IOException {
        ASN1Sequence signInfo = null;
        ASN1ObjectIdentifier algorithm = null;
        DEROctetString certString = null;
        DERBitString signDataString = null;
        byte[] toSignData = null;
        ASN1Sequence sequence = ASN1Sequence.getInstance((Object)sealData);
        ASN1Sequence esealInfoSequence = (ASN1Sequence)sequence.getObjectAt(0);
        ASN1Sequence headerSequence = (ASN1Sequence)esealInfoSequence.getObjectAt(0);
        ASN1Integer versionAsn1Integer = (ASN1Integer)headerSequence.getObjectAt(1);
        this.version = versionAsn1Integer.getValue().intValue();
        if (this.version == 4) {
            algorithm = (ASN1ObjectIdentifier)sequence.getObjectAt(2);
            certString = (DEROctetString)sequence.getObjectAt(1);
            signDataString = (DERBitString)sequence.getObjectAt(3);
            toSignData = esealInfoSequence.getEncoded();
        } else {
            signInfo = (ASN1Sequence)sequence.getObjectAt(1);
            algorithm = (ASN1ObjectIdentifier)signInfo.getObjectAt(1);
            certString = (DEROctetString)signInfo.getObjectAt(0);
            signDataString = (DERBitString)signInfo.getObjectAt(2);
            ASN1EncodableVector toSign = new ASN1EncodableVector();
            toSign.add((ASN1Encodable)esealInfoSequence);
            toSign.add((ASN1Encodable)certString);
            toSign.add((ASN1Encodable)algorithm);
            DERSequence toSignSequence = new DERSequence(toSign);
            toSignData = toSignSequence.getEncoded();
        }
        this.Sm2 = "1.2.156.10197.1.301".equals(algorithm.getId()) || "1.2.156.10197.1.501".equals(algorithm.getId());
        byte[] certByte = certString.getOctets();
        ASN1InputStream certStream = new ASN1InputStream(certByte);
        X509CertificateStructure cert = new X509CertificateStructure((ASN1Sequence)certStream.readObject());
        byte[] signData = signDataString.getBytes();
        this.checkSigndata(cert, toSignData, signData, certByte);
        this.checkSealTime(esealInfoSequence);
    }

    public void checkSigndata(X509CertificateStructure cert, byte[] toSignData, byte[] signData, byte[] certByte) throws IOException {
        if (signData.length != 64) {
            signData = this.sigDataAns1To64bit(signData);
        }
        boolean result = false;
        if (this.Sm2) {
            byte[] byPuk = cert.getSubjectPublicKeyInfo().getPublicKeyData().getBytes();
            byte[] pk = new byte[64];
            System.arraycopy(byPuk, 1, pk, 0, 64);
            SM2 sm2 = new SM2(true);
            result = sm2.Verify(toSignData, signData, pk);
        } else {
            try {
                CertificateFactory factory = CertificateFactory.getInstance("X.509");
                X509Certificate certificate = (X509Certificate)factory.generateCertificate(new ByteArrayInputStream(certByte));
                PublicKey publicKey = certificate.getPublicKey();
                Signature signature = Signature.getInstance("SHA1withRSA", (Provider)new BouncyCastleProvider());
                signature.initVerify(publicKey);
                signature.update(toSignData);
                result = signature.verify(signData);
            }
            catch (InvalidKeyException e) {
                throw new RuntimeException(e);
            }
            catch (GeneralSecurityException e) {
                throw new RuntimeException(e);
            }
        }
        if (!result) {
            throw new KGVerifyException("\u9a8c\u8bc1\u7535\u5b50\u5370\u7ae0\u5931\u8d25\uff1a\u9a8c\u8bc1\u7535\u5b50\u5370\u7ae0\u7b7e\u540d\u503c\u5931\u8d25\uff01");
        }
    }

    public void checkCert(X509CertificateStructure cert) {
        long startDate = Long.parseLong(cert.getStartDate().getTime().substring(2, 14));
        long endDate = Long.parseLong(cert.getEndDate().getTime().substring(2, 14));
        SimpleDateFormat sdf = new SimpleDateFormat("yyMMddHHmmdd");
        long date = Long.parseLong(sdf.format(new Date()));
        if (startDate > date || endDate < date) {
            throw new KGVerifyException("\u9a8c\u8bc1\u7535\u5b50\u5370\u7ae0\u5931\u8d25\uff1a\u9a8c\u8bc1\u7535\u5b50\u5370\u7ae0\u5236\u7ae0\u4eba\u8bc1\u4e66\u6709\u6548\u671f\u5931\u8d25\uff01");
        }
    }

    public void checkSealTime(ASN1Sequence esealInfoSequence) {
        boolean effectivity = false;
        Date startDate = null;
        Date endDate = null;
        ASN1Sequence propertySequence = (ASN1Sequence)esealInfoSequence.getObjectAt(2);
        if (this.version == 4) {
            try {
                startDate = ((ASN1GeneralizedTime)propertySequence.getObjectAt(5)).getDate();
                endDate = ((ASN1GeneralizedTime)propertySequence.getObjectAt(6)).getDate();
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        } else {
            String validStart = ((ASN1UTCTime)propertySequence.getObjectAt(4)).getTime();
            String validEnd = ((ASN1UTCTime)propertySequence.getObjectAt(5)).getTime();
            startDate = KGDateUtils.parseUTCTime(validStart);
            endDate = KGDateUtils.parseUTCTime(validEnd);
        }
        Calendar calendar = Calendar.getInstance();
        Date nowDate = calendar.getTime();
        if (startDate.before(nowDate) && endDate.after(nowDate)) {
            effectivity = true;
        }
        if (!effectivity) {
            throw new KGVerifyException("\u9a8c\u8bc1\u7535\u5b50\u5370\u7ae0\u5931\u8d25\uff1a\u9a8c\u8bc1\u7535\u5b50\u5370\u7ae0\u7684\u6709\u6548\u671f\u5931\u8d25\uff01");
        }
    }

    public byte[] sigDataAns1To64bit(byte[] signData) throws IOException {
        ASN1Sequence sequense = ASN1Sequence.getInstance((Object)signData);
        ASN1Integer ans1Int0 = (ASN1Integer)sequense.getObjectAt(0);
        ASN1Integer ans1Int1 = (ASN1Integer)sequense.getObjectAt(1);
        byte[] sig1 = ans1Int0.getValue().toByteArray();
        byte[] sig2 = ans1Int1.getValue().toByteArray();
        byte[] buff = new byte[64];
        int srcPos = sig1.length == 32 ? 0 : 1;
        System.arraycopy(sig1, srcPos, buff, 0, 32);
        srcPos = sig2.length == 32 ? 0 : 1;
        System.arraycopy(sig2, srcPos, buff, 32, 32);
        return buff;
    }
}

