/*
 * Decompiled with CFR 0.152.
 */
package com.kgofd.ofd.core;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.kg.bouncycastle.asn1.ASN1Encodable;
import org.kg.bouncycastle.asn1.ASN1EncodableVector;
import org.kg.bouncycastle.asn1.ASN1InputStream;
import org.kg.bouncycastle.asn1.ASN1Sequence;
import org.kg.bouncycastle.asn1.DERBitString;
import org.kg.bouncycastle.asn1.DERGeneralizedTime;
import org.kg.bouncycastle.asn1.DERIA5String;
import org.kg.bouncycastle.asn1.DERInteger;
import org.kg.bouncycastle.asn1.DERObjectIdentifier;
import org.kg.bouncycastle.asn1.DEROctetString;
import org.kg.bouncycastle.asn1.DERSequence;

public class TbsSign {
    public static final String DATE_FORMAT = "yyyyMMddHHmmss";
    private static final String GM_SIGNATURE_ALGORITHM = "1.2.156.10197.1.501";
    public static final Integer GB_VERSION = 4;
    public static final Integer GM_VERSION = 2;
    private Integer version;
    private byte[] eseal;
    private String timeInfo;
    private byte[] dataHash;
    private String propertyInfo;
    private byte[] cert;

    public TbsSign(Integer version, byte[] eseal, byte[] dataHash, String propertyInfo) {
        String date = TbsSign.format(DATE_FORMAT);
        this.version = version;
        this.eseal = eseal;
        this.timeInfo = String.valueOf(date) + "Z";
        this.dataHash = dataHash;
        this.propertyInfo = propertyInfo;
    }

    public TbsSign(Integer version, byte[] eseal, byte[] dataHash, String propertyInfo, byte[] cert) {
        String date = TbsSign.format(DATE_FORMAT);
        this.version = version;
        this.eseal = eseal;
        this.timeInfo = String.valueOf(date) + "Z";
        this.dataHash = dataHash;
        this.propertyInfo = propertyInfo;
        this.cert = cert;
    }

    public byte[] buildGbASN1() {
        DERSequence sequence = this.buildGbASN1Sequence();
        try {
            return sequence.getEncoded();
        }
        catch (Exception e) {
            throw new RuntimeException("\u7ec4\u88c5\u56fd\u529e\u5f85\u7535\u5b50\u7b7e\u7ae0\u6570\u636e\u9519\u8bef");
        }
    }

    public DERSequence buildGbASN1Sequence() {
        ASN1EncodableVector toSign = new ASN1EncodableVector();
        try {
            toSign.add((ASN1Encodable)new DERInteger((long)this.version.intValue()));
            ASN1InputStream inputStream = new ASN1InputStream(this.eseal);
            toSign.add((ASN1Encodable)inputStream.readObject());
            inputStream.close();
            toSign.add((ASN1Encodable)new DERGeneralizedTime(this.timeInfo));
            toSign.add((ASN1Encodable)new DERBitString(this.dataHash));
            toSign.add((ASN1Encodable)new DERIA5String(this.propertyInfo));
            DERSequence sequence = new DERSequence(toSign);
            return sequence;
        }
        catch (Exception e) {
            throw new RuntimeException("\u7ec4\u88c5\u56fd\u529e\u5f85\u7535\u5b50\u7b7e\u7ae0\u6570\u636e\u9519\u8bef");
        }
    }

    public byte[] buildGmASN1() {
        DERSequence sequence = this.buildGmASN1Sequence();
        try {
            return sequence.getEncoded();
        }
        catch (Exception e) {
            throw new RuntimeException("\u7ec4\u88c5\u56fd\u5bc6\u5f85\u7535\u5b50\u7b7e\u7ae0\u6570\u636e\u9519\u8bef");
        }
    }

    public DERSequence buildGmASN1Sequence() {
        ASN1EncodableVector toSign = new ASN1EncodableVector();
        try {
            toSign.add((ASN1Encodable)new DERInteger((long)this.version.intValue()));
            ASN1Sequence sequence = DERSequence.getInstance((Object)this.eseal);
            toSign.add((ASN1Encodable)sequence);
            byte[] time = this.timeInfo.getBytes();
            toSign.add((ASN1Encodable)new DERBitString(time, 0));
            toSign.add((ASN1Encodable)new DERBitString(this.dataHash, 0));
            toSign.add((ASN1Encodable)new DERIA5String(this.propertyInfo));
            toSign.add((ASN1Encodable)new DEROctetString(this.cert));
            toSign.add((ASN1Encodable)new DERObjectIdentifier(GM_SIGNATURE_ALGORITHM));
            DERSequence toSignSequence = new DERSequence(toSign);
            return toSignSequence;
        }
        catch (Exception e) {
            throw new RuntimeException("\u7ec4\u88c5\u56fd\u5bc6\u5f85\u7535\u5b50\u7b7e\u7ae0\u6570\u636e\u9519\u8bef");
        }
    }

    public static String format(String pattern) {
        Date date = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);
        String time = dateFormat.format(date);
        return time;
    }

    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public byte[] getEseal() {
        return this.eseal;
    }

    public void setEseal(byte[] eseal) {
        this.eseal = eseal;
    }

    public String getTimeInfo() {
        return this.timeInfo;
    }

    public void setTimeInfo(String timeInfo) {
        this.timeInfo = timeInfo;
    }

    public byte[] getDataHash() {
        return this.dataHash;
    }

    public void setDataHash(byte[] dataHash) {
        this.dataHash = dataHash;
    }

    public String getPropertyInfo() {
        return this.propertyInfo;
    }

    public void setPropertyInfo(String propertyInfo) {
        this.propertyInfo = propertyInfo;
    }

    public byte[] getCert() {
        return this.cert;
    }

    public void setCert(byte[] cert) {
        this.cert = cert;
    }
}

