/*
 * Decompiled with CFR 0.152.
 */
package com.kgofd.ofd.core;

import com.kgofd.commons.KGCommonUtils;
import com.kgofd.ofd.core.TextCodeInfo;
import com.kgofd.ofd.core.TextObjectInfo;
import com.kgofd.ofd.executes.entity.Position;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;

public class KGTextFinder {
    private static Document contentDoc;
    private List<TextObjectInfo> textObjectInfos = new ArrayList<TextObjectInfo>();
    private List<Position> positions = new ArrayList<Position>();
    private StringBuilder pageStr = new StringBuilder();
    private int width;
    private int height;

    public KGTextFinder(Document contentDoc) {
        KGTextFinder.contentDoc = contentDoc;
    }

    public void setSeal(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public void parseContentDoc() {
        List textObjects = contentDoc.selectNodes("/ofd:Page/ofd:Content/ofd:Layer/ofd:TextObject");
        for (Element textObject : textObjects) {
            String ctm;
            TextObjectInfo textObjectInfo = new TextObjectInfo();
            textObjectInfo.setID(Integer.parseInt(textObject.attributeValue("ID")));
            String boundary = textObject.attributeValue("Boundary");
            if (boundary != null) {
                String[] s = boundary.split(" ");
                textObjectInfo.setBounX(Float.parseFloat(s[0]));
                textObjectInfo.setBounY(Float.parseFloat(s[1]));
                textObjectInfo.setBounW(Float.parseFloat(s[2]));
                textObjectInfo.setBounH(Float.parseFloat(s[3]));
            }
            if (textObject.attributeValue("HScale") != null) {
                textObjectInfo.sethScale(Float.parseFloat(textObject.attributeValue("HScale")));
            }
            if ((ctm = textObject.attributeValue("CTM")) != null) {
                String[] s = ctm.split(" ");
                textObjectInfo.setCtma(Float.parseFloat(s[0]));
                textObjectInfo.setCtmd(Float.parseFloat(s[3]));
                textObjectInfo.setCtme(Float.parseFloat(s[4]));
                textObjectInfo.setCtmf(Float.parseFloat(s[5]));
            }
            textObjectInfo.setSize(Float.parseFloat(textObject.attributeValue("Size")));
            textObjectInfo.setTextW(textObjectInfo.getSize() * textObjectInfo.gethScale() * textObjectInfo.getCtma());
            textObjectInfo.setTextH(textObjectInfo.getSize() * textObjectInfo.getCtmd());
            textObjectInfo.setPageIndexStart(this.pageStr.length());
            List textCodes = textObject.elements("TextCode");
            StringBuilder text = new StringBuilder();
            ArrayList<Float> posX = new ArrayList<Float>();
            ArrayList<Float> posY = new ArrayList<Float>();
            ArrayList<TextCodeInfo> textCodeInfos = new ArrayList<TextCodeInfo>();
            float preX = 0.0f;
            float preY = 0.0f;
            for (Element textCode : textCodes) {
                if ("".equals(textCode.getText())) continue;
                TextCodeInfo textCodeInfo = new TextCodeInfo();
                String codeText = textCode.getTextTrim();
                textCodeInfo.setCodeText(codeText);
                if (textCode.attributeValue("X") != null) {
                    textCodeInfo.setX(Float.parseFloat(textCode.attributeValue("X")) * textObjectInfo.getCtma());
                    preX = Float.parseFloat(textCode.attributeValue("X"));
                } else {
                    textCodeInfo.setX(preX);
                }
                if (textCode.attributeValue("Y") != null) {
                    textCodeInfo.setY(Float.parseFloat(textCode.attributeValue("Y")) * textObjectInfo.getCtmd());
                    preY = Float.parseFloat(textCode.attributeValue("Y"));
                } else {
                    textCodeInfo.setY(preY);
                }
                String deltaXValue = textCode.attributeValue("DeltaX");
                if (deltaXValue != null && !"".equals(deltaXValue)) {
                    String[] s = deltaXValue.split(" ");
                    float[] f = KGCommonUtils.StringToFloat(s, codeText, textObjectInfo.getCtma());
                    textCodeInfo.setDeltaX(f);
                    float startx = textCodeInfo.getX() + textObjectInfo.getBounX() + textObjectInfo.getCtme();
                    posX.add(Float.valueOf(startx));
                    float nextx = startx;
                    int i = 0;
                    while (i < textCodeInfo.getDeltaX().length) {
                        posX.add(Float.valueOf(nextx + textCodeInfo.getDeltaX()[i]));
                        nextx += textCodeInfo.getDeltaX()[i];
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < codeText.length()) {
                        posX.add(Float.valueOf(textCodeInfo.getX() + textObjectInfo.getBounX() + textObjectInfo.getCtme()));
                        ++i;
                    }
                }
                String deltaYValue = textCode.attributeValue("DeltaY");
                if ((deltaXValue == null || "".equals(deltaXValue)) && (deltaYValue == null || "".equals(deltaYValue))) {
                    posX.add(Float.valueOf(textCodeInfo.getX() + textObjectInfo.getBounX() + textObjectInfo.getCtme()));
                    posY.add(Float.valueOf(textCodeInfo.getY() - (textObjectInfo.getTextH() * 5.0f / 6.0f + textObjectInfo.getCtmf()) + textObjectInfo.getBounY() + textObjectInfo.getCtmf()));
                }
                if (deltaYValue != null && !"".equals(deltaYValue)) {
                    String[] s = deltaYValue.split(" ");
                    float[] f = KGCommonUtils.StringToFloat(s, codeText, textObjectInfo.getCtmd());
                    textCodeInfo.setDeltaY(f);
                    float y = textCodeInfo.getY() - (textObjectInfo.getTextH() * 5.0f / 6.0f + textObjectInfo.getCtmf());
                    y = y > 0.0f ? y : 0.0f;
                    float starty = y + textObjectInfo.getBounY() + textObjectInfo.getCtmf();
                    posY.add(Float.valueOf(starty));
                    float nexty = starty;
                    int i = 0;
                    while (i < textCodeInfo.getDeltaY().length) {
                        posY.add(Float.valueOf(nexty + textCodeInfo.getDeltaY()[i]));
                        nexty += textCodeInfo.getDeltaY()[i];
                        ++i;
                    }
                } else {
                    float y = textCodeInfo.getY() - (textObjectInfo.getTextH() * 5.0f / 6.0f + textObjectInfo.getCtmf());
                    y = y > 0.0f ? y : 0.0f;
                    int i = 0;
                    while (i < codeText.length()) {
                        posY.add(Float.valueOf(y + textObjectInfo.getBounY() + textObjectInfo.getCtmf()));
                        ++i;
                    }
                }
                text.append(codeText);
                textCodeInfos.add(textCodeInfo);
            }
            this.pageStr.append((CharSequence)text);
            textObjectInfo.setText(text.toString());
            textObjectInfo.setPageIndexEnd(this.pageStr.length() - 1);
            textObjectInfo.setTextX(posX.toArray());
            textObjectInfo.setTextY(posY.toArray());
            this.textObjectInfos.add(textObjectInfo);
        }
    }

    public List<Position> TextFinder(String text, boolean textOnceFindReturn) {
        int len = text.length();
        String pageText = this.pageStr.toString();
        float sx = 0.0f;
        float sy = 0.0f;
        float ex = 0.0f;
        float ey = 0.0f;
        int i = 0;
        while ((i = pageText.indexOf(text, i)) != -1) {
            int end = i + text.length() - 1;
            Position p = new Position();
            for (TextObjectInfo info : this.textObjectInfos) {
                if (info.getPageIndexStart() <= i && info.getPageIndexEnd() >= i) {
                    int s = i - info.getPageIndexStart();
                    sx = ((Float)info.getTextX()[s]).floatValue();
                    p.setLlx(sx);
                    sy = ((Float)info.getTextY()[s]).floatValue();
                    p.setLly(sy);
                }
                if (info.getPageIndexStart() <= end && info.getPageIndexEnd() >= end) {
                    char lastText = pageText.charAt(end);
                    boolean isChinese = KGCommonUtils.isChinese(lastText);
                    int s = end - info.getPageIndexStart() - 1;
                    if (!isChinese) {
                        ex = ((Float)info.getTextX()[s + 1]).floatValue() + info.getTextW() / 2.0f;
                        ey = ((Float)info.getTextY()[s + 1]).floatValue() + info.getTextH() / 2.0f;
                    } else {
                        ex = ((Float)info.getTextX()[s + 1]).floatValue() + info.getTextW();
                        ey = ((Float)info.getTextY()[s + 1]).floatValue() + info.getTextH();
                    }
                }
                p.setUrx(ex);
                p.setUry(ey);
                float sealX = 0.0f;
                float sealY = 0.0f;
                if (this.width == 0 || this.height == 0 || ex == 0.0f || ey == 0.0f) continue;
                sealX = sx + (ex - sx) / 2.0f - (float)(this.width / 2);
                sealY = sy + (ey - sy) / 2.0f - (float)(this.height / 2);
                p.setX(sealX);
                p.setY(sealY);
                sx = 0.0f;
                sy = 0.0f;
                ex = 0.0f;
                ey = 0.0f;
            }
            this.positions.add(p);
            if (textOnceFindReturn) {
                return this.positions;
            }
            i += len;
        }
        return this.positions;
    }
}

