/*
 * Decompiled with CFR 0.152.
 */
package com.kgofd.ofd.core;

import com.kgofd.commons.KGDateUtils;
import com.kgofd.encrypt.KGBase64;
import com.kgofd.encrypt.KGDefaultMessageDigest;
import com.kgofd.ofd.enmu.KGHashType;
import com.kgofd.ofd.utils.DbStepHttp;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Signature;
import java.util.Calendar;
import org.kg.bouncycastle.asn1.ASN1Encodable;
import org.kg.bouncycastle.asn1.ASN1EncodableVector;
import org.kg.bouncycastle.asn1.ASN1InputStream;
import org.kg.bouncycastle.asn1.ASN1Sequence;
import org.kg.bouncycastle.asn1.DERBitString;
import org.kg.bouncycastle.asn1.DERBoolean;
import org.kg.bouncycastle.asn1.DERGeneralizedTime;
import org.kg.bouncycastle.asn1.DERIA5String;
import org.kg.bouncycastle.asn1.DERInteger;
import org.kg.bouncycastle.asn1.DERObjectIdentifier;
import org.kg.bouncycastle.asn1.DEROctetString;
import org.kg.bouncycastle.asn1.DEROutputStream;
import org.kg.bouncycastle.asn1.DERSequence;
import org.kg.bouncycastle.asn1.DERUTF8String;

public class BuildZWSealData {
    private static final String SEALHEADERID = "ES";
    private static final String SEALHEADERVID = "KingGrid";
    private static final int SEALHEADERVERSION = 4;
    private String sealPropertyName;
    private byte[] sealPropertyCer;
    private String sealPropertyCreateDate;
    private String sealPropertyValidStart;
    private long sealPeriod;
    private String sealPicType;
    private byte[] sealPicData;
    private Float sealPicWidth;
    private Float sealPicHeight;
    private static byte[] signCerData;
    private static String signAlgoId;
    private static ASN1EncodableVector sealInfo;
    private int sealtype;
    private String esID;
    private String[] extnID = new String[3];
    private boolean[] critical = new boolean[3];
    private String[] extnValue = new String[3];

    static {
        signAlgoId = "1.2.156.10197.1.401";
        sealInfo = null;
    }

    public BuildZWSealData(String sealPropertyName, byte[] sealPropertyCer, int sealType, String sealPicType, byte[] sealPicData, Float sealPicWidth, Float sealPicHeight, String sealPropertyCreateDate, String sealPropertyValidStart, long sealPeriod, String esID, String[] extnID, boolean[] critical, String[] extnValue) {
        this.sealPropertyName = sealPropertyName;
        this.sealPropertyCer = sealPropertyCer;
        this.sealtype = sealType;
        this.esID = esID;
        this.sealPicType = sealPicType;
        this.sealPicData = sealPicData;
        this.sealPicWidth = sealPicWidth;
        this.sealPicHeight = sealPicHeight;
        this.sealPeriod = sealPeriod;
        signCerData = sealPropertyCer;
        this.sealPropertyCreateDate = sealPropertyCreateDate;
        this.sealPropertyValidStart = sealPropertyValidStart;
        this.extnID = extnID;
        this.critical = critical;
        this.extnValue = extnValue;
    }

    public void SetExtn(String[] extnID, boolean[] critical, String[] extnValue) {
        this.extnID = extnID;
        this.critical = critical;
        this.extnValue = extnValue;
    }

    public byte[] GetToSignData() {
        ByteArrayOutputStream outputStream;
        block19: {
            outputStream = null;
            DEROutputStream derOutputStream = null;
            try {
                try {
                    outputStream = new ByteArrayOutputStream();
                    derOutputStream = new DEROutputStream((OutputStream)outputStream);
                    sealInfo = new ASN1EncodableVector();
                    ASN1EncodableVector header = new ASN1EncodableVector();
                    header.add((ASN1Encodable)new DERIA5String(SEALHEADERID));
                    header.add((ASN1Encodable)new DERInteger(4L));
                    header.add((ASN1Encodable)new DERIA5String(SEALHEADERVID));
                    sealInfo.add((ASN1Encodable)new DERSequence(header));
                    sealInfo.add((ASN1Encodable)new DERIA5String(this.esID));
                    ASN1EncodableVector propertyInfo = new ASN1EncodableVector();
                    switch (this.sealtype) {
                        case 1: {
                            propertyInfo.add((ASN1Encodable)new DERInteger(1L));
                            break;
                        }
                        case 2: {
                            propertyInfo.add((ASN1Encodable)new DERInteger(2L));
                            break;
                        }
                        case 3: {
                            propertyInfo.add((ASN1Encodable)new DERInteger(3L));
                            break;
                        }
                        case 4: {
                            propertyInfo.add((ASN1Encodable)new DERInteger(4L));
                            break;
                        }
                        case 5: {
                            propertyInfo.add((ASN1Encodable)new DERInteger(5L));
                            break;
                        }
                        default: {
                            throw new RuntimeException("\u65e0\u6548\u7684\u5370\u7ae0\u7c7b\u578b\uff1a" + this.sealtype);
                        }
                    }
                    propertyInfo.add((ASN1Encodable)new DERUTF8String(this.sealPropertyName));
                    propertyInfo.add((ASN1Encodable)new DERInteger(1L));
                    propertyInfo.add((ASN1Encodable)new DERSequence((ASN1Encodable)new DEROctetString(this.sealPropertyCer)));
                    propertyInfo.add((ASN1Encodable)new DERGeneralizedTime(this.sealPropertyCreateDate));
                    propertyInfo.add((ASN1Encodable)new DERGeneralizedTime(this.sealPropertyValidStart));
                    propertyInfo.add((ASN1Encodable)new DERGeneralizedTime(this.GetValidEnd()));
                    sealInfo.add((ASN1Encodable)new DERSequence(propertyInfo));
                    ASN1EncodableVector picInfo = new ASN1EncodableVector();
                    picInfo.add((ASN1Encodable)new DERIA5String(this.sealPicType));
                    picInfo.add((ASN1Encodable)new DEROctetString(this.sealPicData));
                    picInfo.add((ASN1Encodable)new DERInteger(this.sealPicWidth.longValue()));
                    picInfo.add((ASN1Encodable)new DERInteger(this.sealPicHeight.longValue()));
                    sealInfo.add((ASN1Encodable)new DERSequence(picInfo));
                    ASN1EncodableVector extData = new ASN1EncodableVector();
                    if (this.extnID.length >= 3 && this.extnValue.length >= 3) {
                        ASN1EncodableVector ext1 = new ASN1EncodableVector();
                        ext1.add((ASN1Encodable)new DERObjectIdentifier(this.extnID[0]));
                        ext1.add((ASN1Encodable)new DERBoolean(this.critical[0]));
                        ext1.add((ASN1Encodable)new DEROctetString(this.extnValue[0].getBytes()));
                        extData.add((ASN1Encodable)new DERSequence(ext1));
                        ASN1EncodableVector ext2 = new ASN1EncodableVector();
                        ext2.add((ASN1Encodable)new DERObjectIdentifier(this.extnID[1]));
                        ext2.add((ASN1Encodable)new DERBoolean(this.critical[1]));
                        ext2.add((ASN1Encodable)new DEROctetString(this.extnValue[1].getBytes()));
                        extData.add((ASN1Encodable)new DERSequence(ext2));
                        ASN1EncodableVector ext3 = new ASN1EncodableVector();
                        ext3.add((ASN1Encodable)new DERObjectIdentifier(this.extnID[2]));
                        ext3.add((ASN1Encodable)new DERBoolean(this.critical[2]));
                        ext3.add((ASN1Encodable)new DEROctetString(this.extnValue[2].getBytes()));
                        extData.add((ASN1Encodable)new DERSequence(ext3));
                    }
                    sealInfo.add((ASN1Encodable)new DERSequence(extData));
                    derOutputStream.writeObject((ASN1Encodable)new DERSequence(sealInfo));
                    derOutputStream.flush();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    try {
                        derOutputStream.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    break block19;
                }
            }
            catch (Throwable throwable) {
                try {
                    derOutputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                derOutputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return outputStream.toByteArray();
    }

    public static byte[] getSealData(byte[] toSignData, byte[] signValue) throws IOException {
        ByteArrayOutputStream outputStream;
        block5: {
            outputStream = null;
            DEROutputStream derOutputStream = null;
            try {
                try {
                    ASN1Sequence toASN1SignData;
                    outputStream = new ByteArrayOutputStream();
                    derOutputStream = new DEROutputStream((OutputStream)outputStream);
                    ASN1InputStream asn1ToSignData = new ASN1InputStream(toSignData);
                    ASN1Sequence sealInfo = toASN1SignData = (ASN1Sequence)asn1ToSignData.readObject();
                    ASN1EncodableVector signInfo = new ASN1EncodableVector();
                    ASN1Sequence propertyInfo = (ASN1Sequence)toASN1SignData.getObjectAt(2);
                    signInfo.add(propertyInfo.getObjectAt(3));
                    signInfo.add((ASN1Encodable)new DERObjectIdentifier(signAlgoId));
                    signInfo.add((ASN1Encodable)new DERBitString(signValue));
                    ASN1EncodableVector SESeal = new ASN1EncodableVector();
                    SESeal.add((ASN1Encodable)sealInfo);
                    ASN1Sequence certSequence = (ASN1Sequence)propertyInfo.getObjectAt(3);
                    SESeal.add(certSequence.getObjectAt(0));
                    SESeal.add((ASN1Encodable)new DERObjectIdentifier(signAlgoId));
                    SESeal.add((ASN1Encodable)new DERBitString(signValue));
                    derOutputStream.writeObject((ASN1Encodable)new DERSequence(SESeal));
                    derOutputStream.flush();
                }
                catch (Exception e) {
                    System.out.println(e.getMessage());
                    derOutputStream.close();
                    break block5;
                }
            }
            catch (Throwable throwable) {
                derOutputStream.close();
                throw throwable;
            }
            derOutputStream.close();
        }
        return outputStream.toByteArray();
    }

    public String GetValidEnd() {
        Calendar cal = Calendar.getInstance();
        cal.add(1, (int)this.sealPeriod);
        return String.valueOf(KGDateUtils.format(cal.getTime(), "yyyyMMddHHmmss")) + "Z";
    }

    public static byte[] getSignData(byte[] toSignData, String url, String signsn, String keysn, KGHashType hashType) throws IOException {
        byte[] signature = null;
        if (url.isEmpty()) {
            try {
                signature = BuildZWSealData.sign(toSignData, hashType);
            }
            catch (Exception e) {
                throw new RuntimeException("\u7b7e\u540d\u5931\u8d25\uff1a  " + e.getMessage());
            }
        }
        DbStepHttp httpClient = new DbStepHttp(url);
        httpClient.set("OPTION", "SIGNCONTEXT");
        KGDefaultMessageDigest messageDigest = new KGDefaultMessageDigest();
        messageDigest.update(toSignData);
        KGBase64 base64 = new KGBase64();
        httpClient.set("CERTTEXT", base64.encode(messageDigest.digest()));
        httpClient.set("KEYSN", keysn);
        try {
            if (!httpClient.send()) {
                throw new RuntimeException("\u8fde\u63a5\u7b7e\u7ae0\u670d\u52a1\u5668\u5f02\u5e38" + httpClient.getError());
            }
            String certcontext = httpClient.get("CERTCONTEXT");
            String signresult = httpClient.get("SIGNRESULT");
            signature = signresult.getBytes();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return signature;
    }

    public static KeyPair testGenInternalKey(int keyNumber) throws Exception {
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA", "SwxaJCE");
        kpg.initialize(keyNumber << 16);
        return kpg.genKeyPair();
    }

    public static KeyPair testGenInternalKeySM2(int keynum) throws Exception {
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("SM2", "SwxaJCE");
        kpg.initialize(keynum << 16);
        return kpg.genKeyPair();
    }

    private static byte[] sign(byte[] dataInput, KGHashType hashType) throws Exception {
        byte[] signedData = null;
        if (hashType == KGHashType.HASH_TYPE_SHA1) {
            KeyPair keyPair = BuildZWSealData.testGenInternalKey(1);
            PrivateKey privateKey = keyPair.getPrivate();
            Signature signatue = Signature.getInstance("SHA1WithRSA", "SwxaJCE");
            signatue.initSign(privateKey);
            signatue.update(dataInput);
            signedData = signatue.sign();
        } else {
            PrivateKey privateKey = (PrivateKey)BuildZWSealData.readKeyFromDevice(1, "SM2", false);
            Signature signature = Signature.getInstance("SM3WithSM2", "SwxaJCE");
            signature.initSign(privateKey);
            signature.update(dataInput);
            signedData = signature.sign();
        }
        return signedData;
    }

    private static Key readKeyFromDevice(int index, String alg, boolean isPublic) throws NoSuchAlgorithmException, NoSuchProviderException {
        KeyPairGenerator generator = KeyPairGenerator.getInstance(alg, "SwxaJCE");
        generator.initialize(index << 16);
        KeyPair pair = generator.generateKeyPair();
        if (pair == null) {
            throw new RuntimeException("\u5bc6\u7801\u673a\u7d22\u5f15\u4e0d\u5b58\u5728\u5bc6\u94a5\u5bf9, index = " + index);
        }
        if (isPublic) {
            return pair.getPublic();
        }
        return pair.getPrivate();
    }

    public int getSealtype() {
        return this.sealtype;
    }

    public void setSealtype(int sealtype) {
        this.sealtype = sealtype;
    }

    public static void main(String[] args) {
    }
}

