/*
 * Decompiled with CFR 0.152.
 */
package com.kgofd.ofd;

import com.kgofd.authorization.KGFacadeCglib;
import com.kgofd.encrypt.KGBase64;
import com.kgofd.encrypt.SM2;
import com.kgofd.ofd.KGExecute;
import com.kgofd.ofd.KGOfdHummerUtils;
import com.kgofd.ofd.core.OfdSignatureApCallback;
import com.kgofd.ofd.enmu.KGSignType;
import com.kgofd.ofd.signinter.SignatureInterByKey;
import com.kgofd.ofd.utils.KGOfdUtils;
import java.io.File;
import java.io.IOException;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.List;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import org.dom4j.DocumentException;
import org.kg.bouncycastle.jce.provider.BouncyCastleProvider;

public class KGOfdHummer {
    private List<KGExecute> executes = new ArrayList<KGExecute>();
    private ZipFile zipFile;
    private boolean multiUserSign = false;

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    public void setZipFile(ZipFile zipFile) {
        this.zipFile = zipFile;
    }

    public ZipFile getZipFile() {
        return this.zipFile;
    }

    public void setMultiUserSign(boolean multiUserSign) {
        this.multiUserSign = multiUserSign;
    }

    public void addExecute(KGExecute execute) {
        this.executes.add(execute);
    }

    public static KGOfdHummer createInstance(String fileName, byte[] ownerPassword, String outPath) throws IOException, ZipException {
        KGOfdHummer hummer = KGOfdHummer.getInstance();
        if (fileName == null || "".equals(fileName) || !new File(fileName).exists()) {
            throw new ZipException("\u4f20\u5165\u7684\u8def\u5f84\u4e3a\u7a7a\u6216\u6587\u4ef6\u4e0d\u5b58\u5728\uff01");
        }
        ZipFile zipFile = null;
        if (outPath != null) {
            KGOfdUtils.WriteFile(fileName, outPath);
            zipFile = new ZipFile(outPath);
        } else {
            zipFile = new ZipFile(fileName);
        }
        zipFile.setFileNameCharset("GBK");
        if (!zipFile.isValidZipFile()) {
            throw new ZipException("OFD\u6587\u4ef6\u4e0d\u5408\u6cd5\u6216\u53ef\u80fd\u88ab\u635f\u574f\uff01");
        }
        hummer.setZipFile(zipFile);
        return hummer;
    }

    public static KGOfdHummer createInstance(String fileName, byte[] ownerPassword) throws IOException, ZipException {
        return KGOfdHummer.createInstance(fileName, ownerPassword, null);
    }

    public static KGOfdHummer getInstance() {
        return (KGOfdHummer)KGFacadeCglib.getInstance(KGOfdHummer.class);
    }

    public void doExecute() throws IOException, DocumentException, ZipException {
        OfdSignatureApCallbackImpl ofdSignatureApCallback = new OfdSignatureApCallbackImpl();
        ((OfdSignatureApCallback)ofdSignatureApCallback).execute();
    }

    public void doSignature(String signData, String signDirPath, String outPath) throws IOException, ZipException {
        KGOfdUtils ofdUtils = new KGOfdUtils();
        this.zipFile = new ZipFile(outPath);
        SignatureInterByKey inter = new SignatureInterByKey();
        byte[] toSignData = KGOfdUtils.getFileByte(this.zipFile, String.valueOf(signDirPath) + "/SignedValue.dat");
        KGBase64 base64 = new KGBase64();
        byte[] signDataByte = base64.decode(signData);
        byte[] stampData = inter.createDatFile(toSignData, signDataByte, signDirPath);
        KGOfdUtils.writeToZip(this.zipFile, String.valueOf(signDirPath) + "/SignedValue.dat", stampData);
    }

    public void doSignature(String signData, String signDirPath, String outPath, String sealType, String cert) throws IOException, ZipException {
        KGOfdUtils ofdUtils = new KGOfdUtils();
        this.zipFile = new ZipFile(outPath);
        SignatureInterByKey signatureInterByKey = new SignatureInterByKey();
        if ("GB".equals(sealType)) {
            signatureInterByKey.setSealType("GB");
        } else if ("GM".equals(sealType)) {
            signatureInterByKey.setSealType("GM");
        } else {
            throw new RuntimeException("\u4e0d\u652f\u6301\u8be5\u4e2d\u5370\u7ae0\u7c7b\u578b\uff1a" + sealType);
        }
        if (cert != null) {
            signatureInterByKey.setCer(cert);
        }
        byte[] toSignData = KGOfdUtils.getFileByte(this.zipFile, String.valueOf(signDirPath) + "/SignedValue.dat");
        KGBase64 base64 = new KGBase64();
        byte[] signDataByte = base64.decode(signData);
        byte[] stampData = signatureInterByKey.createDatFile(toSignData, signDataByte, signDirPath);
        KGOfdUtils.writeToZip(this.zipFile, String.valueOf(signDirPath) + "/SignedValue.dat", stampData);
    }

    public byte[] toSignData(String path, String signDirPath) throws ZipException {
        if (this.zipFile == null) {
            this.zipFile = new ZipFile(path);
        }
        KGOfdUtils ofdUtils = new KGOfdUtils();
        byte[] toSignData = KGOfdUtils.getFileByte(this.zipFile, String.valueOf(signDirPath) + "/SignedValue.dat");
        return toSignData;
    }

    public void doSignature(byte[] stampData, String signDirPath, String path) throws IOException, ZipException {
        KGOfdUtils ofdUtils = new KGOfdUtils();
        if (this.zipFile == null) {
            this.zipFile = new ZipFile(path);
        }
        KGOfdUtils.writeToZip(this.zipFile, String.valueOf(signDirPath) + "/SignedValue.dat", stampData);
    }

    public String DigitSign(String originalText, KGSignType signType) {
        String strRet = "";
        if (originalText != null && !originalText.isEmpty() && signType == KGSignType.TYPE_SM2) {
            strRet = SM2.getInstance().Sign(originalText.getBytes());
        }
        return strRet;
    }

    public String DigitSign(byte[] originalText, KGSignType signType) {
        String strRet = "";
        if (originalText != null && originalText.length > 0 && signType == KGSignType.TYPE_SM2) {
            strRet = SM2.getInstance().Sign(originalText);
        }
        return strRet;
    }

    public boolean VerifySign(byte[] originalText, String signData, KGSignType signType) {
        if (originalText != null && originalText.length > 0 && signData != null && !signData.isEmpty() && signType == KGSignType.TYPE_SM2) {
            return SM2.getInstance().Verify(originalText, signData);
        }
        return false;
    }

    public boolean VerifySign(String originalText, String signData, KGSignType signType) {
        if (originalText != null && !originalText.isEmpty() && signData != null && !signData.isEmpty() && signType == KGSignType.TYPE_SM2) {
            return SM2.getInstance().Verify(originalText.getBytes(), signData);
        }
        return false;
    }

    public KGOfdHummerUtils getKGOfdHummerUtils() {
        return new KGOfdHummerUtils(this.zipFile);
    }

    public int getPageOfNumber() throws ZipException, DocumentException {
        int number = KGOfdUtils.getTotalPage(this.zipFile);
        return number;
    }

    class OfdSignatureApCallbackImpl
    extends OfdSignatureApCallback {
        OfdSignatureApCallbackImpl() {
        }

        @Override
        public void execute() throws IOException, DocumentException, ZipException {
            for (KGExecute executeInterface : KGOfdHummer.this.executes) {
                executeInterface.before();
            }
            for (KGExecute executeInterface : KGOfdHummer.this.executes) {
                executeInterface.doExecute(KGOfdHummer.this.zipFile, KGOfdHummer.this.multiUserSign);
            }
            for (KGExecute executeInterface : KGOfdHummer.this.executes) {
                executeInterface.after();
            }
        }
    }
}

