/*
 * Decompiled with CFR 0.152.
 */
package com.kgofd.kgcore;

import com.kgofd.encrypt.KGBase64;
import com.kgofd.kgcore.IMsgServer;
import com.kgofd.kgcore.LogEntity;
import com.kgofd.kgcore.SealInformation;
import com.kgofd.kgcore.enmu.KGQueryByEnum;
import com.kgofd.kgcore.enmu.KGServerTypeEnum;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class KGHttpUtils {
    public static final String DELETESEAL = "14";
    private static final String CHARSET = "GBK";
    private KGQueryByEnum queryBy = KGQueryByEnum.KEYSN;

    public KGQueryByEnum getQueryBy() {
        return this.queryBy;
    }

    public void setQueryBy(KGQueryByEnum queryBy) {
        this.queryBy = queryBy;
    }

    public void modifyUserPwdByKeySN(String url, String keySN, String originalPwd, String newPwd) throws Exception {
        this.modifyUserPwd(url, keySN, null, originalPwd, newPwd);
    }

    public void modifyUserPwdByUserCode(String url, String userCode, String originalPwd, String newPwd) throws Exception {
        this.modifyUserPwd(url, null, userCode, originalPwd, newPwd);
    }

    private void modifyUserPwd(String url, String keySN, String userCode, String originalPwd, String newPwd) throws Exception {
        IMsgServer msgServer;
        Pattern p = Pattern.compile("[0-9a-zA-z,!,@,#,$,%,^,&,*,~]{6,16}");
        Matcher m = p.matcher(newPwd);
        if (m.matches()) {
            msgServer = new IMsgServer();
            msgServer.setCharset(CHARSET);
            msgServer.SetMsgByName("OPTION", "MODIFYVIRTUALPASSWORD2");
            if (keySN != null) {
                msgServer.SetMsgByName("KEYSN", keySN);
            } else {
                msgServer.SetMsgByName("USERCODE", userCode);
            }
        } else {
            throw new IllegalArgumentException("\u5bc6\u7801\u5fc5\u987b\u4e3a\u6570\u5b57\u82f1\u6587\u5b57\u6bcd\u7b49\uff0c\u4e0d\u80fd\u4f7f\u7528\u4e2d\u6587.\u4e14\u5bc6\u7801\u957f\u5ea6\u4e3a6-16\u4f4d.");
        }
        msgServer.SetMsgByName("PASSWORD", originalPwd);
        msgServer.SetMsgByName("NEWPWD", newPwd);
        this.sendPacktToServer(url, msgServer);
    }

    public Map<String, Object> sign(String url, String keySN, byte[] text) throws CertificateException {
        IMsgServer msgServer = new IMsgServer();
        KGBase64 base64 = new KGBase64();
        msgServer.setCharset(CHARSET);
        msgServer.SetMsgByName("OPTION", "SIGNCONTEXT");
        msgServer.SetMsgByName("KEYSN", keySN);
        msgServer.SetMsgByName("CERTTEXT", text == null ? "" : base64.encode(text));
        this.sendPacktToServer(url, msgServer);
        if ("OK".equals(msgServer.GetMsgByName("STATUS"))) {
            byte[] cert = base64.decode(msgServer.GetMsgByName("CERTCONTEXT"));
            CertificateFactory factory = CertificateFactory.getInstance("X.509");
            X509Certificate certificate = (X509Certificate)factory.generateCertificate(new ByteArrayInputStream(cert));
            byte[] signData = base64.decode(msgServer.GetMsgByName("SIGNRESULT"));
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("certificate", certificate);
            map.put("signData", signData);
            return map;
        }
        throw new RuntimeException(String.valueOf(keySN) + " : " + msgServer.MsgError());
    }

    public List<SealInformation> getServerSeal(String url, KGServerTypeEnum serverTypeEnum, String keySN, String sealName) {
        if (serverTypeEnum == KGServerTypeEnum.GA) {
            return this.getGAServerSeal(url, keySN, sealName);
        }
        IMsgServer msgServer = new IMsgServer();
        msgServer.setCharset(CHARSET);
        if (serverTypeEnum == KGServerTypeEnum.AUTO_GM) {
            msgServer.SetMsgByName("OPTION", "GETSIGNATUREBYSM2");
        } else {
            msgServer.SetMsgByName("OPTION", "GETNETFILESIGNATURES");
        }
        if (KGQueryByEnum.KEYSN == this.queryBy) {
            msgServer.SetMsgByName("VIRTUALKEYNUMBER", keySN);
        } else if (KGQueryByEnum.USERCODE == this.queryBy) {
            msgServer.SetMsgByName("USERCODE", keySN);
        }
        msgServer.SetMsgByName("SIGNATURENAME", sealName);
        this.sendPacktToServer(url, msgServer);
        String userInfo = msgServer.GetMsgByName("USERINFO");
        String netFileSignatures = msgServer.GetMsgByName("NETFILESIGNATURES");
        if (netFileSignatures == null || "".equals(netFileSignatures)) {
            return null;
        }
        ArrayList<SealInformation> list = new ArrayList<SealInformation>();
        String[] tmp = userInfo.split(",");
        String[] signDatas = netFileSignatures.split(";");
        String signData = null;
        SealInformation sealInformation = null;
        if (signDatas != null && signDatas.length > 0) {
            int i = 0;
            while (i < signDatas.length) {
                sealInformation = new SealInformation();
                sealInformation.setImgUserName(tmp[1]);
                sealInformation.setKeySN(tmp[0]);
                sealInformation.setKeySerial(tmp[0]);
                sealInformation.setKeyPwd(tmp[3]);
                sealInformation.setImgSignPass(tmp[3]);
                sealInformation.setImgUnitName(tmp[2]);
                signData = signDatas[i];
                String[] signParams = signData.split(",");
                if (signParams.length > 2) {
                    sealInformation.setImgSignName(signParams[1]);
                }
                this.parserSignData(signData, serverTypeEnum, sealInformation);
                list.add(sealInformation);
                ++i;
            }
        }
        return list;
    }

    public List<SealInformation> getGAServerSeal(String url, String keySN, String sealName) {
        IMsgServer msgServer = new IMsgServer();
        msgServer.setCharset(CHARSET);
        msgServer.SetMsgByName("OPTION", "CHECKSIGNBYALL");
        msgServer.SetMsgByName("COMMAND", "GETKEYSIGNINFO");
        msgServer.SetMsgByName("SIGNPRIORPUB", "8");
        msgServer.SetMsgByName("KEYSN", keySN);
        this.sendPacktToServer(url, msgServer);
        String signsString = msgServer.GetMsgByName("SIGNPOWER");
        ArrayList<SealInformation> list = new ArrayList<SealInformation>();
        if (signsString == null) {
            return list;
        }
        String[] signs = signsString.split(";");
        SealInformation sealInformation = null;
        String signImageData = null;
        int i = 0;
        while (i < signs.length) {
            sealInformation = new SealInformation();
            String[] sign = signs[i].split(",");
            sealInformation.setKeySN(keySN);
            sealInformation.setSignSN(sign[0]);
            msgServer.setTableBase64("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=");
            sealInformation.setImgSignName(msgServer.DecodeBase64(sign[2]));
            sealInformation.setImgUnitName(msgServer.DecodeBase64(sign[10]));
            sealInformation.setImgUserName(msgServer.DecodeBase64(sign[12]));
            sealInformation.setImgFileExt(sign[4]);
            sealInformation.setImgWidth(sign[5]);
            sealInformation.setImgHeight(sign[6]);
            signImageData = sign[9];
            this.parserSignData(signImageData, KGServerTypeEnum.GA, sealInformation);
            list.add(sealInformation);
            ++i;
        }
        return list;
    }

    private void parserSignData(String signData, KGServerTypeEnum serverTypeEnum, SealInformation sealInformation) {
        if (!"".equalsIgnoreCase(signData)) {
            if (KGServerTypeEnum.GA == serverTypeEnum) {
                this.parserSignData4GA(signData, sealInformation);
                return;
            }
            String[] tmp = signData.split(",");
            sealInformation.setFileName(String.valueOf(tmp[1]) + tmp[2]);
            sealInformation.setSignSN(tmp[0]);
            sealInformation.setKeySerial(tmp[1]);
            sealInformation.setImgFileExt(tmp[2]);
            sealInformation.setImgWidth(tmp[3]);
            sealInformation.setImgHeight(tmp[4]);
            if (KGServerTypeEnum.AUTO == serverTypeEnum) {
                String signSN = sealInformation.getSignSN();
                if (tmp[5].startsWith(signSN)) {
                    this.parserSignData4NET(tmp[5], sealInformation);
                } else if (signSN.startsWith("{")) {
                    String base64Table = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";
                    this.parserImageData(tmp[5], base64Table, sealInformation);
                } else {
                    this.parserSignData2byte(tmp[5], sealInformation);
                }
            } else if (KGServerTypeEnum.AUTO_GM == serverTypeEnum) {
                String base64Table = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";
                this.parserImageData(tmp[5], base64Table, sealInformation);
            } else if (KGServerTypeEnum.NET == serverTypeEnum) {
                this.parserSignData4NET(tmp[5], sealInformation);
            } else {
                this.parserSignData2byte(tmp[5], sealInformation);
            }
            if (tmp.length > 6) {
                sealInformation.setImgType(tmp[6]);
            }
        }
    }

    private void parserSignData4NET(String signData, SealInformation sealInformation) {
        String base64Table = signData.substring(0, 65);
        String imageData = signData.substring(65);
        sealInformation.setImgTableBase64(base64Table);
        this.parserImageData(imageData, base64Table, sealInformation);
    }

    private void parserSignData4GA(String signData, SealInformation sealInformation) {
        String base64Table = "=ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
        String imageData = signData.substring(65);
        sealInformation.setImgTableBase64(base64Table);
        this.parserImageData(imageData, base64Table, sealInformation);
    }

    private void parserSignData2byte(String signData, SealInformation sealInformation) {
        String base64Table = signData.substring(32, 97);
        String imageData = signData.substring(97);
        sealInformation.setImgTableBase64(base64Table);
        this.parserImageData(imageData, base64Table, sealInformation);
    }

    private void parserImageData(String imageData, String base64Table, SealInformation sealInformation) {
        KGBase64 base64 = new KGBase64();
        base64.setBase64Table(base64Table);
        sealInformation.setImgValue(base64.decode(imageData));
    }

    public void saveLog(String url, LogEntity logEntity) {
        IMsgServer msgServer = new IMsgServer();
        msgServer.SetMsgByName("DBSTEP", "DBSTEP");
        msgServer.SetMsgByName("OPTION", "SAVELOG");
        msgServer.SetMsgByName("KEYSN", logEntity.getKeySN());
        msgServer.SetMsgByName("SIGNSN", logEntity.getSignSN());
        msgServer.SetMsgByName("LOGSORT", logEntity.getLogSort());
        msgServer.SetMsgByName("LOGTYPE", logEntity.getLogType());
        msgServer.SetMsgByName("LOGIP", logEntity.getLogIP());
        msgServer.SetMsgByName("LOGMEMO", logEntity.getLogMemo());
        msgServer.SetMsgByName("DOCUMENTID", logEntity.getDocumentID());
        msgServer.SetMsgByName("DOCUMENTNAME", logEntity.getDocumentName());
        msgServer.SetMsgByName("EXTPARAM1", logEntity.getExtparam1());
        msgServer.SetMsgByName("EXTPARAM2", logEntity.getExtparam2());
        this.sendPacktToServer(url, msgServer);
    }

    public void sendPacktToServer(String url, IMsgServer msgServer) {
        OutputStream outStream = null;
        InputStream inputStream = null;
        msgServer.SetMsgByName("DBSTEP", "DBSTEP");
        try {
            try {
                URL objUrl = new URL(url);
                HttpURLConnection connection = (HttpURLConnection)objUrl.openConnection();
                connection.setRequestMethod("POST");
                connection.setDoOutput(true);
                connection.setConnectTimeout(10000);
                connection.setReadTimeout(10000);
                connection.connect();
                outStream = connection.getOutputStream();
                byte[] databytes = msgServer.MsgVariant();
                outStream.write(databytes);
                outStream.flush();
                inputStream = connection.getInputStream();
                byte[] packData = this.readPack(inputStream);
                connection.disconnect();
                msgServer.MsgTextClear();
                msgServer.MsgVariant(packData);
                if (msgServer.MsgError() != null && !"".equals(msgServer.MsgError())) {
                    throw new RuntimeException("\u7b7e\u7ae0\u670d\u52a1\u5668\u6d88\u606f\uff1a" + msgServer.MsgError());
                }
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        catch (Throwable throwable) {
            this.close(outStream);
            this.close(inputStream);
            throw throwable;
        }
        this.close(outStream);
        this.close(inputStream);
    }

    private byte[] readPack(InputStream is) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(is);
        byte[] buf = new byte[1024];
        int length = -1;
        while ((length = bufferedInputStream.read(buf)) != -1) {
            byteArrayOutputStream.write(buf, 0, length);
        }
        return byteArrayOutputStream.toByteArray();
    }

    private void close(Closeable stream) {
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

