/*
 * Decompiled with CFR 0.152.
 */
package com.kgofd.kgcore;

import com.kgofd.encrypt.KGBase64;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public class IMsgServer {
    private String TableBase64 = "=ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
    private byte[] FStream;
    private byte[] FMsgFile;
    private String FMsgText = "";
    private String FError = "";
    private String FVersion = "DBSTEP V3.0";
    private int FFileSize = 0;
    private byte[] errorByte;
    private String charset = "GBK";

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setTableBase64(String tableBase64) {
        this.TableBase64 = tableBase64;
    }

    protected String FormatHead(String vString) {
        if (vString.length() > 16) {
            return vString.substring(0, 16);
        }
        int i = vString.length() + 1;
        while (i < 17) {
            vString = vString.concat(" ");
            ++i;
        }
        return vString;
    }

    private boolean MsgToStream() {
        int HeadSize = 64;
        int BodySize = 0;
        int ErrorSize = 0;
        int FileSize = 0;
        int Position2 = 0;
        try {
            Position2 = 0;
            BodySize = this.FMsgText.getBytes(this.charset).length;
            ErrorSize = this.FError.getBytes(this.charset).length;
            FileSize = this.FFileSize;
            ByteArrayOutputStream mBuffer = new ByteArrayOutputStream(HeadSize + BodySize + ErrorSize + FileSize);
            StringBuilder builder = new StringBuilder();
            builder.append(this.FormatHead(this.FVersion));
            builder.append(this.FormatHead(String.valueOf(BodySize)));
            builder.append(this.FormatHead(String.valueOf(ErrorSize)));
            builder.append(this.FormatHead(String.valueOf(FileSize)));
            String HeadString = builder.toString();
            mBuffer.write(HeadString.getBytes(this.charset), Position2, HeadSize);
            Position2 += HeadSize;
            if (BodySize > 0) {
                mBuffer.write(this.FMsgText.getBytes(this.charset));
            }
            Position2 += BodySize;
            if (ErrorSize > 0) {
                mBuffer.write(this.FError.getBytes(this.charset));
            }
            Position2 += ErrorSize;
            if (FileSize > 0) {
                mBuffer.write(this.FMsgFile);
            }
            Position2 += FileSize;
            mBuffer.close();
            this.FStream = mBuffer.toByteArray();
            return true;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] MsgVariant() {
        this.MsgToStream();
        return this.FStream;
    }

    private boolean StreamToMsg() {
        int HeadSize = 64;
        int BodySize = 0;
        int ErrorSize = 0;
        int FileSize = 0;
        int Position2 = 0;
        try {
            Position2 = 0;
            String HeadString = new String(this.FStream, Position2, HeadSize);
            this.FVersion = HeadString.substring(0, 15);
            BodySize = Integer.parseInt(HeadString.substring(16, 31).trim());
            ErrorSize = Integer.parseInt(HeadString.substring(32, 47).trim());
            this.FFileSize = FileSize = Integer.parseInt(HeadString.substring(48, 63).trim());
            Position2 += HeadSize;
            if (BodySize > 0) {
                this.FMsgText = new String(this.FStream, Position2, BodySize);
            }
            Position2 += BodySize;
            if (ErrorSize > 0) {
                this.errorByte = new byte[ErrorSize];
                System.arraycopy(this.FStream, Position2, this.errorByte, 0, ErrorSize);
                this.FError = new String(this.errorByte, this.charset);
            }
            Position2 += ErrorSize;
            this.FMsgFile = new byte[FileSize];
            if (FileSize > 0) {
                int i = 0;
                while (i < FileSize) {
                    this.FMsgFile[i] = this.FStream[i + Position2];
                    ++i;
                }
            }
            return true;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void MsgVariant(byte[] mStream) {
        this.FStream = mStream;
        if (this.FError == "") {
            this.StreamToMsg();
        }
    }

    public boolean SavePackage(String FileName) {
        FileOutputStream mFile = null;
        try {
            mFile = new FileOutputStream(FileName);
            mFile.write(this.FStream);
            return true;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (mFile != null) {
                    mFile.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public boolean MsgFileSave(String FileName) {
        try {
            FileOutputStream mFile = new FileOutputStream(FileName);
            mFile.write(this.FMsgFile);
            mFile.close();
            return true;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean MsgFileLoad(String FileName) {
        try {
            File mFile = new File(FileName);
            int mSize = (int)mFile.length();
            int mRead = 0;
            this.FMsgFile = new byte[mSize];
            FileInputStream mStream = new FileInputStream(mFile);
            while (mRead < mSize) {
                mRead += mStream.read(this.FMsgFile, mRead, mSize - mRead);
            }
            mStream.close();
            this.FFileSize = mSize;
            return true;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String MsgTextBody() {
        return this.FMsgText;
    }

    public byte[] MsgFileBody() {
        return this.FMsgFile;
    }

    public String MsgError() {
        return this.FError;
    }

    public String MsgVersion() {
        return this.FVersion;
    }

    public void MsgTextBody(String Value) {
        this.FMsgText = Value;
    }

    public void MsgFileBody(byte[] Value) {
        this.FMsgFile = Value;
        this.FFileSize = this.FMsgFile.length;
    }

    public void MsgError(String Value) {
        this.FError = Value;
    }

    public int MsgFileSize() {
        return this.FFileSize;
    }

    public void MsgFileSize(int value) {
        this.FFileSize = value;
    }

    public void MsgFileClear() {
        this.FFileSize = 0;
        this.FMsgFile = null;
    }

    public void MsgTextClear() {
        this.FMsgText = "";
    }

    public void MsgErrorClear() {
        this.FError = "";
    }

    public String DecodeBase64(String Value) {
        KGBase64 base64 = new KGBase64();
        base64.setBase64Table(this.TableBase64);
        byte[] buffer = base64.decode(Value);
        try {
            return new String(buffer, this.charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public String EncodeBase64(String Value) {
        KGBase64 base64 = new KGBase64();
        base64.setBase64Table(this.TableBase64);
        try {
            return base64.encode(Value.getBytes(this.charset));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public int GetFieldCount() {
        int i = 0;
        int j = 0;
        i = this.FMsgText.indexOf("\r\n", i + 1);
        while (i != -1) {
            ++j;
            i = this.FMsgText.indexOf("\r\n", i + 1);
        }
        return j;
    }

    public String GetFieldName(int Index) {
        int i = 0;
        int j = 0;
        int k = 0;
        int n = 0;
        String mFieldString = "";
        String mFieldName = "";
        String mReturn = "";
        while (i != -1 && j < Index) {
            if ((i = this.FMsgText.indexOf("\r\n", i + 1)) == -1) continue;
            ++j;
        }
        k = this.FMsgText.indexOf("\r\n", i + 1);
        if (i != -1 && k != -1 && (n = (mFieldString = i == 0 ? this.FMsgText.substring(i, k) : this.FMsgText.substring(i + 2, k)).indexOf("=", 0)) != -1) {
            mReturn = mFieldName = mFieldString.substring(0, n);
        }
        return mReturn;
    }

    public String GetFieldValue(int Index) {
        int i = 0;
        int j = 0;
        int k = 0;
        int n = 0;
        String mFieldString = "";
        String mFieldValue = "";
        String mReturn = "";
        while (i != -1 && j < Index) {
            if ((i = this.FMsgText.indexOf("\r\n", i + 1)) == -1) continue;
            ++j;
        }
        k = this.FMsgText.indexOf("\r\n", i + 1);
        if (i != -1 && k != -1 && (n = (mFieldString = i == 0 ? this.FMsgText.substring(i, k) : this.FMsgText.substring(i + 2, k)).indexOf("=", 0)) != -1) {
            mFieldValue = mFieldString.substring(n + 1, mFieldString.length());
            mReturn = this.DecodeBase64(mFieldValue);
        }
        return mReturn;
    }

    public String GetFieldText() {
        return this.FMsgText.toString();
    }

    public String GetMsgByName(String FieldName) {
        int i = 0;
        int j = 0;
        String mReturn = "";
        String mFieldName = FieldName.trim().concat("=");
        i = this.FMsgText.indexOf(mFieldName);
        if (i != -1) {
            j = this.FMsgText.indexOf("\r\n", i + 1);
            i += mFieldName.length();
            if (j != -1) {
                String mFieldValue = this.FMsgText.substring(i, j);
                mReturn = this.DecodeBase64(mFieldValue);
                return mReturn;
            }
            return mReturn;
        }
        return mReturn;
    }

    public void SetMsgByName(String FieldName, String FieldValue) {
        String mFieldText = "";
        String mFieldHead = "";
        String mFieldNill = "";
        int i = 0;
        int j = 0;
        boolean f = false;
        if (FieldValue == null) {
            FieldValue = "";
        }
        String mFieldName = FieldName.trim().concat("=");
        String mFieldValue = this.EncodeBase64(FieldValue);
        mFieldText = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(mFieldName))).append(mFieldValue).append("\r\n")));
        i = this.FMsgText.indexOf(mFieldName);
        if (i != -1 && (j = this.FMsgText.indexOf("\r\n", i + 1)) != -1) {
            mFieldHead = this.FMsgText.substring(0, i);
            mFieldNill = this.FMsgText.substring(j + 2);
            f = true;
        }
        if (f) {
            StringBuilder builder = new StringBuilder();
            builder.append(mFieldHead).append(mFieldText).append(mFieldNill);
            this.FMsgText = builder.toString();
        } else {
            this.FMsgText = this.FMsgText.concat(mFieldText);
        }
    }

    public boolean MakeDirectory(String FilePath) {
        File mFile = new File(FilePath);
        mFile.mkdirs();
        return mFile.isDirectory();
    }

    public String getError() {
        String error = null;
        if (this.errorByte != null) {
            try {
                error = new String(this.errorByte, this.charset);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return error;
    }
}

