/*
 * Decompiled with CFR 0.152.
 */
package org.kg.bouncycastle.pkcs.jcajce;

import java.io.OutputStream;
import java.security.Provider;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.kg.bouncycastle.asn1.ASN1Encodable;
import org.kg.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.kg.bouncycastle.asn1.DERNull;
import org.kg.bouncycastle.asn1.pkcs.PKCS12PBEParams;
import org.kg.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.kg.bouncycastle.crypto.generators.PKCS12ParametersGenerator;
import org.kg.bouncycastle.jcajce.DefaultJcaJceHelper;
import org.kg.bouncycastle.jcajce.JcaJceHelper;
import org.kg.bouncycastle.jcajce.NamedJcaJceHelper;
import org.kg.bouncycastle.jcajce.ProviderJcaJceHelper;
import org.kg.bouncycastle.jcajce.io.MacOutputStream;
import org.kg.bouncycastle.operator.GenericKey;
import org.kg.bouncycastle.operator.MacCalculator;
import org.kg.bouncycastle.operator.OperatorCreationException;
import org.kg.bouncycastle.pkcs.PKCS12MacCalculatorBuilder;
import org.kg.bouncycastle.pkcs.PKCS12MacCalculatorBuilderProvider;

public class JcePKCS12MacCalculatorBuilderProvider
implements PKCS12MacCalculatorBuilderProvider {
    private JcaJceHelper helper = new DefaultJcaJceHelper();

    public JcePKCS12MacCalculatorBuilderProvider setProvider(Provider provider) {
        this.helper = new ProviderJcaJceHelper(provider);
        return this;
    }

    public JcePKCS12MacCalculatorBuilderProvider setProvider(String providerName) {
        this.helper = new NamedJcaJceHelper(providerName);
        return this;
    }

    public PKCS12MacCalculatorBuilder get(final AlgorithmIdentifier algorithmIdentifier) {
        return new PKCS12MacCalculatorBuilder(){

            public MacCalculator build(char[] password) throws OperatorCreationException {
                PKCS12PBEParams pbeParams = PKCS12PBEParams.getInstance(algorithmIdentifier.getParameters());
                try {
                    ASN1ObjectIdentifier algorithm = algorithmIdentifier.getAlgorithm();
                    Mac mac = JcePKCS12MacCalculatorBuilderProvider.this.helper.createMac(algorithm.getId());
                    SecretKeyFactory keyFact = JcePKCS12MacCalculatorBuilderProvider.this.helper.createSecretKeyFactory(algorithm.getId());
                    PBEParameterSpec defParams = new PBEParameterSpec(pbeParams.getIV(), pbeParams.getIterations().intValue());
                    PBEKeySpec pbeSpec = new PBEKeySpec(password);
                    SecretKey key = keyFact.generateSecret(pbeSpec);
                    mac.init(key, defParams);
                    return new MacCalculator(this, algorithm, pbeParams, mac, password){
                        final /* synthetic */ 1 this$1;
                        private final /* synthetic */ ASN1ObjectIdentifier val$algorithm;
                        private final /* synthetic */ PKCS12PBEParams val$pbeParams;
                        private final /* synthetic */ Mac val$mac;
                        private final /* synthetic */ char[] val$password;
                        {
                            this.this$1 = var1_1;
                            this.val$algorithm = aSN1ObjectIdentifier;
                            this.val$pbeParams = pKCS12PBEParams;
                            this.val$mac = mac;
                            this.val$password = cArray;
                        }

                        public AlgorithmIdentifier getAlgorithmIdentifier() {
                            return new AlgorithmIdentifier(this.val$algorithm, (ASN1Encodable)this.val$pbeParams);
                        }

                        public OutputStream getOutputStream() {
                            return new MacOutputStream(this.val$mac);
                        }

                        public byte[] getMac() {
                            return this.val$mac.doFinal();
                        }

                        public GenericKey getKey() {
                            return new GenericKey(this.getAlgorithmIdentifier(), PKCS12ParametersGenerator.PKCS12PasswordToBytes(this.val$password));
                        }
                    };
                }
                catch (Exception e) {
                    throw new OperatorCreationException("unable to create MAC calculator: " + e.getMessage(), e);
                }
            }

            public AlgorithmIdentifier getDigestAlgorithmIdentifier() {
                return new AlgorithmIdentifier(algorithmIdentifier.getAlgorithm(), (ASN1Encodable)DERNull.INSTANCE);
            }
        };
    }
}

