/*
 * Decompiled with CFR 0.152.
 */
package org.kg.bouncycastle.pkcs.bc;

import java.io.InputStream;
import org.kg.bouncycastle.asn1.pkcs.PKCS12PBEParams;
import org.kg.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.kg.bouncycastle.crypto.CipherParameters;
import org.kg.bouncycastle.crypto.ExtendedDigest;
import org.kg.bouncycastle.crypto.digests.SHA1Digest;
import org.kg.bouncycastle.crypto.generators.PKCS12ParametersGenerator;
import org.kg.bouncycastle.crypto.io.CipherInputStream;
import org.kg.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import org.kg.bouncycastle.operator.GenericKey;
import org.kg.bouncycastle.operator.InputDecryptor;
import org.kg.bouncycastle.operator.InputDecryptorProvider;
import org.kg.bouncycastle.pkcs.bc.PKCS12PBEUtils;

public class BcPKCS12PBEInputDecryptorProviderBuilder {
    private ExtendedDigest digest;

    public BcPKCS12PBEInputDecryptorProviderBuilder() {
        this(new SHA1Digest());
    }

    public BcPKCS12PBEInputDecryptorProviderBuilder(ExtendedDigest digest) {
        this.digest = digest;
    }

    public InputDecryptorProvider build(final char[] password) {
        return new InputDecryptorProvider(){

            public InputDecryptor get(AlgorithmIdentifier algorithmIdentifier) {
                PaddedBufferedBlockCipher engine = PKCS12PBEUtils.getEngine(algorithmIdentifier.getAlgorithm());
                PKCS12PBEParams pbeParams = PKCS12PBEParams.getInstance(algorithmIdentifier.getParameters());
                CipherParameters params = PKCS12PBEUtils.createCipherParameters(algorithmIdentifier.getAlgorithm(), BcPKCS12PBEInputDecryptorProviderBuilder.this.digest, engine.getBlockSize(), pbeParams, password);
                engine.init(false, params);
                return new InputDecryptor(this, algorithmIdentifier, engine, password){
                    final /* synthetic */ 1 this$1;
                    private final /* synthetic */ AlgorithmIdentifier val$algorithmIdentifier;
                    private final /* synthetic */ PaddedBufferedBlockCipher val$engine;
                    private final /* synthetic */ char[] val$password;
                    {
                        this.this$1 = var1_1;
                        this.val$algorithmIdentifier = algorithmIdentifier;
                        this.val$engine = paddedBufferedBlockCipher;
                        this.val$password = cArray;
                    }

                    public AlgorithmIdentifier getAlgorithmIdentifier() {
                        return this.val$algorithmIdentifier;
                    }

                    public InputStream getInputStream(InputStream input) {
                        return new CipherInputStream(input, this.val$engine);
                    }

                    public GenericKey getKey() {
                        return new GenericKey(PKCS12ParametersGenerator.PKCS12PasswordToBytes(this.val$password));
                    }
                };
            }
        };
    }
}

