/*
 * Decompiled with CFR 0.152.
 */
package org.kg.bouncycastle.operator.bc;

import java.security.SecureRandom;
import org.kg.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.kg.bouncycastle.crypto.InvalidCipherTextException;
import org.kg.bouncycastle.crypto.Wrapper;
import org.kg.bouncycastle.crypto.params.KeyParameter;
import org.kg.bouncycastle.operator.GenericKey;
import org.kg.bouncycastle.operator.OperatorException;
import org.kg.bouncycastle.operator.SymmetricKeyUnwrapper;

public class BcSymmetricKeyUnwrapper
extends SymmetricKeyUnwrapper {
    private SecureRandom random;
    private Wrapper wrapper;
    private KeyParameter wrappingKey;

    public BcSymmetricKeyUnwrapper(AlgorithmIdentifier wrappingAlgorithm, Wrapper wrapper, KeyParameter wrappingKey) {
        super(wrappingAlgorithm);
        this.wrapper = wrapper;
        this.wrappingKey = wrappingKey;
    }

    public BcSymmetricKeyUnwrapper setSecureRandom(SecureRandom random) {
        this.random = random;
        return this;
    }

    public GenericKey generateUnwrappedKey(AlgorithmIdentifier encryptedKeyAlgorithm, byte[] encryptedKey) throws OperatorException {
        this.wrapper.init(false, this.wrappingKey);
        try {
            return new GenericKey(encryptedKeyAlgorithm, this.wrapper.unwrap(encryptedKey, 0, encryptedKey.length));
        }
        catch (InvalidCipherTextException e) {
            throw new OperatorException("unable to unwrap key: " + e.getMessage(), e);
        }
    }
}

