/*
 * Decompiled with CFR 0.152.
 */
package org.kg.bouncycastle.math.ec;

import java.math.BigInteger;
import org.kg.bouncycastle.math.ec.ECConstants;
import org.kg.bouncycastle.util.Arrays;

class IntArray {
    private static final int[] INTERLEAVE_TABLE;
    private static final String ZEROES = "00000000000000000000000000000000";
    private static final byte[] bitLengths;
    private int[] m_ints;

    static {
        int[] nArray = new int[256];
        nArray[1] = 1;
        nArray[2] = 4;
        nArray[3] = 5;
        nArray[4] = 16;
        nArray[5] = 17;
        nArray[6] = 20;
        nArray[7] = 21;
        nArray[8] = 64;
        nArray[9] = 65;
        nArray[10] = 68;
        nArray[11] = 69;
        nArray[12] = 80;
        nArray[13] = 81;
        nArray[14] = 84;
        nArray[15] = 85;
        nArray[16] = 256;
        nArray[17] = 257;
        nArray[18] = 260;
        nArray[19] = 261;
        nArray[20] = 272;
        nArray[21] = 273;
        nArray[22] = 276;
        nArray[23] = 277;
        nArray[24] = 320;
        nArray[25] = 321;
        nArray[26] = 324;
        nArray[27] = 325;
        nArray[28] = 336;
        nArray[29] = 337;
        nArray[30] = 340;
        nArray[31] = 341;
        nArray[32] = 1024;
        nArray[33] = 1025;
        nArray[34] = 1028;
        nArray[35] = 1029;
        nArray[36] = 1040;
        nArray[37] = 1041;
        nArray[38] = 1044;
        nArray[39] = 1045;
        nArray[40] = 1088;
        nArray[41] = 1089;
        nArray[42] = 1092;
        nArray[43] = 1093;
        nArray[44] = 1104;
        nArray[45] = 1105;
        nArray[46] = 1108;
        nArray[47] = 1109;
        nArray[48] = 1280;
        nArray[49] = 1281;
        nArray[50] = 1284;
        nArray[51] = 1285;
        nArray[52] = 1296;
        nArray[53] = 1297;
        nArray[54] = 1300;
        nArray[55] = 1301;
        nArray[56] = 1344;
        nArray[57] = 1345;
        nArray[58] = 1348;
        nArray[59] = 1349;
        nArray[60] = 1360;
        nArray[61] = 1361;
        nArray[62] = 1364;
        nArray[63] = 1365;
        nArray[64] = 4096;
        nArray[65] = 4097;
        nArray[66] = 4100;
        nArray[67] = 4101;
        nArray[68] = 4112;
        nArray[69] = 4113;
        nArray[70] = 4116;
        nArray[71] = 4117;
        nArray[72] = 4160;
        nArray[73] = 4161;
        nArray[74] = 4164;
        nArray[75] = 4165;
        nArray[76] = 4176;
        nArray[77] = 4177;
        nArray[78] = 4180;
        nArray[79] = 4181;
        nArray[80] = 4352;
        nArray[81] = 4353;
        nArray[82] = 4356;
        nArray[83] = 4357;
        nArray[84] = 4368;
        nArray[85] = 4369;
        nArray[86] = 4372;
        nArray[87] = 4373;
        nArray[88] = 4416;
        nArray[89] = 4417;
        nArray[90] = 4420;
        nArray[91] = 4421;
        nArray[92] = 4432;
        nArray[93] = 4433;
        nArray[94] = 4436;
        nArray[95] = 4437;
        nArray[96] = 5120;
        nArray[97] = 5121;
        nArray[98] = 5124;
        nArray[99] = 5125;
        nArray[100] = 5136;
        nArray[101] = 5137;
        nArray[102] = 5140;
        nArray[103] = 5141;
        nArray[104] = 5184;
        nArray[105] = 5185;
        nArray[106] = 5188;
        nArray[107] = 5189;
        nArray[108] = 5200;
        nArray[109] = 5201;
        nArray[110] = 5204;
        nArray[111] = 5205;
        nArray[112] = 5376;
        nArray[113] = 5377;
        nArray[114] = 5380;
        nArray[115] = 5381;
        nArray[116] = 5392;
        nArray[117] = 5393;
        nArray[118] = 5396;
        nArray[119] = 5397;
        nArray[120] = 5440;
        nArray[121] = 5441;
        nArray[122] = 5444;
        nArray[123] = 5445;
        nArray[124] = 5456;
        nArray[125] = 5457;
        nArray[126] = 5460;
        nArray[127] = 5461;
        nArray[128] = 16384;
        nArray[129] = 16385;
        nArray[130] = 16388;
        nArray[131] = 16389;
        nArray[132] = 16400;
        nArray[133] = 16401;
        nArray[134] = 16404;
        nArray[135] = 16405;
        nArray[136] = 16448;
        nArray[137] = 16449;
        nArray[138] = 16452;
        nArray[139] = 16453;
        nArray[140] = 16464;
        nArray[141] = 16465;
        nArray[142] = 16468;
        nArray[143] = 16469;
        nArray[144] = 16640;
        nArray[145] = 16641;
        nArray[146] = 16644;
        nArray[147] = 16645;
        nArray[148] = 16656;
        nArray[149] = 16657;
        nArray[150] = 16660;
        nArray[151] = 16661;
        nArray[152] = 16704;
        nArray[153] = 16705;
        nArray[154] = 16708;
        nArray[155] = 16709;
        nArray[156] = 16720;
        nArray[157] = 16721;
        nArray[158] = 16724;
        nArray[159] = 16725;
        nArray[160] = 17408;
        nArray[161] = 17409;
        nArray[162] = 17412;
        nArray[163] = 17413;
        nArray[164] = 17424;
        nArray[165] = 17425;
        nArray[166] = 17428;
        nArray[167] = 17429;
        nArray[168] = 17472;
        nArray[169] = 17473;
        nArray[170] = 17476;
        nArray[171] = 17477;
        nArray[172] = 17488;
        nArray[173] = 17489;
        nArray[174] = 17492;
        nArray[175] = 17493;
        nArray[176] = 17664;
        nArray[177] = 17665;
        nArray[178] = 17668;
        nArray[179] = 17669;
        nArray[180] = 17680;
        nArray[181] = 17681;
        nArray[182] = 17684;
        nArray[183] = 17685;
        nArray[184] = 17728;
        nArray[185] = 17729;
        nArray[186] = 17732;
        nArray[187] = 17733;
        nArray[188] = 17744;
        nArray[189] = 17745;
        nArray[190] = 17748;
        nArray[191] = 17749;
        nArray[192] = 20480;
        nArray[193] = 20481;
        nArray[194] = 20484;
        nArray[195] = 20485;
        nArray[196] = 20496;
        nArray[197] = 20497;
        nArray[198] = 20500;
        nArray[199] = 20501;
        nArray[200] = 20544;
        nArray[201] = 20545;
        nArray[202] = 20548;
        nArray[203] = 20549;
        nArray[204] = 20560;
        nArray[205] = 20561;
        nArray[206] = 20564;
        nArray[207] = 20565;
        nArray[208] = 20736;
        nArray[209] = 20737;
        nArray[210] = 20740;
        nArray[211] = 20741;
        nArray[212] = 20752;
        nArray[213] = 20753;
        nArray[214] = 20756;
        nArray[215] = 20757;
        nArray[216] = 20800;
        nArray[217] = 20801;
        nArray[218] = 20804;
        nArray[219] = 20805;
        nArray[220] = 20816;
        nArray[221] = 20817;
        nArray[222] = 20820;
        nArray[223] = 20821;
        nArray[224] = 21504;
        nArray[225] = 21505;
        nArray[226] = 21508;
        nArray[227] = 21509;
        nArray[228] = 21520;
        nArray[229] = 21521;
        nArray[230] = 21524;
        nArray[231] = 21525;
        nArray[232] = 21568;
        nArray[233] = 21569;
        nArray[234] = 21572;
        nArray[235] = 21573;
        nArray[236] = 21584;
        nArray[237] = 21585;
        nArray[238] = 21588;
        nArray[239] = 21589;
        nArray[240] = 21760;
        nArray[241] = 21761;
        nArray[242] = 21764;
        nArray[243] = 21765;
        nArray[244] = 21776;
        nArray[245] = 21777;
        nArray[246] = 21780;
        nArray[247] = 21781;
        nArray[248] = 21824;
        nArray[249] = 21825;
        nArray[250] = 21828;
        nArray[251] = 21829;
        nArray[252] = 21840;
        nArray[253] = 21841;
        nArray[254] = 21844;
        nArray[255] = 21845;
        INTERLEAVE_TABLE = nArray;
        byte[] byArray = new byte[256];
        byArray[1] = 1;
        byArray[2] = 2;
        byArray[3] = 2;
        byArray[4] = 3;
        byArray[5] = 3;
        byArray[6] = 3;
        byArray[7] = 3;
        byArray[8] = 4;
        byArray[9] = 4;
        byArray[10] = 4;
        byArray[11] = 4;
        byArray[12] = 4;
        byArray[13] = 4;
        byArray[14] = 4;
        byArray[15] = 4;
        byArray[16] = 5;
        byArray[17] = 5;
        byArray[18] = 5;
        byArray[19] = 5;
        byArray[20] = 5;
        byArray[21] = 5;
        byArray[22] = 5;
        byArray[23] = 5;
        byArray[24] = 5;
        byArray[25] = 5;
        byArray[26] = 5;
        byArray[27] = 5;
        byArray[28] = 5;
        byArray[29] = 5;
        byArray[30] = 5;
        byArray[31] = 5;
        byArray[32] = 6;
        byArray[33] = 6;
        byArray[34] = 6;
        byArray[35] = 6;
        byArray[36] = 6;
        byArray[37] = 6;
        byArray[38] = 6;
        byArray[39] = 6;
        byArray[40] = 6;
        byArray[41] = 6;
        byArray[42] = 6;
        byArray[43] = 6;
        byArray[44] = 6;
        byArray[45] = 6;
        byArray[46] = 6;
        byArray[47] = 6;
        byArray[48] = 6;
        byArray[49] = 6;
        byArray[50] = 6;
        byArray[51] = 6;
        byArray[52] = 6;
        byArray[53] = 6;
        byArray[54] = 6;
        byArray[55] = 6;
        byArray[56] = 6;
        byArray[57] = 6;
        byArray[58] = 6;
        byArray[59] = 6;
        byArray[60] = 6;
        byArray[61] = 6;
        byArray[62] = 6;
        byArray[63] = 6;
        byArray[64] = 7;
        byArray[65] = 7;
        byArray[66] = 7;
        byArray[67] = 7;
        byArray[68] = 7;
        byArray[69] = 7;
        byArray[70] = 7;
        byArray[71] = 7;
        byArray[72] = 7;
        byArray[73] = 7;
        byArray[74] = 7;
        byArray[75] = 7;
        byArray[76] = 7;
        byArray[77] = 7;
        byArray[78] = 7;
        byArray[79] = 7;
        byArray[80] = 7;
        byArray[81] = 7;
        byArray[82] = 7;
        byArray[83] = 7;
        byArray[84] = 7;
        byArray[85] = 7;
        byArray[86] = 7;
        byArray[87] = 7;
        byArray[88] = 7;
        byArray[89] = 7;
        byArray[90] = 7;
        byArray[91] = 7;
        byArray[92] = 7;
        byArray[93] = 7;
        byArray[94] = 7;
        byArray[95] = 7;
        byArray[96] = 7;
        byArray[97] = 7;
        byArray[98] = 7;
        byArray[99] = 7;
        byArray[100] = 7;
        byArray[101] = 7;
        byArray[102] = 7;
        byArray[103] = 7;
        byArray[104] = 7;
        byArray[105] = 7;
        byArray[106] = 7;
        byArray[107] = 7;
        byArray[108] = 7;
        byArray[109] = 7;
        byArray[110] = 7;
        byArray[111] = 7;
        byArray[112] = 7;
        byArray[113] = 7;
        byArray[114] = 7;
        byArray[115] = 7;
        byArray[116] = 7;
        byArray[117] = 7;
        byArray[118] = 7;
        byArray[119] = 7;
        byArray[120] = 7;
        byArray[121] = 7;
        byArray[122] = 7;
        byArray[123] = 7;
        byArray[124] = 7;
        byArray[125] = 7;
        byArray[126] = 7;
        byArray[127] = 7;
        byArray[128] = 8;
        byArray[129] = 8;
        byArray[130] = 8;
        byArray[131] = 8;
        byArray[132] = 8;
        byArray[133] = 8;
        byArray[134] = 8;
        byArray[135] = 8;
        byArray[136] = 8;
        byArray[137] = 8;
        byArray[138] = 8;
        byArray[139] = 8;
        byArray[140] = 8;
        byArray[141] = 8;
        byArray[142] = 8;
        byArray[143] = 8;
        byArray[144] = 8;
        byArray[145] = 8;
        byArray[146] = 8;
        byArray[147] = 8;
        byArray[148] = 8;
        byArray[149] = 8;
        byArray[150] = 8;
        byArray[151] = 8;
        byArray[152] = 8;
        byArray[153] = 8;
        byArray[154] = 8;
        byArray[155] = 8;
        byArray[156] = 8;
        byArray[157] = 8;
        byArray[158] = 8;
        byArray[159] = 8;
        byArray[160] = 8;
        byArray[161] = 8;
        byArray[162] = 8;
        byArray[163] = 8;
        byArray[164] = 8;
        byArray[165] = 8;
        byArray[166] = 8;
        byArray[167] = 8;
        byArray[168] = 8;
        byArray[169] = 8;
        byArray[170] = 8;
        byArray[171] = 8;
        byArray[172] = 8;
        byArray[173] = 8;
        byArray[174] = 8;
        byArray[175] = 8;
        byArray[176] = 8;
        byArray[177] = 8;
        byArray[178] = 8;
        byArray[179] = 8;
        byArray[180] = 8;
        byArray[181] = 8;
        byArray[182] = 8;
        byArray[183] = 8;
        byArray[184] = 8;
        byArray[185] = 8;
        byArray[186] = 8;
        byArray[187] = 8;
        byArray[188] = 8;
        byArray[189] = 8;
        byArray[190] = 8;
        byArray[191] = 8;
        byArray[192] = 8;
        byArray[193] = 8;
        byArray[194] = 8;
        byArray[195] = 8;
        byArray[196] = 8;
        byArray[197] = 8;
        byArray[198] = 8;
        byArray[199] = 8;
        byArray[200] = 8;
        byArray[201] = 8;
        byArray[202] = 8;
        byArray[203] = 8;
        byArray[204] = 8;
        byArray[205] = 8;
        byArray[206] = 8;
        byArray[207] = 8;
        byArray[208] = 8;
        byArray[209] = 8;
        byArray[210] = 8;
        byArray[211] = 8;
        byArray[212] = 8;
        byArray[213] = 8;
        byArray[214] = 8;
        byArray[215] = 8;
        byArray[216] = 8;
        byArray[217] = 8;
        byArray[218] = 8;
        byArray[219] = 8;
        byArray[220] = 8;
        byArray[221] = 8;
        byArray[222] = 8;
        byArray[223] = 8;
        byArray[224] = 8;
        byArray[225] = 8;
        byArray[226] = 8;
        byArray[227] = 8;
        byArray[228] = 8;
        byArray[229] = 8;
        byArray[230] = 8;
        byArray[231] = 8;
        byArray[232] = 8;
        byArray[233] = 8;
        byArray[234] = 8;
        byArray[235] = 8;
        byArray[236] = 8;
        byArray[237] = 8;
        byArray[238] = 8;
        byArray[239] = 8;
        byArray[240] = 8;
        byArray[241] = 8;
        byArray[242] = 8;
        byArray[243] = 8;
        byArray[244] = 8;
        byArray[245] = 8;
        byArray[246] = 8;
        byArray[247] = 8;
        byArray[248] = 8;
        byArray[249] = 8;
        byArray[250] = 8;
        byArray[251] = 8;
        byArray[252] = 8;
        byArray[253] = 8;
        byArray[254] = 8;
        byArray[255] = 8;
        bitLengths = byArray;
    }

    public static int getWordLength(int bits) {
        return bits + 31 >>> 5;
    }

    public IntArray(int intLen) {
        this.m_ints = new int[intLen];
    }

    public IntArray(int[] ints) {
        this.m_ints = ints;
    }

    public IntArray(BigInteger bigInt) {
        if (bigInt == null || bigInt.signum() < 0) {
            throw new IllegalArgumentException("invalid F2m field value");
        }
        if (bigInt.signum() == 0) {
            this.m_ints = new int[1];
            return;
        }
        byte[] barr = bigInt.toByteArray();
        int barrLen = barr.length;
        int barrStart = 0;
        if (barr[0] == 0) {
            --barrLen;
            barrStart = 1;
        }
        int intLen = (barrLen + 3) / 4;
        this.m_ints = new int[intLen];
        int iarrJ = intLen - 1;
        int rem = barrLen % 4 + barrStart;
        int temp = 0;
        int barrI = barrStart;
        if (barrStart < rem) {
            while (barrI < rem) {
                temp <<= 8;
                int barrBarrI = barr[barrI] & 0xFF;
                temp |= barrBarrI;
                ++barrI;
            }
            this.m_ints[iarrJ--] = temp;
        }
        while (iarrJ >= 0) {
            temp = 0;
            int i = 0;
            while (i < 4) {
                temp <<= 8;
                int barrBarrI = barr[barrI++] & 0xFF;
                temp |= barrBarrI;
                ++i;
            }
            this.m_ints[iarrJ] = temp;
            --iarrJ;
        }
    }

    public boolean isZero() {
        int[] a = this.m_ints;
        int i = 0;
        while (i < a.length) {
            if (a[i] != 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int getUsedLength() {
        return this.getUsedLengthFrom(this.m_ints.length);
    }

    public int getUsedLengthFrom(int from) {
        int[] a = this.m_ints;
        if ((from = Math.min(from, a.length)) < 1) {
            return 0;
        }
        if (a[0] != 0) {
            while (a[--from] == 0) {
            }
            return from + 1;
        }
        do {
            if (a[--from] == 0) continue;
            return from + 1;
        } while (from > 0);
        return 0;
    }

    public int degree() {
        int w;
        int i = this.m_ints.length;
        do {
            if (i != 0) continue;
            return 0;
        } while ((w = this.m_ints[--i]) == 0);
        return (i << 5) + IntArray.bitLength(w);
    }

    private static int bitLength(int w) {
        int t = w >>> 16;
        if (t == 0) {
            t = w >>> 8;
            return t == 0 ? bitLengths[w] : 8 + bitLengths[t];
        }
        int u = t >>> 8;
        return u == 0 ? 16 + bitLengths[t] : 24 + bitLengths[u];
    }

    private int[] resizedInts(int newLen) {
        int[] newInts = new int[newLen];
        System.arraycopy(this.m_ints, 0, newInts, 0, Math.min(this.m_ints.length, newLen));
        return newInts;
    }

    public BigInteger toBigInteger() {
        int usedLen = this.getUsedLength();
        if (usedLen == 0) {
            return ECConstants.ZERO;
        }
        int highestInt = this.m_ints[usedLen - 1];
        byte[] temp = new byte[4];
        int barrI = 0;
        boolean trailingZeroBytesDone = false;
        int j = 3;
        while (j >= 0) {
            byte thisByte = (byte)(highestInt >>> 8 * j);
            if (trailingZeroBytesDone || thisByte != 0) {
                trailingZeroBytesDone = true;
                temp[barrI++] = thisByte;
            }
            --j;
        }
        int barrLen = 4 * (usedLen - 1) + barrI;
        byte[] barr = new byte[barrLen];
        int j2 = 0;
        while (j2 < barrI) {
            barr[j2] = temp[j2];
            ++j2;
        }
        int iarrJ = usedLen - 2;
        while (iarrJ >= 0) {
            int j3 = 3;
            while (j3 >= 0) {
                barr[barrI++] = (byte)(this.m_ints[iarrJ] >>> 8 * j3);
                --j3;
            }
            --iarrJ;
        }
        return new BigInteger(1, barr);
    }

    private static int shiftLeft(int[] x, int count) {
        int prev = 0;
        int i = 0;
        while (i < count) {
            int next = x[i];
            x[i] = next << 1 | prev;
            prev = next >>> 31;
            ++i;
        }
        return prev;
    }

    public void addOneShifted(int shift) {
        if (shift >= this.m_ints.length) {
            this.m_ints = this.resizedInts(shift + 1);
        }
        int n = shift;
        this.m_ints[n] = this.m_ints[n] ^ 1;
    }

    private void addShiftedByBits(IntArray other, int bits) {
        int words = bits >>> 5;
        int shift = bits & 0x1F;
        if (shift == 0) {
            this.addShiftedByWords(other, words);
            return;
        }
        int otherUsedLen = other.getUsedLength();
        if (otherUsedLen == 0) {
            return;
        }
        int minLen = otherUsedLen + words + 1;
        if (minLen > this.m_ints.length) {
            this.m_ints = this.resizedInts(minLen);
        }
        int shiftInv = 32 - shift;
        int prev = 0;
        int i = 0;
        while (i < otherUsedLen) {
            int next = other.m_ints[i];
            int n = i + words;
            this.m_ints[n] = this.m_ints[n] ^ (next << shift | prev);
            prev = next >>> shiftInv;
            ++i;
        }
        int n = otherUsedLen + words;
        this.m_ints[n] = this.m_ints[n] ^ prev;
    }

    private static int addShiftedByBits(int[] x, int[] y, int count, int shift) {
        int shiftInv = 32 - shift;
        int prev = 0;
        int i = 0;
        while (i < count) {
            int next = y[i];
            int n = i++;
            x[n] = x[n] ^ (next << shift | prev);
            prev = next >>> shiftInv;
        }
        return prev;
    }

    private static int addShiftedByBits(int[] x, int xOff, int[] y, int yOff, int count, int shift) {
        int shiftInv = 32 - shift;
        int prev = 0;
        int i = 0;
        while (i < count) {
            int next = y[yOff + i];
            int n = xOff + i;
            x[n] = x[n] ^ (next << shift | prev);
            prev = next >>> shiftInv;
            ++i;
        }
        return prev;
    }

    public void addShiftedByWords(IntArray other, int words) {
        int otherUsedLen = other.getUsedLength();
        if (otherUsedLen == 0) {
            return;
        }
        int minLen = otherUsedLen + words;
        if (minLen > this.m_ints.length) {
            this.m_ints = this.resizedInts(minLen);
        }
        int i = 0;
        while (i < otherUsedLen) {
            int n = words + i;
            this.m_ints[n] = this.m_ints[n] ^ other.m_ints[i];
            ++i;
        }
    }

    private static void addShiftedByWords(int[] x, int xOff, int[] y, int count) {
        int i = 0;
        while (i < count) {
            int n = xOff + i;
            x[n] = x[n] ^ y[i];
            ++i;
        }
    }

    private static void add(int[] x, int[] y, int count) {
        int i = 0;
        while (i < count) {
            int n = i;
            x[n] = x[n] ^ y[i];
            ++i;
        }
    }

    private static void distribute(int[] x, int dst1, int dst2, int src, int count) {
        int i = 0;
        while (i < count) {
            int v = x[src + i];
            int n = dst1 + i;
            x[n] = x[n] ^ v;
            int n2 = dst2 + i;
            x[n2] = x[n2] ^ v;
            ++i;
        }
    }

    public int getLength() {
        return this.m_ints.length;
    }

    public void flipWord(int bit, int word) {
        int n = bit >>> 5;
        int len = this.m_ints.length;
        if (n < len) {
            int shift = bit & 0x1F;
            if (shift == 0) {
                int n2 = n;
                this.m_ints[n2] = this.m_ints[n2] ^ word;
            } else {
                int n3 = n++;
                this.m_ints[n3] = this.m_ints[n3] ^ word << shift;
                if (n < len) {
                    int n4 = n;
                    this.m_ints[n4] = this.m_ints[n4] ^ word >>> 32 - shift;
                }
            }
        }
    }

    public int getWord(int bit) {
        int n = bit >>> 5;
        int len = this.m_ints.length;
        if (n >= len) {
            return 0;
        }
        int shift = bit & 0x1F;
        if (shift == 0) {
            return this.m_ints[n];
        }
        int result = this.m_ints[n] >>> shift;
        if (++n < len) {
            result |= this.m_ints[n] << 32 - shift;
        }
        return result;
    }

    public boolean testBitZero() {
        return this.m_ints.length > 0 && (this.m_ints[0] & 1) != 0;
    }

    public boolean testBit(int n) {
        int theInt = n >>> 5;
        int theBit = n & 0x1F;
        int tester = 1 << theBit;
        return (this.m_ints[theInt] & tester) != 0;
    }

    public void flipBit(int n) {
        int theInt = n >>> 5;
        int theBit = n & 0x1F;
        int flipper = 1 << theBit;
        int n2 = theInt;
        this.m_ints[n2] = this.m_ints[n2] ^ flipper;
    }

    public void setBit(int n) {
        int theInt = n >>> 5;
        int theBit = n & 0x1F;
        int setter = 1 << theBit;
        int n2 = theInt;
        this.m_ints[n2] = this.m_ints[n2] | setter;
    }

    public void clearBit(int n) {
        int theInt = n >>> 5;
        int theBit = n & 0x1F;
        int setter = 1 << theBit;
        int n2 = theInt;
        this.m_ints[n2] = this.m_ints[n2] & ~setter;
    }

    public IntArray multiply(IntArray other, int m) {
        int aLen = this.getUsedLength();
        if (aLen == 0) {
            return new IntArray(1);
        }
        int bLen = other.getUsedLength();
        if (bLen == 0) {
            return new IntArray(1);
        }
        IntArray A = this;
        IntArray B = other;
        if (aLen > bLen) {
            A = other;
            B = this;
            int tmp = aLen;
            aLen = bLen;
            bLen = tmp;
        }
        if (aLen == 1) {
            int a = A.m_ints[0];
            int[] b = B.m_ints;
            int[] c = new int[aLen + bLen];
            if ((a & 1) != 0) {
                IntArray.add(c, b, bLen);
            }
            int k = 1;
            while ((a >>>= 1) != 0) {
                if ((a & 1) != 0) {
                    IntArray.addShiftedByBits(c, b, bLen, k);
                }
                ++k;
            }
            return new IntArray(c);
        }
        int complexity = aLen <= 8 ? 1 : 2;
        int width = 1 << complexity;
        int shifts = 32 >>> complexity;
        int bExt = bLen;
        if (B.m_ints[bLen - 1] >>> 33 - shifts != 0) {
            ++bExt;
        }
        int cLen = bExt + aLen;
        int[] c = new int[cLen << width];
        System.arraycopy(B.m_ints, 0, c, 0, bLen);
        IntArray.interleave(A.m_ints, 0, c, bExt, aLen, complexity);
        int[] ci = new int[1 << width];
        int i = 1;
        while (i < ci.length) {
            ci[i] = ci[i - 1] + cLen;
            ++i;
        }
        int MASK = (1 << width) - 1;
        int k = 0;
        while (true) {
            int aPos = 0;
            while (aPos < aLen) {
                int index = c[bExt + aPos] >>> k & MASK;
                if (index != 0) {
                    IntArray.addShiftedByWords(c, aPos + ci[index], c, bExt);
                }
                ++aPos;
            }
            if ((k += width) >= 32) break;
            IntArray.shiftLeft(c, bExt);
        }
        int ciPos = ci.length;
        int pow2 = ciPos >>> 1;
        int offset = 32;
        while (--ciPos > 1) {
            if (ciPos == pow2) {
                IntArray.addShiftedByBits(c, ci[1], c, ci[pow2], cLen, offset -= shifts);
                pow2 >>>= 1;
                continue;
            }
            IntArray.distribute(c, ci[pow2], ci[ciPos - pow2], ci[ciPos], cLen);
        }
        IntArray p = new IntArray(cLen);
        System.arraycopy(c, ci[1], p.m_ints, 0, cLen);
        return p;
    }

    public void reduce(int m, int[] ks) {
        int mLen;
        int len = this.getUsedLength();
        if (len < (mLen = m + 31 >>> 5)) {
            return;
        }
        int _2m = m << 1;
        int pos = Math.min(_2m - 2, (len << 5) - 1);
        int kMax = ks[ks.length - 1];
        if (kMax < m - 31) {
            this.reduceWordWise(pos, m, ks);
        } else {
            this.reduceBitWise(pos, m, ks);
        }
        int partial = m & 0x1F;
        if (partial != 0) {
            int n = mLen - 1;
            this.m_ints[n] = this.m_ints[n] & (1 << partial) - 1;
        }
        if (len > mLen) {
            this.m_ints = this.resizedInts(mLen);
        }
    }

    private void reduceBitWise(int from, int m, int[] ks) {
        int i = from;
        while (i >= m) {
            if (this.testBit(i)) {
                int bit = i - m;
                this.flipBit(bit);
                int j = ks.length;
                while (--j >= 0) {
                    this.flipBit(ks[j] + bit);
                }
            }
            --i;
        }
    }

    private void reduceWordWise(int from, int m, int[] ks) {
        int pos;
        int i = pos = m + (from - m & 0xFFFFFFE0);
        while (i >= m) {
            int word = this.getWord(i);
            if (word != 0) {
                int bit = i - m;
                this.flipWord(bit, word);
                int j = ks.length;
                while (--j >= 0) {
                    this.flipWord(ks[j] + bit, word);
                }
            }
            i -= 32;
        }
    }

    public IntArray square(int m) {
        int len = this.getUsedLength();
        if (len == 0) {
            return this;
        }
        int _2len = len << 1;
        int[] r = new int[_2len];
        int pos = 0;
        while (pos < _2len) {
            int mi = this.m_ints[pos >>> 1];
            r[pos++] = IntArray.interleave16(mi & 0xFFFF);
            r[pos++] = IntArray.interleave16(mi >>> 16);
        }
        return new IntArray(r);
    }

    private static void interleave(int[] x, int xOff, int[] z, int zOff, int count, int rounds) {
        int i = 0;
        while (i < count) {
            z[zOff + i] = IntArray.interleave(x[xOff + i], rounds);
            ++i;
        }
    }

    private static int interleave(int x, int rounds) {
        while (--rounds >= 0) {
            x = IntArray.interleave16(x & 0xFFFF) | IntArray.interleave16(x >>> 16) << 1;
        }
        return x;
    }

    private static int interleave16(int n) {
        return INTERLEAVE_TABLE[n & 0xFF] | INTERLEAVE_TABLE[n >>> 8] << 16;
    }

    public IntArray modInverse(int m, int[] ks) {
        int uzDegree = this.degree();
        if (uzDegree == 1) {
            return this;
        }
        IntArray uz = (IntArray)this.clone();
        int t = IntArray.getWordLength(m);
        IntArray vz = new IntArray(t);
        vz.setBit(m);
        vz.setBit(0);
        vz.setBit(ks[0]);
        if (ks.length > 1) {
            vz.setBit(ks[1]);
            vz.setBit(ks[2]);
        }
        IntArray g1z = new IntArray(t);
        g1z.setBit(0);
        IntArray g2z = new IntArray(t);
        while (uzDegree != 0) {
            int j = uzDegree - vz.degree();
            if (j < 0) {
                IntArray uzCopy = uz;
                uz = vz;
                vz = uzCopy;
                IntArray g1zCopy = g1z;
                g1z = g2z;
                g2z = g1zCopy;
                j = -j;
            }
            uz.addShiftedByBits(vz, j);
            uzDegree = uz.degree();
            if (uzDegree == 0) continue;
            g1z.addShiftedByBits(g2z, j);
        }
        return g2z;
    }

    public boolean equals(Object o) {
        if (!(o instanceof IntArray)) {
            return false;
        }
        IntArray other = (IntArray)o;
        int usedLen = this.getUsedLength();
        if (other.getUsedLength() != usedLen) {
            return false;
        }
        int i = 0;
        while (i < usedLen) {
            if (this.m_ints[i] != other.m_ints[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        int usedLen = this.getUsedLength();
        int hash = 1;
        int i = 0;
        while (i < usedLen) {
            hash *= 31;
            hash ^= this.m_ints[i];
            ++i;
        }
        return hash;
    }

    public Object clone() {
        return new IntArray(Arrays.clone(this.m_ints));
    }

    public String toString() {
        int i = this.getUsedLength();
        if (i == 0) {
            return "0";
        }
        StringBuffer sb = new StringBuffer(Integer.toBinaryString(this.m_ints[--i]));
        while (--i >= 0) {
            String s = Integer.toBinaryString(this.m_ints[i]);
            int len = s.length();
            if (len < 32) {
                sb.append(ZEROES.substring(len));
            }
            sb.append(s);
        }
        return sb.toString();
    }
}

