/*
 * Decompiled with CFR 0.152.
 */
package org.kg.bouncycastle.jce.provider;

import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import org.kg.bouncycastle.jce.X509LDAPCertStoreParameters;
import org.kg.bouncycastle.util.Selector;
import org.kg.bouncycastle.util.StoreException;
import org.kg.bouncycastle.x509.X509CertPairStoreSelector;
import org.kg.bouncycastle.x509.X509CertStoreSelector;
import org.kg.bouncycastle.x509.X509CertificatePair;
import org.kg.bouncycastle.x509.X509StoreParameters;
import org.kg.bouncycastle.x509.X509StoreSpi;
import org.kg.bouncycastle.x509.util.LDAPStoreHelper;

public class X509StoreLDAPCerts
extends X509StoreSpi {
    private LDAPStoreHelper helper;
    static /* synthetic */ Class class$0;

    public void engineInit(X509StoreParameters params) {
        if (!(params instanceof X509LDAPCertStoreParameters)) {
            StringBuffer stringBuffer = new StringBuffer("Initialization parameters must be an instance of ");
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.kg.bouncycastle.jce.X509LDAPCertStoreParameters");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            throw new IllegalArgumentException(stringBuffer.append(clazz.getName()).append(".").toString());
        }
        this.helper = new LDAPStoreHelper((X509LDAPCertStoreParameters)params);
    }

    public Collection engineGetMatches(Selector selector) throws StoreException {
        if (!(selector instanceof X509CertStoreSelector)) {
            return Collections.EMPTY_SET;
        }
        X509CertStoreSelector xselector = (X509CertStoreSelector)selector;
        HashSet set = new HashSet();
        if (xselector.getBasicConstraints() > 0) {
            set.addAll(this.helper.getCACertificates(xselector));
            set.addAll(this.getCertificatesFromCrossCertificatePairs(xselector));
        } else if (xselector.getBasicConstraints() == -2) {
            set.addAll(this.helper.getUserCertificates(xselector));
        } else {
            set.addAll(this.helper.getUserCertificates(xselector));
            set.addAll(this.helper.getCACertificates(xselector));
            set.addAll(this.getCertificatesFromCrossCertificatePairs(xselector));
        }
        return set;
    }

    private Collection getCertificatesFromCrossCertificatePairs(X509CertStoreSelector xselector) throws StoreException {
        HashSet set = new HashSet();
        X509CertPairStoreSelector ps = new X509CertPairStoreSelector();
        ps.setForwardSelector(xselector);
        ps.setReverseSelector(new X509CertStoreSelector());
        HashSet crossCerts = new HashSet(this.helper.getCrossCertificatePairs(ps));
        HashSet<X509Certificate> forward = new HashSet<X509Certificate>();
        HashSet<X509Certificate> reverse = new HashSet<X509Certificate>();
        Iterator it = crossCerts.iterator();
        while (it.hasNext()) {
            X509CertificatePair pair = (X509CertificatePair)it.next();
            if (pair.getForward() != null) {
                forward.add(pair.getForward());
            }
            if (pair.getReverse() == null) continue;
            reverse.add(pair.getReverse());
        }
        set.addAll(forward);
        set.addAll(reverse);
        return set;
    }
}

