/*
 * Decompiled with CFR 0.152.
 */
package org.kg.bouncycastle.jcajce.provider.symmetric;

import org.kg.bouncycastle.crypto.BlockCipher;
import org.kg.bouncycastle.crypto.CipherKeyGenerator;
import org.kg.bouncycastle.crypto.engines.SerpentEngine;
import org.kg.bouncycastle.crypto.engines.TwofishEngine;
import org.kg.bouncycastle.crypto.generators.Poly1305KeyGenerator;
import org.kg.bouncycastle.crypto.macs.GMac;
import org.kg.bouncycastle.crypto.modes.GCMBlockCipher;
import org.kg.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import org.kg.bouncycastle.jcajce.provider.symmetric.SymmetricAlgorithmProvider;
import org.kg.bouncycastle.jcajce.provider.symmetric.util.BaseBlockCipher;
import org.kg.bouncycastle.jcajce.provider.symmetric.util.BaseKeyGenerator;
import org.kg.bouncycastle.jcajce.provider.symmetric.util.BaseMac;
import org.kg.bouncycastle.jcajce.provider.symmetric.util.BlockCipherProvider;
import org.kg.bouncycastle.jcajce.provider.symmetric.util.IvAlgorithmParameters;

public final class Serpent {
    static /* synthetic */ Class class$0;

    private Serpent() {
    }

    public static class AlgParams
    extends IvAlgorithmParameters {
        protected String engineToString() {
            return "Serpent IV";
        }
    }

    public static class ECB
    extends BaseBlockCipher {
        public ECB() {
            super(new BlockCipherProvider(){

                public BlockCipher get() {
                    return new SerpentEngine();
                }
            });
        }
    }

    public static class KeyGen
    extends BaseKeyGenerator {
        public KeyGen() {
            super("Serpent", 192, new CipherKeyGenerator());
        }
    }

    public static class Mappings
    extends SymmetricAlgorithmProvider {
        private static final String PREFIX;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.kg.bouncycastle.jcajce.provider.symmetric.Serpent");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            PREFIX = clazz.getName();
        }

        public void configure(ConfigurableProvider provider) {
            provider.addAlgorithm("Cipher.Serpent", String.valueOf(PREFIX) + "$ECB");
            provider.addAlgorithm("KeyGenerator.Serpent", String.valueOf(PREFIX) + "$KeyGen");
            provider.addAlgorithm("AlgorithmParameters.Serpent", String.valueOf(PREFIX) + "$AlgParams");
            this.addGMacAlgorithm(provider, "SERPENT", String.valueOf(PREFIX) + "$SerpentGMAC", String.valueOf(PREFIX) + "$KeyGen");
            this.addPoly1305Algorithm(provider, "SERPENT", String.valueOf(PREFIX) + "$Poly1305", String.valueOf(PREFIX) + "$Poly1305KeyGen");
        }
    }

    public static class Poly1305
    extends BaseMac {
        public Poly1305() {
            super(new org.kg.bouncycastle.crypto.macs.Poly1305(new TwofishEngine()));
        }
    }

    public static class Poly1305KeyGen
    extends BaseKeyGenerator {
        public Poly1305KeyGen() {
            super("Poly1305-Serpent", 256, new Poly1305KeyGenerator());
        }
    }

    public static class SerpentGMAC
    extends BaseMac {
        public SerpentGMAC() {
            super(new GMac(new GCMBlockCipher(new SerpentEngine())));
        }
    }
}

