/*
 * Decompiled with CFR 0.152.
 */
package org.kg.bouncycastle.jcajce.provider.asymmetric.ec;

import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.util.Hashtable;
import org.kg.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.kg.bouncycastle.asn1.x9.ECNamedCurveTable;
import org.kg.bouncycastle.asn1.x9.X9ECParameters;
import org.kg.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.kg.bouncycastle.crypto.generators.ECKeyPairGenerator;
import org.kg.bouncycastle.crypto.params.ECDomainParameters;
import org.kg.bouncycastle.crypto.params.ECKeyGenerationParameters;
import org.kg.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.kg.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.kg.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.kg.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.kg.bouncycastle.jcajce.provider.asymmetric.util.EC5Util;
import org.kg.bouncycastle.jcajce.provider.config.ProviderConfiguration;
import org.kg.bouncycastle.jce.provider.BouncyCastleProvider;
import org.kg.bouncycastle.jce.spec.ECNamedCurveGenParameterSpec;
import org.kg.bouncycastle.jce.spec.ECNamedCurveSpec;
import org.kg.bouncycastle.jce.spec.ECParameterSpec;
import org.kg.bouncycastle.math.ec.ECCurve;
import org.kg.bouncycastle.math.ec.ECPoint;
import org.kg.bouncycastle.util.Integers;

public abstract class KeyPairGeneratorSpi
extends KeyPairGenerator {
    public KeyPairGeneratorSpi(String algorithmName) {
        super(algorithmName);
    }

    public static class EC
    extends KeyPairGeneratorSpi {
        ECKeyGenerationParameters param;
        ECKeyPairGenerator engine = new ECKeyPairGenerator();
        Object ecParams = null;
        int strength = 239;
        int certainty = 50;
        SecureRandom random = new SecureRandom();
        boolean initialised = false;
        String algorithm;
        ProviderConfiguration configuration;
        private static Hashtable ecParameters = new Hashtable();

        static {
            ecParameters.put(Integers.valueOf(192), new ECGenParameterSpec("prime192v1"));
            ecParameters.put(Integers.valueOf(239), new ECGenParameterSpec("prime239v1"));
            ecParameters.put(Integers.valueOf(256), new ECGenParameterSpec("prime256v1"));
            ecParameters.put(Integers.valueOf(224), new ECGenParameterSpec("P-224"));
            ecParameters.put(Integers.valueOf(384), new ECGenParameterSpec("P-384"));
            ecParameters.put(Integers.valueOf(521), new ECGenParameterSpec("P-521"));
        }

        public EC() {
            super("EC");
            this.algorithm = "EC";
            this.configuration = BouncyCastleProvider.CONFIGURATION;
        }

        public EC(String algorithm, ProviderConfiguration configuration) {
            super(algorithm);
            this.algorithm = algorithm;
            this.configuration = configuration;
        }

        public void initialize(int strength, SecureRandom random) {
            this.strength = strength;
            this.random = random;
            ECGenParameterSpec ecParams = (ECGenParameterSpec)ecParameters.get(Integers.valueOf(strength));
            if (ecParams != null) {
                try {
                    this.initialize(ecParams, random);
                }
                catch (InvalidAlgorithmParameterException e) {
                    throw new InvalidParameterException("key size not configurable.");
                }
            } else {
                throw new InvalidParameterException("unknown key size.");
            }
        }

        public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
            if (params instanceof ECParameterSpec) {
                ECParameterSpec p = (ECParameterSpec)params;
                this.ecParams = params;
                this.param = new ECKeyGenerationParameters(new ECDomainParameters(p.getCurve(), p.getG(), p.getN()), random);
                this.engine.init(this.param);
                this.initialised = true;
            } else if (params instanceof java.security.spec.ECParameterSpec) {
                java.security.spec.ECParameterSpec p = (java.security.spec.ECParameterSpec)params;
                this.ecParams = params;
                ECCurve curve = EC5Util.convertCurve(p.getCurve());
                ECPoint g = EC5Util.convertPoint(curve, p.getGenerator(), false);
                this.param = new ECKeyGenerationParameters(new ECDomainParameters(curve, g, p.getOrder(), BigInteger.valueOf(p.getCofactor())), random);
                this.engine.init(this.param);
                this.initialised = true;
            } else if (params instanceof ECGenParameterSpec || params instanceof ECNamedCurveGenParameterSpec) {
                String curveName = params instanceof ECGenParameterSpec ? ((ECGenParameterSpec)params).getName() : ((ECNamedCurveGenParameterSpec)params).getName();
                X9ECParameters ecP = ECNamedCurveTable.getByName(curveName);
                if (ecP == null) {
                    try {
                        ASN1ObjectIdentifier oid = new ASN1ObjectIdentifier(curveName);
                        ecP = ECNamedCurveTable.getByOID(oid);
                        if (ecP == null) {
                            throw new InvalidAlgorithmParameterException("unknown curve OID: " + curveName);
                        }
                    }
                    catch (IllegalArgumentException ex) {
                        throw new InvalidAlgorithmParameterException("unknown curve name: " + curveName);
                    }
                }
                this.ecParams = new ECNamedCurveSpec(curveName, ecP.getCurve(), ecP.getG(), ecP.getN(), ecP.getH(), null);
                java.security.spec.ECParameterSpec p = (java.security.spec.ECParameterSpec)this.ecParams;
                ECCurve curve = EC5Util.convertCurve(p.getCurve());
                ECPoint g = EC5Util.convertPoint(curve, p.getGenerator(), false);
                this.param = new ECKeyGenerationParameters(new ECDomainParameters(curve, g, p.getOrder(), BigInteger.valueOf(p.getCofactor())), random);
                this.engine.init(this.param);
                this.initialised = true;
            } else if (params == null && this.configuration.getEcImplicitlyCa() != null) {
                ECParameterSpec p = this.configuration.getEcImplicitlyCa();
                this.ecParams = params;
                this.param = new ECKeyGenerationParameters(new ECDomainParameters(p.getCurve(), p.getG(), p.getN()), random);
                this.engine.init(this.param);
                this.initialised = true;
            } else {
                if (params == null && this.configuration.getEcImplicitlyCa() == null) {
                    throw new InvalidAlgorithmParameterException("null parameter passed but no implicitCA set");
                }
                throw new InvalidAlgorithmParameterException("parameter object not a ECParameterSpec");
            }
        }

        public KeyPair generateKeyPair() {
            if (!this.initialised) {
                this.initialize(this.strength, new SecureRandom());
            }
            AsymmetricCipherKeyPair pair = this.engine.generateKeyPair();
            ECPublicKeyParameters pub = (ECPublicKeyParameters)pair.getPublic();
            ECPrivateKeyParameters priv = (ECPrivateKeyParameters)pair.getPrivate();
            if (this.ecParams instanceof ECParameterSpec) {
                ECParameterSpec p = (ECParameterSpec)this.ecParams;
                BCECPublicKey pubKey = new BCECPublicKey(this.algorithm, pub, p, this.configuration);
                return new KeyPair(pubKey, new BCECPrivateKey(this.algorithm, priv, pubKey, p, this.configuration));
            }
            if (this.ecParams == null) {
                return new KeyPair(new BCECPublicKey(this.algorithm, pub, this.configuration), new BCECPrivateKey(this.algorithm, priv, this.configuration));
            }
            java.security.spec.ECParameterSpec p = (java.security.spec.ECParameterSpec)this.ecParams;
            BCECPublicKey pubKey = new BCECPublicKey(this.algorithm, pub, p, this.configuration);
            return new KeyPair(pubKey, new BCECPrivateKey(this.algorithm, priv, pubKey, p, this.configuration));
        }
    }

    public static class ECDH
    extends EC {
        public ECDH() {
            super("ECDH", BouncyCastleProvider.CONFIGURATION);
        }
    }

    public static class ECDHC
    extends EC {
        public ECDHC() {
            super("ECDHC", BouncyCastleProvider.CONFIGURATION);
        }
    }

    public static class ECDSA
    extends EC {
        public ECDSA() {
            super("ECDSA", BouncyCastleProvider.CONFIGURATION);
        }
    }

    public static class ECMQV
    extends EC {
        public ECMQV() {
            super("ECMQV", BouncyCastleProvider.CONFIGURATION);
        }
    }
}

