/*
 * Decompiled with CFR 0.152.
 */
package org.kg.bouncycastle.dvcs;

import org.kg.bouncycastle.asn1.ASN1Encodable;
import org.kg.bouncycastle.asn1.ASN1OctetString;
import org.kg.bouncycastle.asn1.ASN1Sequence;
import org.kg.bouncycastle.asn1.cms.ContentInfo;
import org.kg.bouncycastle.asn1.cms.SignedData;
import org.kg.bouncycastle.asn1.dvcs.DVCSObjectIdentifiers;
import org.kg.bouncycastle.cms.CMSSignedData;
import org.kg.bouncycastle.dvcs.DVCSConstructionException;
import org.kg.bouncycastle.dvcs.DVCSMessage;

public class DVCSResponse
extends DVCSMessage {
    private org.kg.bouncycastle.asn1.dvcs.DVCSResponse asn1;

    public DVCSResponse(CMSSignedData signedData) throws DVCSConstructionException {
        this(SignedData.getInstance(signedData.toASN1Structure().getContent()).getEncapContentInfo());
    }

    public DVCSResponse(ContentInfo contentInfo) throws DVCSConstructionException {
        super(contentInfo);
        if (!DVCSObjectIdentifiers.id_ct_DVCSResponseData.equals(contentInfo.getContentType())) {
            throw new DVCSConstructionException("ContentInfo not a DVCS Request");
        }
        try {
            this.asn1 = contentInfo.getContent().toASN1Primitive() instanceof ASN1Sequence ? org.kg.bouncycastle.asn1.dvcs.DVCSResponse.getInstance(contentInfo.getContent()) : org.kg.bouncycastle.asn1.dvcs.DVCSResponse.getInstance(ASN1OctetString.getInstance(contentInfo.getContent()).getOctets());
        }
        catch (Exception e) {
            throw new DVCSConstructionException("Unable to parse content: " + e.getMessage(), e);
        }
    }

    public ASN1Encodable getContent() {
        return this.asn1;
    }
}

