/*
 * Decompiled with CFR 0.152.
 */
package org.kg.bouncycastle.crypto.tls;

import java.math.BigInteger;
import org.kg.bouncycastle.crypto.BasicAgreement;
import org.kg.bouncycastle.crypto.agreement.DHBasicAgreement;
import org.kg.bouncycastle.crypto.agreement.ECDHBasicAgreement;
import org.kg.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.kg.bouncycastle.crypto.params.DHPrivateKeyParameters;
import org.kg.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.kg.bouncycastle.crypto.tls.AbstractTlsAgreementCredentials;
import org.kg.bouncycastle.crypto.tls.Certificate;
import org.kg.bouncycastle.util.BigIntegers;

public class DefaultTlsAgreementCredentials
extends AbstractTlsAgreementCredentials {
    protected Certificate certificate;
    protected AsymmetricKeyParameter privateKey;
    protected BasicAgreement basicAgreement;
    protected boolean truncateAgreement;

    public DefaultTlsAgreementCredentials(Certificate certificate, AsymmetricKeyParameter privateKey) {
        if (certificate == null) {
            throw new IllegalArgumentException("'certificate' cannot be null");
        }
        if (certificate.isEmpty()) {
            throw new IllegalArgumentException("'certificate' cannot be empty");
        }
        if (privateKey == null) {
            throw new IllegalArgumentException("'privateKey' cannot be null");
        }
        if (!privateKey.isPrivate()) {
            throw new IllegalArgumentException("'privateKey' must be private");
        }
        if (privateKey instanceof DHPrivateKeyParameters) {
            this.basicAgreement = new DHBasicAgreement();
            this.truncateAgreement = true;
        } else if (privateKey instanceof ECPrivateKeyParameters) {
            this.basicAgreement = new ECDHBasicAgreement();
            this.truncateAgreement = false;
        } else {
            throw new IllegalArgumentException("'privateKey' type not supported: " + privateKey.getClass().getName());
        }
        this.certificate = certificate;
        this.privateKey = privateKey;
    }

    public Certificate getCertificate() {
        return this.certificate;
    }

    public byte[] generateAgreement(AsymmetricKeyParameter peerPublicKey) {
        this.basicAgreement.init(this.privateKey);
        BigInteger agreementValue = this.basicAgreement.calculateAgreement(peerPublicKey);
        if (this.truncateAgreement) {
            return BigIntegers.asUnsignedByteArray(agreementValue);
        }
        return BigIntegers.asUnsignedByteArray(this.basicAgreement.getFieldSize(), agreementValue);
    }
}

