/*
 * Decompiled with CFR 0.152.
 */
package org.kg.bouncycastle.crypto.generators;

import java.math.BigInteger;
import org.kg.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.kg.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import org.kg.bouncycastle.crypto.KeyGenerationParameters;
import org.kg.bouncycastle.crypto.generators.DHKeyGeneratorHelper;
import org.kg.bouncycastle.crypto.params.DHParameters;
import org.kg.bouncycastle.crypto.params.ElGamalKeyGenerationParameters;
import org.kg.bouncycastle.crypto.params.ElGamalParameters;
import org.kg.bouncycastle.crypto.params.ElGamalPrivateKeyParameters;
import org.kg.bouncycastle.crypto.params.ElGamalPublicKeyParameters;

public class ElGamalKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private ElGamalKeyGenerationParameters param;

    public void init(KeyGenerationParameters param) {
        this.param = (ElGamalKeyGenerationParameters)param;
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        DHKeyGeneratorHelper helper = DHKeyGeneratorHelper.INSTANCE;
        ElGamalParameters egp = this.param.getParameters();
        DHParameters dhp = new DHParameters(egp.getP(), egp.getG(), null, egp.getL());
        BigInteger x = helper.calculatePrivate(dhp, this.param.getRandom());
        BigInteger y = helper.calculatePublic(dhp, x);
        return new AsymmetricCipherKeyPair(new ElGamalPublicKeyParameters(y, egp), new ElGamalPrivateKeyParameters(x, egp));
    }
}

