/*
 * Decompiled with CFR 0.152.
 */
package org.kg.bouncycastle.crypto.generators;

import java.math.BigInteger;
import org.kg.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.kg.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import org.kg.bouncycastle.crypto.KeyGenerationParameters;
import org.kg.bouncycastle.crypto.generators.DHKeyGeneratorHelper;
import org.kg.bouncycastle.crypto.params.DHKeyGenerationParameters;
import org.kg.bouncycastle.crypto.params.DHParameters;
import org.kg.bouncycastle.crypto.params.DHPrivateKeyParameters;
import org.kg.bouncycastle.crypto.params.DHPublicKeyParameters;

public class DHBasicKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private DHKeyGenerationParameters param;

    public void init(KeyGenerationParameters param) {
        this.param = (DHKeyGenerationParameters)param;
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        DHKeyGeneratorHelper helper = DHKeyGeneratorHelper.INSTANCE;
        DHParameters dhp = this.param.getParameters();
        BigInteger x = helper.calculatePrivate(dhp, this.param.getRandom());
        BigInteger y = helper.calculatePublic(dhp, x);
        return new AsymmetricCipherKeyPair(new DHPublicKeyParameters(y, dhp), new DHPrivateKeyParameters(x, dhp));
    }
}

