/*
 * Decompiled with CFR 0.152.
 */
package org.kg.bouncycastle.crypto.engines;

import org.kg.bouncycastle.crypto.CipherParameters;
import org.kg.bouncycastle.crypto.DataLengthException;
import org.kg.bouncycastle.crypto.OutputLengthException;
import org.kg.bouncycastle.crypto.StreamCipher;
import org.kg.bouncycastle.crypto.params.KeyParameter;
import org.kg.bouncycastle.crypto.util.Pack;

public class ISAACEngine
implements StreamCipher {
    private final int sizeL = 8;
    private final int stateArraySize = 256;
    private int[] engineState = null;
    private int[] results = null;
    private int a = 0;
    private int b = 0;
    private int c = 0;
    private int index = 0;
    private byte[] keyStream = new byte[1024];
    private byte[] workingKey = null;
    private boolean initialised = false;

    public void init(boolean forEncryption, CipherParameters params) {
        if (!(params instanceof KeyParameter)) {
            throw new IllegalArgumentException("invalid parameter passed to ISAAC init - " + params.getClass().getName());
        }
        KeyParameter p = (KeyParameter)params;
        this.setKey(p.getKey());
    }

    public byte returnByte(byte in) {
        if (this.index == 0) {
            this.isaac();
            this.keyStream = Pack.intToBigEndian(this.results);
        }
        byte out = (byte)(this.keyStream[this.index] ^ in);
        this.index = this.index + 1 & 0x3FF;
        return out;
    }

    public void processBytes(byte[] in, int inOff, int len, byte[] out, int outOff) {
        if (!this.initialised) {
            throw new IllegalStateException(String.valueOf(this.getAlgorithmName()) + " not initialised");
        }
        if (inOff + len > in.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (outOff + len > out.length) {
            throw new OutputLengthException("output buffer too short");
        }
        int i = 0;
        while (i < len) {
            if (this.index == 0) {
                this.isaac();
                this.keyStream = Pack.intToBigEndian(this.results);
            }
            out[i + outOff] = (byte)(this.keyStream[this.index] ^ in[i + inOff]);
            this.index = this.index + 1 & 0x3FF;
            ++i;
        }
    }

    public String getAlgorithmName() {
        return "ISAAC";
    }

    public void reset() {
        this.setKey(this.workingKey);
    }

    private void setKey(byte[] keyBytes) {
        this.workingKey = keyBytes;
        if (this.engineState == null) {
            this.engineState = new int[256];
        }
        if (this.results == null) {
            this.results = new int[256];
        }
        int i = 0;
        while (i < 256) {
            this.results[i] = 0;
            this.engineState[i] = 0;
            ++i;
        }
        this.c = 0;
        this.b = 0;
        this.a = 0;
        this.index = 0;
        byte[] t = new byte[keyBytes.length + (keyBytes.length & 3)];
        System.arraycopy(keyBytes, 0, t, 0, keyBytes.length);
        i = 0;
        while (i < t.length) {
            this.results[i >>> 2] = Pack.littleEndianToInt(t, i);
            i += 4;
        }
        int[] abcdefgh = new int[8];
        i = 0;
        while (i < 8) {
            abcdefgh[i] = -1640531527;
            ++i;
        }
        i = 0;
        while (i < 4) {
            this.mix(abcdefgh);
            ++i;
        }
        i = 0;
        while (i < 2) {
            int j = 0;
            while (j < 256) {
                int k = 0;
                while (k < 8) {
                    int n = k;
                    abcdefgh[n] = abcdefgh[n] + (i < 1 ? this.results[j + k] : this.engineState[j + k]);
                    ++k;
                }
                this.mix(abcdefgh);
                k = 0;
                while (k < 8) {
                    this.engineState[j + k] = abcdefgh[k];
                    ++k;
                }
                j += 8;
            }
            ++i;
        }
        this.isaac();
        this.initialised = true;
    }

    private void isaac() {
        this.b += ++this.c;
        int i = 0;
        while (i < 256) {
            int y;
            int x = this.engineState[i];
            switch (i & 3) {
                case 0: {
                    this.a ^= this.a << 13;
                    break;
                }
                case 1: {
                    this.a ^= this.a >>> 6;
                    break;
                }
                case 2: {
                    this.a ^= this.a << 2;
                    break;
                }
                case 3: {
                    this.a ^= this.a >>> 16;
                }
            }
            this.a += this.engineState[i + 128 & 0xFF];
            this.engineState[i] = y = this.engineState[x >>> 2 & 0xFF] + this.a + this.b;
            this.results[i] = this.b = this.engineState[y >>> 10 & 0xFF] + x;
            ++i;
        }
    }

    private void mix(int[] x) {
        x[0] = x[0] ^ x[1] << 11;
        x[3] = x[3] + x[0];
        x[1] = x[1] + x[2];
        x[1] = x[1] ^ x[2] >>> 2;
        x[4] = x[4] + x[1];
        x[2] = x[2] + x[3];
        x[2] = x[2] ^ x[3] << 8;
        x[5] = x[5] + x[2];
        x[3] = x[3] + x[4];
        x[3] = x[3] ^ x[4] >>> 16;
        x[6] = x[6] + x[3];
        x[4] = x[4] + x[5];
        x[4] = x[4] ^ x[5] << 10;
        x[7] = x[7] + x[4];
        x[5] = x[5] + x[6];
        x[5] = x[5] ^ x[6] >>> 4;
        x[0] = x[0] + x[5];
        x[6] = x[6] + x[7];
        x[6] = x[6] ^ x[7] << 8;
        x[1] = x[1] + x[6];
        x[7] = x[7] + x[0];
        x[7] = x[7] ^ x[0] >>> 9;
        x[2] = x[2] + x[7];
        x[0] = x[0] + x[1];
    }
}

