/*
 * Decompiled with CFR 0.152.
 */
package org.kg.bouncycastle.crypto.ec;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.kg.bouncycastle.crypto.CipherParameters;
import org.kg.bouncycastle.crypto.ec.ECPair;
import org.kg.bouncycastle.crypto.ec.ECPairFactorTransform;
import org.kg.bouncycastle.crypto.ec.ECUtil;
import org.kg.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.kg.bouncycastle.crypto.params.ParametersWithRandom;
import org.kg.bouncycastle.math.ec.ECPoint;

public class ECNewRandomnessTransform
implements ECPairFactorTransform {
    private ECPublicKeyParameters key;
    private SecureRandom random;
    private BigInteger lastK;

    public void init(CipherParameters param) {
        if (param instanceof ParametersWithRandom) {
            ParametersWithRandom p = (ParametersWithRandom)param;
            if (!(p.getParameters() instanceof ECPublicKeyParameters)) {
                throw new IllegalArgumentException("ECPublicKeyParameters are required for new randomness transform.");
            }
            this.key = (ECPublicKeyParameters)p.getParameters();
            this.random = p.getRandom();
        } else {
            if (!(param instanceof ECPublicKeyParameters)) {
                throw new IllegalArgumentException("ECPublicKeyParameters are required for new randomness transform.");
            }
            this.key = (ECPublicKeyParameters)param;
            this.random = new SecureRandom();
        }
    }

    public ECPair transform(ECPair cipherText) {
        if (this.key == null) {
            throw new IllegalStateException("ECNewRandomnessTransform not initialised");
        }
        BigInteger n = this.key.getParameters().getN();
        BigInteger k = ECUtil.generateK(n, this.random);
        ECPoint g = this.key.getParameters().getG();
        ECPoint gamma = g.multiply(k);
        ECPoint phi = this.key.getQ().multiply(k).add(cipherText.getY());
        this.lastK = k;
        return new ECPair(cipherText.getX().add(gamma).normalize(), phi.normalize());
    }

    public BigInteger getTransformValue() {
        return this.lastK;
    }
}

