/*
 * Decompiled with CFR 0.152.
 */
package org.kg.bouncycastle.cms.bc;

import org.kg.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.kg.bouncycastle.cms.CMSException;
import org.kg.bouncycastle.cms.KeyTransRecipient;
import org.kg.bouncycastle.cms.bc.CMSUtils;
import org.kg.bouncycastle.crypto.CipherParameters;
import org.kg.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.kg.bouncycastle.operator.OperatorException;
import org.kg.bouncycastle.operator.bc.BcRSAAsymmetricKeyUnwrapper;

public abstract class BcKeyTransRecipient
implements KeyTransRecipient {
    private AsymmetricKeyParameter recipientKey;

    public BcKeyTransRecipient(AsymmetricKeyParameter recipientKey) {
        this.recipientKey = recipientKey;
    }

    protected CipherParameters extractSecretKey(AlgorithmIdentifier keyEncryptionAlgorithm, AlgorithmIdentifier encryptedKeyAlgorithm, byte[] encryptedEncryptionKey) throws CMSException {
        BcRSAAsymmetricKeyUnwrapper unwrapper = new BcRSAAsymmetricKeyUnwrapper(keyEncryptionAlgorithm, this.recipientKey);
        try {
            return CMSUtils.getBcKey(unwrapper.generateUnwrappedKey(encryptedKeyAlgorithm, encryptedEncryptionKey));
        }
        catch (OperatorException e) {
            throw new CMSException("exception unwrapping key: " + e.getMessage(), e);
        }
    }
}

