/*
 * Decompiled with CFR 0.152.
 */
package org.kg.bouncycastle.cms;

import org.kg.bouncycastle.asn1.DEROctetString;
import org.kg.bouncycastle.asn1.cms.KEKIdentifier;
import org.kg.bouncycastle.asn1.cms.KEKRecipientInfo;
import org.kg.bouncycastle.asn1.cms.RecipientInfo;
import org.kg.bouncycastle.cms.CMSException;
import org.kg.bouncycastle.cms.RecipientInfoGenerator;
import org.kg.bouncycastle.operator.GenericKey;
import org.kg.bouncycastle.operator.OperatorException;
import org.kg.bouncycastle.operator.SymmetricKeyWrapper;

public abstract class KEKRecipientInfoGenerator
implements RecipientInfoGenerator {
    private final KEKIdentifier kekIdentifier;
    protected final SymmetricKeyWrapper wrapper;

    protected KEKRecipientInfoGenerator(KEKIdentifier kekIdentifier, SymmetricKeyWrapper wrapper) {
        this.kekIdentifier = kekIdentifier;
        this.wrapper = wrapper;
    }

    public final RecipientInfo generate(GenericKey contentEncryptionKey) throws CMSException {
        try {
            DEROctetString encryptedKey = new DEROctetString(this.wrapper.generateWrappedKey(contentEncryptionKey));
            return new RecipientInfo(new KEKRecipientInfo(this.kekIdentifier, this.wrapper.getAlgorithmIdentifier(), encryptedKey));
        }
        catch (OperatorException e) {
            throw new CMSException("exception wrapping content key: " + e.getMessage(), e);
        }
    }
}

