/*
 * Decompiled with CFR 0.152.
 */
package org.kg.bouncycastle.cms;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.kg.bouncycastle.asn1.ASN1Encodable;
import org.kg.bouncycastle.asn1.ASN1EncodableVector;
import org.kg.bouncycastle.asn1.ASN1InputStream;
import org.kg.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.kg.bouncycastle.asn1.ASN1Set;
import org.kg.bouncycastle.asn1.BEROctetStringGenerator;
import org.kg.bouncycastle.asn1.BERSet;
import org.kg.bouncycastle.asn1.DERSet;
import org.kg.bouncycastle.asn1.DERTaggedObject;
import org.kg.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.kg.bouncycastle.asn1.cms.ContentInfo;
import org.kg.bouncycastle.asn1.cms.OtherRevocationInfoFormat;
import org.kg.bouncycastle.asn1.ocsp.OCSPResponse;
import org.kg.bouncycastle.asn1.x509.Certificate;
import org.kg.bouncycastle.asn1.x509.CertificateList;
import org.kg.bouncycastle.cert.X509AttributeCertificateHolder;
import org.kg.bouncycastle.cert.X509CRLHolder;
import org.kg.bouncycastle.cert.X509CertificateHolder;
import org.kg.bouncycastle.cms.CMSException;
import org.kg.bouncycastle.cms.NullOutputStream;
import org.kg.bouncycastle.cms.SignerInfoGenerator;
import org.kg.bouncycastle.operator.DigestCalculator;
import org.kg.bouncycastle.util.Store;
import org.kg.bouncycastle.util.io.Streams;
import org.kg.bouncycastle.util.io.TeeInputStream;
import org.kg.bouncycastle.util.io.TeeOutputStream;

class CMSUtils {
    CMSUtils() {
    }

    static ContentInfo readContentInfo(byte[] input) throws CMSException {
        return CMSUtils.readContentInfo(new ASN1InputStream(input));
    }

    static ContentInfo readContentInfo(InputStream input) throws CMSException {
        return CMSUtils.readContentInfo(new ASN1InputStream(input));
    }

    static List getCertificatesFromStore(Store certStore) throws CMSException {
        ArrayList<Certificate> certs = new ArrayList<Certificate>();
        try {
            Iterator it = certStore.getMatches(null).iterator();
            while (it.hasNext()) {
                X509CertificateHolder c = (X509CertificateHolder)it.next();
                certs.add(c.toASN1Structure());
            }
            return certs;
        }
        catch (ClassCastException e) {
            throw new CMSException("error processing certs", e);
        }
    }

    static List getAttributeCertificatesFromStore(Store attrStore) throws CMSException {
        ArrayList<DERTaggedObject> certs = new ArrayList<DERTaggedObject>();
        try {
            Iterator it = attrStore.getMatches(null).iterator();
            while (it.hasNext()) {
                X509AttributeCertificateHolder attrCert = (X509AttributeCertificateHolder)it.next();
                certs.add(new DERTaggedObject(false, 2, attrCert.toASN1Structure()));
            }
            return certs;
        }
        catch (ClassCastException e) {
            throw new CMSException("error processing certs", e);
        }
    }

    static List getCRLsFromStore(Store crlStore) throws CMSException {
        ArrayList<CertificateList> certs = new ArrayList<CertificateList>();
        try {
            Iterator it = crlStore.getMatches(null).iterator();
            while (it.hasNext()) {
                X509CRLHolder c = (X509CRLHolder)it.next();
                certs.add(c.toASN1Structure());
            }
            return certs;
        }
        catch (ClassCastException e) {
            throw new CMSException("error processing certs", e);
        }
    }

    static Collection getOthersFromStore(ASN1ObjectIdentifier otherRevocationInfoFormat, Store otherRevocationInfos) {
        ArrayList<DERTaggedObject> others = new ArrayList<DERTaggedObject>();
        Iterator it = otherRevocationInfos.getMatches(null).iterator();
        while (it.hasNext()) {
            OCSPResponse resp;
            ASN1Encodable info = (ASN1Encodable)it.next();
            if (CMSObjectIdentifiers.id_ri_ocsp_response.equals(otherRevocationInfoFormat) && (resp = OCSPResponse.getInstance(info)).getResponseStatus().getValue().intValue() != 0) {
                throw new IllegalArgumentException("cannot add unsuccessful OCSP response to CMS SignedData");
            }
            others.add(new DERTaggedObject(false, 1, new OtherRevocationInfoFormat(otherRevocationInfoFormat, info)));
        }
        return others;
    }

    static ASN1Set createBerSetFromList(List derObjects) {
        ASN1EncodableVector v = new ASN1EncodableVector();
        Iterator it = derObjects.iterator();
        while (it.hasNext()) {
            v.add((ASN1Encodable)it.next());
        }
        return new BERSet(v);
    }

    static ASN1Set createDerSetFromList(List derObjects) {
        ASN1EncodableVector v = new ASN1EncodableVector();
        Iterator it = derObjects.iterator();
        while (it.hasNext()) {
            v.add((ASN1Encodable)it.next());
        }
        return new DERSet(v);
    }

    static OutputStream createBEROctetOutputStream(OutputStream s, int tagNo, boolean isExplicit, int bufferSize) throws IOException {
        BEROctetStringGenerator octGen = new BEROctetStringGenerator(s, tagNo, isExplicit);
        if (bufferSize != 0) {
            return octGen.getOctetOutputStream(new byte[bufferSize]);
        }
        return octGen.getOctetOutputStream();
    }

    private static ContentInfo readContentInfo(ASN1InputStream in) throws CMSException {
        try {
            return ContentInfo.getInstance(in.readObject());
        }
        catch (IOException e) {
            throw new CMSException("IOException reading content.", e);
        }
        catch (ClassCastException e) {
            throw new CMSException("Malformed content.", e);
        }
        catch (IllegalArgumentException e) {
            throw new CMSException("Malformed content.", e);
        }
    }

    public static byte[] streamToByteArray(InputStream in) throws IOException {
        return Streams.readAll(in);
    }

    public static byte[] streamToByteArray(InputStream in, int limit) throws IOException {
        return Streams.readAllLimited(in, limit);
    }

    static InputStream attachDigestsToInputStream(Collection digests, InputStream s) {
        InputStream result = s;
        Iterator it = digests.iterator();
        while (it.hasNext()) {
            DigestCalculator digest = (DigestCalculator)it.next();
            result = new TeeInputStream(result, digest.getOutputStream());
        }
        return result;
    }

    static OutputStream attachSignersToOutputStream(Collection signers, OutputStream s) {
        OutputStream result = s;
        Iterator it = signers.iterator();
        while (it.hasNext()) {
            SignerInfoGenerator signerGen = (SignerInfoGenerator)it.next();
            result = CMSUtils.getSafeTeeOutputStream(result, signerGen.getCalculatingOutputStream());
        }
        return result;
    }

    static OutputStream getSafeOutputStream(OutputStream s) {
        return s == null ? new NullOutputStream() : s;
    }

    static OutputStream getSafeTeeOutputStream(OutputStream s1, OutputStream s2) {
        return s1 == null ? CMSUtils.getSafeOutputStream(s2) : (s2 == null ? CMSUtils.getSafeOutputStream(s1) : new TeeOutputStream(s1, s2));
    }
}

