/*
 * Decompiled with CFR 0.152.
 */
package org.kg.bouncycastle.cert.ocsp;

import java.util.Date;
import org.kg.bouncycastle.asn1.ASN1Sequence;
import org.kg.bouncycastle.asn1.ocsp.ResponseData;
import org.kg.bouncycastle.asn1.ocsp.SingleResponse;
import org.kg.bouncycastle.asn1.x509.Extensions;
import org.kg.bouncycastle.cert.ocsp.OCSPUtils;
import org.kg.bouncycastle.cert.ocsp.RespID;
import org.kg.bouncycastle.cert.ocsp.SingleResp;

public class RespData {
    private ResponseData data;

    public RespData(ResponseData data) {
        this.data = data;
    }

    public int getVersion() {
        return this.data.getVersion().getValue().intValue() + 1;
    }

    public RespID getResponderId() {
        return new RespID(this.data.getResponderID());
    }

    public Date getProducedAt() {
        return OCSPUtils.extractDate(this.data.getProducedAt());
    }

    public SingleResp[] getResponses() {
        ASN1Sequence s = this.data.getResponses();
        SingleResp[] rs = new SingleResp[s.size()];
        int i = 0;
        while (i != rs.length) {
            rs[i] = new SingleResp(SingleResponse.getInstance(s.getObjectAt(i)));
            ++i;
        }
        return rs;
    }

    public Extensions getResponseExtensions() {
        return this.data.getResponseExtensions();
    }
}

