/*
 * Decompiled with CFR 0.152.
 */
package org.kg.bouncycastle.asn1.esf;

import java.util.Enumeration;
import org.kg.bouncycastle.asn1.ASN1Object;
import org.kg.bouncycastle.asn1.ASN1Primitive;
import org.kg.bouncycastle.asn1.ASN1Sequence;
import org.kg.bouncycastle.asn1.DERSequence;
import org.kg.bouncycastle.asn1.esf.OcspResponsesID;

public class OcspListID
extends ASN1Object {
    private ASN1Sequence ocspResponses;

    public static OcspListID getInstance(Object obj) {
        if (obj instanceof OcspListID) {
            return (OcspListID)obj;
        }
        if (obj != null) {
            return new OcspListID(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    private OcspListID(ASN1Sequence seq) {
        if (seq.size() != 1) {
            throw new IllegalArgumentException("Bad sequence size: " + seq.size());
        }
        this.ocspResponses = (ASN1Sequence)seq.getObjectAt(0);
        Enumeration e = this.ocspResponses.getObjects();
        while (e.hasMoreElements()) {
            OcspResponsesID.getInstance(e.nextElement());
        }
    }

    public OcspListID(OcspResponsesID[] ocspResponses) {
        this.ocspResponses = new DERSequence(ocspResponses);
    }

    public OcspResponsesID[] getOcspResponses() {
        OcspResponsesID[] result = new OcspResponsesID[this.ocspResponses.size()];
        int idx = 0;
        while (idx < result.length) {
            result[idx] = OcspResponsesID.getInstance(this.ocspResponses.getObjectAt(idx));
            ++idx;
        }
        return result;
    }

    public ASN1Primitive toASN1Primitive() {
        return new DERSequence(this.ocspResponses);
    }
}

