/*
 * Decompiled with CFR 0.152.
 */
package com.kgofd.ofd.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;
import org.apache.tools.zip.ZipOutputStream;

public class ZipUtil {
    private static final String ENCODE = System.getProperty("sun.jnu.encoding");
    private static final String ZIP = ".zip";
    private static final int BUFFER_SIZE = 512000;

    public static void compress(String srcPath, String destPath) throws IOException {
        ZipUtil.compress(new File(srcPath), new File(destPath), null, null);
    }

    public static void compress(String srcPath, String destPath, String comment) throws IOException {
        ZipUtil.compress(new File(srcPath), new File(destPath), comment, null);
    }

    public static void compress(File srcFile, File destFile, String comment) throws IOException {
        ZipUtil.compress(srcFile, destFile, comment, null);
    }

    public static void compress(File srcFile, File destFile, String comment, List<String> filter) throws IOException {
        ArrayList<File> fileList = new ArrayList<File>();
        fileList.add(srcFile);
        ZipUtil.compress(fileList, destFile, comment, filter, false);
    }

    public static void compress(List<File> fileList, File destFile, String comment, List<String> filter) throws IOException {
        ZipUtil.compress(fileList, destFile, comment, filter, false);
    }

    public static void compress(List<File> fileList, File destFile, String comment, List<String> filter, boolean ignoreError) throws IOException {
        if (destFile.isDirectory()) {
            String name = String.valueOf(destFile.getName()) + ZIP;
            destFile = new File(destFile, name);
            if (filter == null) {
                filter = new ArrayList<String>();
            }
            filter.add(name);
        }
        ZipOutputStream zos = new ZipOutputStream((OutputStream)new FileOutputStream(destFile));
        try {
            zos.setEncoding(ENCODE);
            for (File file : fileList) {
                if (fileList.size() == 1) {
                    ZipUtil.compress(zos, file, "", comment, filter, ignoreError);
                    continue;
                }
                ZipUtil.compress(zos, file, file.getName(), comment, filter, ignoreError);
            }
        }
        finally {
            zos.close();
        }
    }

    public static void addFileToZip(File zipFile, File file, String entryPath) throws IOException {
        ZipUtil.addFileToZip(zipFile, new File[]{file}, new String[]{entryPath});
    }

    public static void addFileToZip(File zipFile, File[] files, String[] entryPaths) throws IOException {
        File tempFile = File.createTempFile(zipFile.getName(), null);
        tempFile.delete();
        boolean renameOk = zipFile.renameTo(tempFile);
        if (!renameOk) {
            throw new RuntimeException("could not rename the file " + zipFile.getAbsolutePath() + " to " + tempFile.getAbsolutePath());
        }
        ZipUtil.addFileToZip(tempFile, zipFile, files, entryPaths);
    }

    public static void addFileToZip(File srcZip, File destZip, File[] files, String[] entryPaths) throws IOException {
        byte[] buffer = new byte[512000];
        ZipFile zipFile = new ZipFile(srcZip);
        ZipOutputStream out = new ZipOutputStream((OutputStream)new FileOutputStream(destZip));
        try {
            out.setEncoding(ENCODE);
            Enumeration e = zipFile.getEntries();
            while (e.hasMoreElements()) {
                ZipEntry entry = (ZipEntry)e.nextElement();
                String name = entry.getName();
                boolean notInFiles = true;
                String entryName = "";
                int i = 0;
                while (i < files.length) {
                    File file = files[i];
                    if (entryPaths != null && i < entryPaths.length) {
                        entryName = entryPaths[i];
                    }
                    if ((String.valueOf(entryName) + "/" + file.getName()).equals(name)) {
                        notInFiles = false;
                        break;
                    }
                    ++i;
                }
                if (!notInFiles) continue;
                out.putNextEntry(new ZipEntry(name));
                InputStream is = zipFile.getInputStream(entry);
                int length = 0;
                while ((length = is.read(buffer, 0, 512000)) != -1) {
                    out.write(buffer, 0, length);
                }
            }
            String entryName = "";
            int i = 0;
            while (i < files.length) {
                File file = files[i];
                if (entryPaths != null && i < entryPaths.length) {
                    entryName = entryPaths[i];
                }
                if (file.isDirectory()) {
                    ZipUtil.compress(out, file, entryName, "", null, false);
                } else {
                    ZipUtil.compress(out, file, String.valueOf(entryName) + "/" + file.getName(), "", null, false);
                }
                ++i;
            }
        }
        finally {
            zipFile.close();
            out.close();
        }
    }

    public static void compress(ZipOutputStream out, File srcFile, String name, String comment, List<String> filter, boolean ignoreError) throws IOException {
        block10: {
            if (!srcFile.exists()) {
                throw new IOException(String.valueOf(srcFile.getAbsolutePath()) + " E_FILE_NOT_EXISTS");
            }
            try {
                if (srcFile.isDirectory()) {
                    File[] files = srcFile.listFiles();
                    String string = name = name.length() == 0 ? "" : String.valueOf(name) + "/";
                    if (!ZipUtil.isFilter(name, filter) && name.length() != 0) {
                        out.putNextEntry(new ZipEntry(name));
                    }
                    File[] fileArray = files;
                    int n = files.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File file = fileArray[n2];
                        ZipUtil.compress(out, file, String.valueOf(name) + file.getName(), comment, filter, ignoreError);
                        ++n2;
                    }
                    break block10;
                }
                if (ZipUtil.isFilter(name, filter)) break block10;
                name = name.length() == 0 ? srcFile.getName() : name;
                ZipEntry zipEntry = new ZipEntry(name);
                zipEntry.setComment(comment);
                out.putNextEntry(zipEntry);
                FileInputStream in = null;
                try {
                    in = new FileInputStream(srcFile);
                    int length = 0;
                    byte[] buffer = new byte[512000];
                    while ((length = in.read(buffer, 0, 512000)) != -1) {
                        out.write(buffer, 0, length);
                    }
                }
                finally {
                    in.close();
                }
            }
            catch (IOException e) {
                if (ignoreError) break block10;
                throw e;
            }
        }
    }

    private static boolean isFilter(String base, List<String> filter) {
        if (filter != null && !filter.isEmpty()) {
            int i = 0;
            while (i < filter.size()) {
                Pattern pat = Pattern.compile(filter.get(i));
                Matcher mat = pat.matcher(base);
                if (mat.find()) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static void uncompress(String srcPath, String destDir, boolean deleteFile) throws IOException {
        ZipUtil.uncompress(new File(srcPath), new File(destDir), deleteFile);
    }

    public static void uncompress(File srcFile, File destDir, boolean deleteFile) throws IOException {
        if (!srcFile.exists()) {
            throw new IOException(String.valueOf(srcFile.getAbsolutePath()) + " E_FILE_NOT_EXISTS");
        }
        if (destDir.isFile()) {
            throw new IOException("E_ZIPUTIL_UNZIPPATHCANNOTFILE");
        }
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(srcFile, ENCODE);
            Enumeration e = zipFile.getEntries();
            while (e.hasMoreElements()) {
                ZipEntry zipEntry = (ZipEntry)e.nextElement();
                if (zipEntry.isDirectory()) {
                    String name = zipEntry.getName();
                    name = name.substring(0, name.length() - 1);
                    File f = new File(destDir, name);
                    f.mkdirs();
                    continue;
                }
                File f = new File(destDir, zipEntry.getName());
                f.getParentFile().mkdirs();
                f.createNewFile();
                InputStream is = null;
                FileOutputStream fos = null;
                try {
                    is = zipFile.getInputStream(zipEntry);
                    fos = new FileOutputStream(f);
                    int length = 0;
                    byte[] buffer = new byte[512000];
                    while ((length = is.read(buffer, 0, 512000)) != -1) {
                        fos.write(buffer, 0, length);
                    }
                }
                finally {
                    fos.close();
                }
            }
        }
        finally {
            zipFile.close();
        }
        if (deleteFile) {
            srcFile.deleteOnExit();
        }
    }

    public static String getZipComment(String filePath) throws IOException {
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(filePath, ENCODE);
            Enumeration e = zipFile.getEntries();
            String comment = "";
            while (e.hasMoreElements()) {
                ZipEntry ze = (ZipEntry)e.nextElement();
                comment = ze.getComment();
                if (comment != null && !comment.equals("") && !comment.equals("null")) break;
            }
            String string = comment;
            return string;
        }
        finally {
            zipFile.close();
        }
    }

    public static void main(String[] args) {
    }
}

