/*
 * Decompiled with CFR 0.152.
 */
package com.kgofd.ofd.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class FileUtil {
    public static boolean deleteFolder(String sPath) {
        File file = new File(sPath);
        if (!file.exists()) {
            return false;
        }
        if (file.isFile()) {
            return FileUtil.deleteFile(sPath);
        }
        return FileUtil.deleteDirectory(sPath);
    }

    private static boolean deleteFile(String sPath) {
        boolean flag = false;
        File file = new File(sPath);
        if (file.isFile() && file.exists()) {
            flag = file.delete();
        }
        return flag;
    }

    private static boolean deleteDirectory(String sPath) {
        File dirFile;
        if (!sPath.endsWith(File.separator)) {
            sPath = String.valueOf(sPath) + File.separator;
        }
        if (!(dirFile = new File(sPath)).exists() || !dirFile.isDirectory()) {
            return false;
        }
        boolean flag = true;
        File[] files = dirFile.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File ff = fileArray[n2];
                if (ff.isFile() ? !(flag = FileUtil.deleteFile(ff.getAbsolutePath())) : !(flag = FileUtil.deleteDirectory(ff.getAbsolutePath()))) break;
                ++n2;
            }
        }
        if (!flag) {
            return false;
        }
        return dirFile.delete();
    }

    public static List<File> getFileSort(String path) {
        List<File> list = FileUtil.getFiles(path, new ArrayList<File>());
        if (list != null && list.size() > 0) {
            Collections.sort(list, new Comparator<File>(){

                @Override
                public int compare(File file, File newFile) {
                    if (file.lastModified() > newFile.lastModified()) {
                        return 1;
                    }
                    if (file.lastModified() == newFile.lastModified()) {
                        return 0;
                    }
                    return -1;
                }
            });
        }
        return list;
    }

    public static List<File> getFiles(String realpath, List<File> files) {
        File realFile = new File(realpath);
        if (realFile.isDirectory()) {
            File[] subfiles;
            File[] fileArray = subfiles = realFile.listFiles();
            int n = subfiles.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    FileUtil.getFiles(file.getAbsolutePath(), files);
                } else {
                    files.add(file);
                }
                ++n2;
            }
        }
        return files;
    }
}

