/*
 * Decompiled with CFR 0.152.
 */
package com.kgofd.ofd.signinter.impl;

import com.alibaba.fastjson.JSONObject;
import com.kgofd.encrypt.KGBase64;
import com.kgofd.ofd.core.SesSignature;
import com.kgofd.ofd.signinter.SignatureInterByGB;
import com.kgofd.ofd.utils.ConnectStampSystemUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import org.kg.bouncycastle.asn1.ASN1InputStream;
import org.kg.bouncycastle.asn1.ASN1Sequence;
import org.kg.bouncycastle.asn1.DERBitString;
import org.kg.bouncycastle.asn1.DEROctetString;
import org.kg.bouncycastle.asn1.DLSequence;

public class SignatureInterByGBImpl
extends SignatureInterByGB {
    private String url;
    private String salt;
    private String appid;
    private String sealCode;
    private String orderId;
    private String title;

    public SignatureInterByGBImpl(String url, String salt, String appid, String sealCode, String orderId, String title) {
        this.url = url;
        this.salt = salt;
        this.appid = appid;
        this.sealCode = sealCode;
        this.orderId = orderId;
        this.title = title;
    }

    @Override
    public byte[] sign(byte[] hash, Map<String, Object> map) {
        JSONObject retObj = null;
        try {
            ConnectStampSystemUtil cUtil = new ConnectStampSystemUtil(this.url, this.salt, this.appid, this.sealCode, this.orderId, this.title, (String)map.get("xmlPath"));
            retObj = cUtil.textSign(hash);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        KGBase64 base64 = new KGBase64();
        byte[] sigdata = base64.decode(retObj.getString("sigData"));
        if (this.timeStampInter != null) {
            ASN1InputStream asn1InputStream = new ASN1InputStream(sigdata);
            try {
                ASN1Sequence sequence = (ASN1Sequence)asn1InputStream.readObject();
                asn1InputStream.close();
                DLSequence toSign = (DLSequence)sequence.getObjectAt(0);
                DEROctetString oct = (DEROctetString)sequence.getObjectAt(1);
                byte[] cert = oct.getOctets();
                DERBitString derbit = (DERBitString)sequence.getObjectAt(3);
                byte[] signature = derbit.getBytes();
                byte[] timestamp = this.timeStampInter.getTimeStamp(signature);
                sigdata = SesSignature.getSesSignature(toSign, cert, signature, timestamp).getEncoded();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return sigdata;
    }
}

