/*
 * Decompiled with CFR 0.152.
 */
package com.kgofd.ofd.signinter;

import com.kgofd.encrypt.KGBase64;
import com.kgofd.encrypt.KGSM3Digest;
import com.kgofd.ofd.core.GMSesSignature;
import com.kgofd.ofd.core.SesSignature;
import com.kgofd.ofd.enmu.KGHashType;
import com.kgofd.ofd.executes.OfdElectronicSeal4KG;
import com.kgofd.ofd.signinter.SignatureInter;
import com.kgofd.ofd.signinter.SignatureInterBase;
import com.kgofd.ofd.utils.ServerSignUtil;
import java.io.IOException;
import java.io.InputStream;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.io.ZipInputStream;
import org.kg.bouncycastle.asn1.ASN1Primitive;
import org.kg.bouncycastle.asn1.ASN1Sequence;
import org.kg.bouncycastle.asn1.DERSequence;
import org.kg.bouncycastle.asn1.DLSequence;
import org.kg.bouncycastle.asn1.x509.X509CertificateStructure;

public class SignatureInterByServer
extends SignatureInterBase
implements SignatureInter {
    protected byte[] cer;
    private String url;
    private String keysn;
    private String signsn;
    private KGHashType hashType = KGHashType.HASH_TYPE_SM3;

    public SignatureInterByServer(OfdElectronicSeal4KG ofdElectronicSeal4KG, String url) {
        this.ofdElectronicSeal4KG = ofdElectronicSeal4KG;
        this.url = url;
    }

    public SignatureInterByServer(OfdElectronicSeal4KG ofdElectronicSeal4KG, String url, String keysn) {
        this.ofdElectronicSeal4KG = ofdElectronicSeal4KG;
        this.url = url;
        this.keysn = keysn;
    }

    public SignatureInterByServer() {
    }

    public void setCer(byte[] cer) {
        this.cer = cer;
    }

    public void setCer(InputStream is) throws IOException {
        byte[] cer = null;
        try {
            try {
                cer = new byte[is.available()];
                is.read(cer);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            is.close();
        }
        this.cer = cer;
    }

    public void setHashType(KGHashType hashType) {
        this.hashType = hashType;
    }

    public KGHashType getHashType() {
        return this.hashType;
    }

    public String getKeysn() {
        return this.keysn;
    }

    public void setKeysn(String keysn) {
        this.keysn = keysn;
    }

    public String getSignsn() {
        return this.signsn;
    }

    public void setSignsn(String signsn) {
        this.signsn = signsn;
    }

    @Override
    public X509CertificateStructure getCer() throws IOException {
        if (this.cer == null) {
            String certBase64 = ServerSignUtil.getCertFromISignatureServer(this.url, this.keysn);
            KGBase64 base64 = new KGBase64();
            this.cer = base64.decode(certBase64);
        }
        X509CertificateStructure cert = new X509CertificateStructure((ASN1Sequence)ASN1Primitive.fromByteArray((byte[])this.cer));
        return cert;
    }

    @Override
    public String getSignMethod() {
        String signMethod = null;
        if (this.hashType == KGHashType.HASH_TYPE_SM3) {
            signMethod = "1.2.156.10197.1.501";
        } else if (this.hashType == KGHashType.HASH_TYPE_SHA1) {
            signMethod = "SHA1WithRSA";
        }
        return signMethod;
    }

    @Override
    public String getDigestMethod() {
        String digestMethod = null;
        if (this.hashType == KGHashType.HASH_TYPE_SM3) {
            digestMethod = "1.2.156.10197.1.401";
        } else if (this.hashType == KGHashType.HASH_TYPE_SHA1) {
            digestMethod = "SHA1";
        }
        return digestMethod;
    }

    @Override
    public byte[] getDigestData(ZipInputStream zis) throws IOException {
        byte[] digestData = null;
        if (this.hashType == KGHashType.HASH_TYPE_SM3) {
            digestData = KGSM3Digest.getSm3Digest(zis);
        } else if (this.hashType == KGHashType.HASH_TYPE_SHA1) {
            digestData = this.getSHA1HashData(zis);
        }
        return digestData;
    }

    @Override
    public byte[] getToSignData(String signDirPath, ZipFile zipFile, String timeInfo) throws IOException, ZipException {
        ZipInputStream signatureXmlInStream = zipFile.getInputStream(zipFile.getFileHeader(String.valueOf(signDirPath) + "/Signature.xml"));
        byte[] dataHash = null;
        if (this.hashType == KGHashType.HASH_TYPE_SM3) {
            dataHash = KGSM3Digest.getSm3Digest(signatureXmlInStream);
        } else if (this.hashType == KGHashType.HASH_TYPE_SHA1) {
            dataHash = this.getSHA1HashData(signatureXmlInStream);
        }
        DERSequence sequence = null;
        sequence = ((String)localversion.get()).equals("4") ? SesSignature.getToSignData((byte[])local.get(), timeInfo, dataHash, "/" + signDirPath + "/Signature.xml") : GMSesSignature.getGMToSignData((byte[])local.get(), timeInfo, dataHash, "/" + signDirPath + "/Signature.xml", this.cer, this.hashType);
        return sequence.getEncoded();
    }

    @Override
    public byte[] getSignData(byte[] toSignData) throws IOException {
        KGBase64 base64 = new KGBase64();
        String signResult = null;
        signResult = this.keysn != null && !"".equals(this.keysn) ? ServerSignUtil.signByISignatureServerSM2(this.url, base64.encode(toSignData), this.keysn) : ServerSignUtil.signByZzkkServer(this.url, base64.encode(toSignData));
        return base64.decode(signResult);
    }

    @Override
    public byte[] createDatFile(byte[] toSignData, byte[] signData, String signDirPath) throws IOException {
        DLSequence sequence = (DLSequence)ASN1Primitive.fromByteArray((byte[])toSignData);
        DERSequence sesSignature = null;
        if (((String)localversion.get()).equals("4")) {
            sequence = (DLSequence)ASN1Primitive.fromByteArray((byte[])toSignData);
            byte[] timestamp = null;
            if (this.timeStampInter != null) {
                timestamp = this.timeStampInter.getTimeStamp(signData);
            }
            sesSignature = SesSignature.getSesSignature(sequence, this.cer, signData, timestamp);
        } else {
            sesSignature = GMSesSignature.getGMSesSignature(sequence, signData);
        }
        return sesSignature.getEncoded();
    }

    protected byte[] dealSignData(byte[] sign) throws IOException {
        byte[] signature = null;
        try {
            ASN1Sequence sequence = (ASN1Sequence)DLSequence.fromByteArray((byte[])sign);
            signature = new byte[64];
            byte[] temp1 = sequence.getObjectAt(0).toASN1Primitive().getEncoded();
            if (temp1.length == 35) {
                System.arraycopy(temp1, 3, signature, 0, 32);
            } else if (temp1.length == 34) {
                System.arraycopy(temp1, 2, signature, 0, 32);
            } else {
                System.arraycopy(temp1, 1, signature, 0, 32);
            }
            byte[] temp2 = sequence.getObjectAt(1).toASN1Primitive().getEncoded();
            if (temp2.length == 35) {
                System.arraycopy(temp2, 3, signature, 32, 32);
            } else if (temp2.length == 34) {
                System.arraycopy(temp2, 2, signature, 32, 32);
            } else {
                System.arraycopy(temp2, 1, signature, 32, 32);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return signature;
    }
}

